
import java.awt.geom.*;

/*This class gets the polyhedra for the polygon exchange map. 
  We have a 1-parameter family of polygon exchanges, and they
  fit together to make a fiber bundle which is an affine polyhedron
  exchange*/

public class DataPartitionExtra {

    /**These are the domains.  F1 is the fiber bundle
       X[1/4,2], and F2 is the 90-degree rotation of F1.*/


    public static LongPolyhedron domainF1() {
	int[][] t=domainF1Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,51,85,170,204,240};
	P.FACE=f;
	P.VOLUME= 3500658000L;
	return(P);
    }


    public static LongPolyhedron domainF2() {
	int[][] t=domainF1Int();
	t=DataSymmetry.rotate(t);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,51,85,170,204,240};
	P.FACE=f;
	P.VOLUME= 3500658000L;
	return(P);
    }


    /**This is the hex domain A[1/4,1].  In the paper this
      intersects the fiber over s in the hexagon A^*.  This
      hexagon has the form 

            A  union (central tiles) union iota(A)

      where A is the symmetric pentagon and iota is 
      reflection in the origin.  The domain X is
      partitioned as

            X = A union B union C

      where C=iota(B).  This is used in Calculation 1.*/


    public static LongPolyhedron A() {
	int[][] t=AInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,101,147,193,282,556,776,1008};
	P.FACE=f;
	return(P);
    }

    /**This is the symmetric piece B[1/4,1]*/

    public static LongPolyhedron B() {
	int[][] t=BInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,30,45,51,56};
	P.FACE=f;
	return(P);
    }

    /**This is the rotated image of B[1/4,1]*/
    public static LongPolyhedron iotaB() {
	int[][] t=BInt();
	t=DataSymmetry.reflect(t);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,30,45,51,56};
	P.FACE=f;
	return(P);
    }

    /**This is the symmetric piece P[1/4,1/2]*/

    public static LongPolyhedron P() {
	int[][] t=PInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,13,25,51,76,102,120};
	P.FACE=f;
	return(P);
    }


    /**This is the rotated image of P[1/4,1/2]*/

    public static LongPolyhedron iotaP() {
	int[][] t=PInt();
	t=DataSymmetry.reflect(t);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,13,25,51,76,102,120};
	P.FACE=f;
	return(P);
    }

    /**This is the symmetric piece Q[1/4,1/2]*/

    public static LongPolyhedron Q() {
	int[][] t=QInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,11,13,14};
	P.FACE=f;
	return(P);
    }

    /**This is the rotated image of Q[1/4,1/2]*/

    public static LongPolyhedron iotaQ() {
	int[][] t=QInt();
	t=DataSymmetry.reflect(t);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={7,11,13,14};
	P.FACE=f;
	return(P);
    }

    /**This is the trivial tile from 1/2 to 3/4*/


    public static LongPolyhedron triv1() {
	int[][] t=triv1Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
        int[] f={255,448,515,897,1036,1546,2096,2400,3092,3840};
	P.FACE=f;
	return(P);
    }

    /**This is the domain F1 from 5/4 to 2*/

    public static LongPolyhedron domainF3() {
	int[][] t=domainF3Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,51,85,170,204,240};
	P.FACE=f;
	return(P);
    }

    /**This is the domain F1 from 1/2 to 3/4*/

    public static LongPolyhedron domainF4() {
	int[][] t=domainF4Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,51,85,170,204,240};
	P.FACE=f;
	return(P);
    }

    /**This is the order 2 tile from 3/4 to 1*/

    public static LongPolyhedron order2A() {
	int[][] t=order2AInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={7,13,19,25,30};
	P.FACE=f;
	return(P);
    }

    public static LongPolyhedron order2B() {
	int[][] t=order2BInt();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	int[] f={15,19,22,25,28};
	P.FACE=f;
	return(P);
    }

    /**This is the polyhedron Z[1,5/4]*/

    public static LongPolyhedron Z1() {
	int[][] t=Z1Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	return(P);
    }

    /**This is the polyhedron Z^*[3/4,1]*/
    public static LongPolyhedron Z2() {
	int[][] t=Z2Int();
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,t);
	P.MOVE=null;
	return(P);
    }


    /***Here is the raw integer list generating the polyhedra above.*/


    /**This is the domain F1: The polyhedron whose fibers are X_t for
      1/4<=t<=2.*/

    public static int[][] domainF1Int() {
	int[][] t={{-5,4,-1,4,1,4},{3,4,-1,4,1,4},{-3,4,1,4,1,4},{5,4,1,4,1,4},{-3,1,-2,1,2,1},{-1,1,-2,1,2,1},{1,1,2,1,2,1},{3,1,2,1,2,1}};
    return(t);
    }

    /**This is the domain F1 from 5/4 to 2*/

    public static int[][] domainF3Int() {
	int[][] t={{-9,4,-5,4,5,4},{9,4,5,4,5,4},{-1,4,-5,4,5,4},{1,4,5,4,5,4},{-3,1,-2,1,2,1},{-1,1,-2,1,2,1},{1,1,2,1,2,1},{3,1,2,1,2,1}};
    return(t);
    }


    /**This is the domain F1 from 1/2 to 3/4*/

    public static int[][] domainF4Int() {
	int[][] t={{-3,2,-1,2,1,2},{1,2,-1,2,1,2},{3,2,1,2,1,2},{-1,2,1,2,1,2},{-7,4,-3,4,3,4},{1,4,-3,4,3,4},{7,4,3,4,3,4},{-1,4,3,4,3,4}};
    return(t);
    }


    /**The symmetric pieces*/

    public static int[][] AInt() {
	int[][] t={{3,4,1,4,1,4},{-3,4,1,4,1,4},{-3,4,-1,4,1,4},{3,4,-1,4,1,4},{1,1,0,1,1,4},{-1,1,0,1,1,4},{0,1,1,1,1,1},{1,1,0,1,1,1},{-1,1,0,1,1,1},{0,1,-1,1,1,1}};
    return(t);
    }

    public static int[][] BInt() {
	int[][] t={{-3,4,-1,4,1,4},{-1,1,0,1,1,4},{-5,4,-1,4,1,4},{-2,1,-1,1,1,1},{-1,1,0,1,1,1},{0,1,-1,1,1,1}};
    return(t);
    }

    public static int[][] PInt() {
	int[][] t={{-3,4,-1,4,1,4},{-1,4,-1,4,1,4},{-1,4,1,4,1,4},{-3,4,1,4,1,4},{-3,2,-1,2,1,2},{-1,2,-1,2,1,2},{-1,2,1,2,1,2}};
    return(t);
    }

    public static int[][] QInt() {
	int[][] t={{-5,4,-1,4,1,4},{-3,4,-1,4,1,4},{-3,4,1,4,1,4},{-3,2,-1,2,1,2}};
    return(t);
    }



    /**This is the trivial tile from [1/2] to [3/4]*/
    public static int[][] triv1Int() {
	int[][] t={{1,2,1,2,1,2},{-1,2,1,2,1,2},{-1,2,-1,2,1,2},{1,2,-1,2,1,2},{1,4,-3,4,3,4},{3,4,-1,4,3,4},{3,4,1,4,3,4},{1,4,3,4,3,4},{-3,4,1,4,3,4},{-1,4,3,4,3,4},{-3,4,-1,4,3,4},{-1,4,-3,4,3,4}};
    return(t);
    }

    /**This is the order2 tile from 3/4 to 1.*/

    public static int[][] order2AInt() {
	int[][] t={{-5,4,-3,4,3,4},{-3,4,-3,4,3,4},{-3,4,-1,4,3,4},{-5,4,-1,4,3,4},{-1,1,-1,1,1,1}};
	return(t);
    }

    /**This is the order2 tile from 1 to 3/2.*/

    public static int[][] order2BInt() {
	int[][] t={{-1,1,-1,1,1,1},{-1,2,-3,2,3,2},{-1,2,-1,2,3,2},{-3,2,-1,2,3,2},{-3,2,-3,2,3,2}};
	return(t);
    }

    /**This is the domain Z from 1 to 5/4*/

    public static int[][] Z1Int() {
	int[][] t={{-1,1,-1,1,1,1},{-2,1,-1,1,1,1},{-9,4,-5,4,5,4},{-5,4,-5,4,5,4},{-5,4,-3,4,5,4},{-7,4,-3,4,5,4}};
	return(t);
    }

    /**This is the domain Z^* from 3/4 to 1*/

    public static int[][] Z2Int() {
	int[][] t={{-7,4,-3,4,3,4},{-5,4,-3,4,3,4},{-5,4,-1,4,3,4},{-1,1,-1,1,1,1},{-2,1,-1,1,1,1}};
	return(t);
    }

}