import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class DocumentCanvas extends ScaleCanvas 
implements MouseListener {
    
    Manager M;
    String[] S=new String[500];
    String[] P=new String[500];
    int paragraphs;
    int linecount;
    String MAIN;
    ListenSquare F;
    SelectInteger I1,I2,I3,I4;
    Integer[] J=new Integer[200];
    ListenSquare L;
    Color COLOR1;
    Color COLOR2;
    
    public DocumentCanvas() {
        addMouseListener(this);
        setBackground(Color.black);

        I2=new SelectInteger(25,5,40,20,0,0,199,1);
        I4=new SelectInteger(115,5,40,20,5,1,20,1);
        I3=new SelectInteger(205,5,40,20,12,8,22,1);


        for(int i=0;i<=199;++i) J[i]=new Integer(i);
        L=new ListenSquare(2,2,12,12,Color.black);
        L.on=1;
        paragraphs=0;
        setup();
	COLOR1=new Color(0,50,50);
	COLOR2=Color.white;
    }
    
    
    
    public int wordBreak(String A,int n) {
        String AA=new String();
        for(int i=n;i>0;--i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo(" ")==0) return(i);
        }
        return(n);
    }
    
    
    public void findBreaks(String A) {
        int count=0;
        int pos1=0;
        String AA=new String();
        for(int i=0;i<A.length();++i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo("\n")==0) {
                P[count]=A.substring(pos1,i);
                ++count;
                pos1=i;
            }
        }
        P[count]=A.substring(pos1,A.length());
        ++count;
        paragraphs=count;
    }
    
    
    
    public void paragraphDisplay(String A,int n) {
        
        int L=A.length();
        String AA=new String();
        int pos1=0;
        int pos2=0;
        int count=0;
        int LL=L;
        while(LL>0) {
            pos2=pos1+n;
            if(pos2>=L) {
                S[count+linecount]=A.substring(pos1,L);
                LL=0;
            }
            
            if(pos2<L) {
                pos2=wordBreak(A,pos2);
                S[count+linecount]=A.substring(pos1,pos2);
                ++count;
                LL=LL-(pos2-pos1);
                pos1=pos2;
            }
        }
        linecount=linecount+count+1;
    }
    
    
    
    
    
    public void display(int n) {
        for(int i=0;i<=499;++i) S[i]="";
        findBreaks(MAIN);
        linecount=0;
        for(int i=0;i<paragraphs;++i) {
            paragraphDisplay(P[i],n);
        }
    }
    
    
    
    public void paint(Graphics gfx) {
        
        
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);

	g.setColor(COLOR1);
	g.fillRect(30,50,getWidth()-31,getHeight()-22);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(3));
	g.drawRect(30,50,getWidth()-31,getHeight()-22);
	g.setStroke(new BasicStroke(1));
        
        L.infoRender(g);
        I2.render(g,Color.blue,Color.white,new Color(100,180,255));
        I3.render(g,Color.blue,Color.white,new Color(100,180,255));
        I4.render(g,Color.blue,Color.white,new Color(100,180,255));

	g.setColor(new Color(100,180,255));
	g.drawString("scroll pos",20,40);
	g.drawString("scroll stepsize",100,40);
	g.drawString("font size",210,40);
        
        g.setFont(new Font("Helvetica",Font.PLAIN,I3.val));
        int space=I3.val+3;
	display(2*getWidth()/(2+I3.val));
        Dimension D=this.getSize();
        for(int i=0;i<=499;++i) {
            
            if(45+space*i<D.height-space+5) {
                g.setColor(new Color(100,180,255));
                g.drawString(J[i+I2.val].toString(),5,68+space*i);
		g.setColor(COLOR2);
                g.drawString(S[i+I2.val],35,68+space*i);
            }
        }
    }
    
    
    
    
    
    
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();

        I2.modify(X);
        I3.modify(X);
        I4.modify(X);
        I2.step=I4.val;
        if(L.inside(X)==1) setup();
        repaint();
    }
    
    public void setup() {
        I2.val=0;
	String S="OctaPET\n\n";
        S=S+"Richard Evan Schwartz\n";
	S=S+"program started: July 2012\n";
	S=S+"Last updated: 5 Sept 2012\n\n";

	    S=S+"\n\nOPERATING THIS WINDOW\n\n";

	    S=S+"This window gives explanations for the rest of the program.\n   1. scroll the text using the left arrow keys at the top.\n   2. change the scroll stepsize using the middle arrow keys at the top.\n   3. change the text size using the right arrow keys at the top.\n\n";	 
                     S=S+"You should probably read the rest of this introduction before starting to play with the program.\n\n";


	    S=S+"PURPOSE OF OctaPET\n\n";

	    S=S+"The general purpose of OctaPET is to explore the structure of a renormalizable family of 2-dimensional double lattice PETs. This program is the companion to my recent paper, 'Renormalization and Hyperbolic symmetry in a family of double lattice PETs.' \n\n  A double lattice PET is a polytope exchange transformations based on a pair of lattices. To say that the family is renormalizable is to say that there is a certain map R from the parameter space to itself, such that the system at the parameter s is conjugate, in a certain sense, to the system at the parameter t=R(s).  Almost every orbit of R is dense, and R has the effect of decreasing the denominators of rational numbers. Using this property, one can use R to gain an inductive understanding of the whole system. This is what my paper is about.";

	    S=S+"\n\nGENERAL OPERATING INSTRUCTIONS\n\n";

	    S=S+"This program has 4 windows:\n   1. documentation (this window)\n   2. control panel (bottom left)   \n   3. PET window 1 (top left)\n   4. PET window 2 (bottom left). \n\n The two PET windows show the system for two parameters.  By adjusting these parameters you can see the renormalization phenomenon in action. ";

	S=S+"Most of the components of the program have little boxes with question marks in them.  When you click on these info buttons, this window will tell you about the corresponding component of the program.\n\n";

	S=S+"MOUSE COMPATABILITY\n\n";

	S=S+"OctaPET is designed to work best with a 3 button mouse. Generally speaking\n   1. clicking button 1 scales up the picture\n   2. clicking button 2 selects a new point in the window.\n   3. clicking button 3 scales down the picture.\nOn the control panel, all mouse clicks have the same effect.\n";
	S=S+"If you don't have a 3 button mouse, you can use the keyboard buttons z,x,c to simulate the 3 buttons when you are operating one of the picture windows. ";

	MAIN = new String(S);
    }
    
    public void setExplain(String doc) {
        I2.val=0;
        MAIN=doc;
        repaint();
    }
    
}

