import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class GraphicsHelp {




    /*This routine returns a color based on the congruence
      of k0 mod M.*/

    public static Color getColor(int k0,int M) {
	int k=k0%M;
	double d1=k*Math.sqrt(2);
	double d2=k*Math.sqrt(3);
	double d3=k*Math.sqrt(5);
	d1=d1-Math.floor(d1);
	d2=d2-Math.floor(d2);
	d3=d3-Math.floor(d3);
	int c1=(int)(255*d1);
	int c2=(int)(255*d2);
	int c3=(int)(255*d3);
	Color C=new Color(c1,c2,c3);
	return(C);
    }


    /*decides if a color is dark or light*/
    public static boolean isLight(Color C) {
	int r=C.getRed();
	int b=C.getBlue();
	int g=C.getGreen();
	if(r+b+g>600) return(true);
	return(false);
    }



    public static Complex[] getBounds(PolygonWrapper P) {
	GeneralPath gp=P.toGeneralPath();
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Float R1=(Rectangle2D.Float)(R0);
	Complex z1=new Complex(R1.x,R1.y);
	Complex z2=new Complex(R1.x+R1.getWidth(),R1.y+R1.getHeight());
	Complex[] Z={z1,z2};
	return(Z);
    }


    /**This is for semi-regular octagons.*/


    public static double shapeInvariant(GeneralPath gp1) {
	GeneralPath gp2=rotate(gp1);
	double t1=width(gp1);
	double t2=width(gp2);
	double t=t1/t2;
	t=t*Math.sqrt(2)-1;
	return(t);
    }


    public static GeneralPath rotate(GeneralPath gp) {
	double a=Math.PI/4;
	Complex u=new Complex(Math.cos(a),Math.sin(a));
	PolygonWrapper P=PolygonWrapper.fromGeneralPath(gp);
	Complex w=P.center();
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
            Q.z[i]=Complex.minus(P.z[i],w);
            Q.z[i]=Complex.times(Q.z[i],u);
            Q.z[i]=Complex.plus(Q.z[i],w);
	}
	return(Q.toGeneralPath());
    }

    public static double width(GeneralPath gp) {
	Rectangle2D R=gp.getBounds2D();
	return(R.getWidth());
    }

    public static Color shapeColor(GeneralPath gp) {
	PolygonWrapper P=PolygonWrapper.fromGeneralPath(gp);
	if(P.count==3) return(new Color(0,150,0));
	double t=shapeInvariant(gp);
	int r=(int)(255*t);
	int b=(int)(255-r);
	Color C=new Color(r,0,b);
	return(C);
    }

}




