import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;

/*This is the class of polyhedra we use for our
  exact integer calculations.*/


public class LongPolyhedron {
    LongVector[] V=new LongVector[20];
    int[] MOVE=new int[4];   //arithmetic graph fragment - determines F action
    int[] FACE;              //list of faces
    long SCALE;              //scale factor for the polyhedron
    int count;               //number of vertices
    long VOLUME;

    public LongPolyhedron() {}

    public LongPolyhedron(LongPolyhedron P) {
	this.count=P.count;
	for(int i=0;i<count;++i) V[i]=new LongVector(P.V[i]);
    }



    /*These routines have to do with getting the faces*/

    /*This creates a new polyhedron which is the ith face
      of the original polyhedron.*/

    public LongPolyhedron toFace(int q) {
	LongPolyhedron P=new LongPolyhedron();
	LongVector[] LIST=face(q);
	P.count=LIST.length;
	for(int i=0;i<P.count;++i) P.V[i]=LIST[i];
	P.FACE=null;
	P.MOVE=null;
	P.SCALE=this.SCALE;
	return(P);
    }

    /*Gets the list of vectors in the ith face*/

    public LongVector[] face(int i) {
	int a=FACE[i];
	return(LongPolyFace.getList(this,a));
    }

    /*For each vertex i, this routine decides which faces
      i belongs to*/


    public void facePrint() {
	for(int i=0;i<count;++i) {
	    System.out.print(i+" : ");
	    for(int j=0;j<FACE.length;++j) {
		if(inFace(i,j)==true) {
		    System.out.print(j+" ");
		}
	    }
	    System.out.println("");
	}
    }

    public boolean inFace(int i,int j) {
	int a=FACE[j];
	int[] b=Combinatorics.binaryList(count,a);
	for(int k=0;k<b.length;++k) {
	    if(i==b[k]) return(true);
	}
	return(false);
    }

    /**done with routines having to do with faces*/






    /**Converts an integer list into a polyhedron. Our polyhedra
       are stored as raw lists of integers.*/

    public static LongPolyhedron fromIntegerList(long scale,int[][] t) {
	LongPolyhedron P=new LongPolyhedron();
	P.SCALE=scale;
	P.count=t.length;
	for(int i=0;i<P.count;++i) {
	    P.V[i]=new LongVector();
	    for(int j=0;j<3;++j) {
		long a=scale*t[i][2*j];
        	checkDivision(a,t[i][2*j+1]);
		a=a/t[i][2*j+1];
		P.V[i].x[j]=a;
	    }
	}
	return(P);
    }
    
    /*This make sure we are only dividing numbers, as integers,
      when the one numbers goes evenly into the other.*/

    public static void checkDivision(long p,long q) {
	if(p%q!=0) {
	    System.out.println(p+" "+q);
            throw new ProofException("division fails");
	}
    }


    /*Converts a LongPolyhedron to an ordinary Polyhedron*/

    public Polyhedron toPolyhedron() {
	Polyhedron P=new Polyhedron();
	P.count=this.count;
	for(int i=0;i<count;++i) {
	    P.V[i]=new Vector();
	    P.V[i].size=3;
	    for(int j=0;j<3;++j) {
		P.V[i].x[j]=1.0*this.V[i].x[j]/SCALE;
	    }
	}
	return(P);
    }


    /*printint routines*/

    public void print() {
	System.out.println("----------------");
	System.out.println("long polyhedron");
	System.out.println("scale");
	System.out.println(SCALE);
	System.out.println("vectors");
	for(int i=0;i<count;++i) {
	    V[i].print();
	}
	System.out.println("faces");
	try{
	for(int i=0;i<FACE.length;++i) {
	    int[] t=Combinatorics.binaryList(count,FACE[i]);
	    printout(t);
	}
	}
	catch(Exception e) {
	    System.out.println("none listed");
	}
	System.out.println("action");
	try {printout(MOVE);}
	catch(Exception e) {
	    System.out.println("none listed");
	}

	System.out.println("----------------");
    }


    public void printout(int[] t) {
	for(int i=0;i<t.length;++i) System.out.print(t[i]+" ");
	System.out.println("");
    }

    /*to LaTeX*/

    public void texPrint(String S) {
	System.out.println("\\begin{eqnarray}");
	System.out.println("\\nonumber");
	System.out.print(S+"=");
	for(int i=0;i<count;++i) {
	    LongVector W=V[i];
	    System.out.print("\\left[\\matrix{");
	    System.out.print(W.x[0]+"\\cr ");
	    System.out.print(W.x[1]+"\\cr ");
	    System.out.print(W.x[2]+"}\\right]");
	}
	System.out.println("");
	System.out.println("\\end{eqnarray}");
	System.out.println("");
    }

}
