
(*These routines compute the recurrence relations
 for the chunks.  A chunk has one of 4 forms*)

  (*type 0,0: (2c+0,2d+0)
    type 1,0: (2c+1,2d+0)
    type 0,1: (2c+0,2d+1)
    type 1,1: (2c+1,2d+1)*)


 (* Here are the final formulas*)

R00[a1_,a2_]:=4 a1 a2 + 2 a1 + 1
Q00[a1_,a2_]:=2 a1 a2 + 1

R11[a1_,a2_]:=8 a1 a2 + 8 a2 -2 a1 - 8
Q11[a1_,a2_]:=2 a1 a2 + 2 a2 -1

Q01[a1_,a2_]:=2 a1 a2 + 1
R01[a1_,a2_]:=8 a1 a2 + 2a1 + 2

Q10[a1_,a2_]:=2 a1 a2 + 2 a2 -1
R10[a1_,a2_]:=4 a1 a2 + 4 a2 + 2 a1 -1

  (*Here are the growth ratios*)

T00[x_,y_]:=Log[R00[x,y]]/Log[Q00[x,y]]
T11[x_,y_]:=Log[R11[x,y]]/Log[Q11[x,y]]
T10[x_,y_]:=Log[R10[x,y]]/Log[Q10[x,y]]
T01[x_,y_]:=Log[R01[x,y]]/Log[Q01[x,y]]


 (* Here are the recurrences which compute them*)

MAKE11[a1_,a2_]:=(
Clear[r1,r2,r3,r4,r5,r6,a,b,q1,q2,q3,q4];
a = 2 a1 +1;
b = 2 a2 +1;
r1 = (a-2) r2 + 3 r3;
r2 = r3 + r4;
r3 = (b-3) r4 + r5;
q1 = (a+1) q2 - q3;
q2 = (b+1)/2 q3 - q4;
Expand[{q1,r1}])


MAKE10[a1_,a2_]:=(
Clear[r1,r2,r3,r4,r5,r6,a,b,q1,q2,q3,q4];
a = 2 a1 +1;
b = 2 a2;
r1 = (a-2) r2 + 3 r3;
r2 = r3 + r4;
r3 = b r4 + r5;
q1 = (a+1) q2 - q3;
q2 = b/2 q3 + q4;
Expand[{q1,r1}])


MAKE01[a1_,a2_]:=(
Clear[r1,r2,r3,r4,r5,r6,a,b,q1,q2,q3,q4];
a = 2 a1;
b = 2 a2+1;
r1 = a r2 + r3;
r2 = (b-2) r3 + 3 r4;
r3=r4+r5;
q1 = a q2 + q3;
q2 = (b+1)/2 q3 - q4;
Expand[{q1,r1}])

MAKE00[a1_,a2_]:=(
Clear[r1,r2,r3,r4,r5,r6,a,b,q1,q2,q3,q4];
a=2 a1;
b=2 a2;
r1=a r2 + r3;
r2=b r3 + r4;
q1=a q2 + q3;
q2=b/2 q3 + q4;
Expand[{q1,r1}])



  (*Prints out the exceptional pairs of chunks.*)

  BOUND=Log[72]/Log[9];

CH0111[i_,j_,k_,l_]:=Log[R01[i,j] R11[k,l]]/Log[Q01[i,j] Q11[k,l]]
LIST0111=Table[Table[Table[Table[CH0111[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH1011[i_,j_,k_,l_]:=Log[R10[i,j] R11[k,l]]/Log[Q10[i,j] Q11[k,l]]
LIST1011=Table[Table[Table[Table[CH1011[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];


CH0100[i_,j_,k_,l_]:=Log[R01[i,j] R00[k,l]]/Log[Q01[i,j] Q00[k,l]]
LIST0100=Table[Table[Table[Table[CH0100[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH1000[i_,j_,k_,l_]:=Log[R10[i,j] R00[k,l]]/Log[Q10[i,j] Q00[k,l]]
LIST1000=Table[Table[Table[Table[CH1000[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH0101[i_,j_,k_,l_]:=Log[R01[i,j] R01[k,l]]/Log[Q01[i,j] Q01[k,l]]
LIST0101=Table[Table[Table[Table[CH0101[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH1010[i_,j_,k_,l_]:=Log[R10[i,j] R10[k,l]]/Log[Q10[i,j] Q10[k,l]]
LIST1010=Table[Table[Table[Table[CH1010[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH1001[i_,j_,k_,l_]:=Log[R10[i,j] R01[k,l]]/Log[Q10[i,j] Q01[k,l]]
LIST1001=Table[Table[Table[Table[CH1001[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

CH0110[i_,j_,k_,l_]:=Log[R01[i,j] R10[k,l]]/Log[Q01[i,j] Q10[k,l]]
LIST0110=Table[Table[Table[Table[CH0110[i,j,k,l],{i,1,10}],{j,1,10}],{k,1,10}],{l,1,10}];

Print["0111 exceptions"];
Print[Position[Sign[LIST0111-BOUND],1]];

Print["1011 exceptions"];
Print[Position[Sign[LIST1011-BOUND],1]];

Print["0100 exceptions"];
Print[Position[Sign[LIST0100-BOUND],1]];

Print["1000 exceptions"];
Print[Position[Sign[LIST1000-BOUND],1]];

Print["0101 exceptions"];
Print[Position[Sign[LIST0101-BOUND],1]];

Print["1010 exceptions"];
Print[Position[Sign[LIST1010-BOUND],1]];

Print["0110 exceptions"];
Print[Position[Sign[LIST0110-BOUND],1]];

Print["1001 exceptions"];
Print[Position[Sign[LIST1001-BOUND],1]];
