
(*This file computes the recurrence relations for the
  exceptional pairs of chunks in the monograph.
  Here is the final routine.  The input to this routine
  is a pair such as {0,1,1,0},{2,1,2,3}.  The first pair
  gives the parities, and the second pair gives the values
  of {c1,d1,c2,d2}. The example given corresponds to the 
  pair (4)(3,1)(5,1)(6).*)


  (*Here is the final routine.  The output should be less than
   Log[72]/Log[9]*)
  GetBounds[A_,B_]:=(
      X=TotalRecurrence[A,2 (B+A)];
      Y1=X;
    {q1,q2,q3,q4,q5,q6,q7,q8,q9,q10}={1,1,1,1,1,1,1,1,1,1};
    {r1,r2,r3,r4,r5,r6,r7,r8,r9,r10}={1,1,1,1,1,1,1,1,1,1};
      Y2=X;
      Clear[q1,q2,q3,q4,q5,q6,q7,q8];
      Clear[r1,r2,r3,r4,r5,r6,r7,r8];
      Log[Y2[[2]]]/Log[Y2[[1]]])

  (*Here is the precursor to the final routine.*)
TotalRecurrence[A_,B_]:={SCFRecurrence[A,B],UnstableRecurrence[A,B]};


(*The number a is 0 or 1, and when the even number b is
  the amalgamation of two consecutive odd terms in the
  even expansion.  f1 recovers the even expansion from
  the parity and the sum*)

f1[a_,b_]:=If[a==0,b,{b-1,1}];

(*The input to this routine is a list A of parities and
a list B of even numbers. Together, this represents the
signed continued fraction.  The routine f2 recovers the
even expansion from the data A and B.*)

f2[A_,B_]:=(
l1=Table[f1[A[[j]],B[[j]]],{j,1,Length[A]}];
l2=Flatten[{100,l1}])

(*This works out the denominator of the signed
continued fraction for q1 as a function of q5 and q6*)

SCFRecurrence[A_,B_]:=(
Clear[q1,q2,q3,q4,q5,q6];
q1=If[A[[1]]==0,B[[1]] q2/1 + q3,B[[1]]/1 q2-q3];
q2=If[A[[2]]==0,B[[2]] q3/2 + q4,B[[2]]/2 q3-q4];
q3=If[A[[3]]==0,B[[3]] q4/1 + q5,B[[3]]/1 q4-q5];
q4=If[A[[4]]==0,B[[4]] q5/2 + q6,B[[4]]/2 q5-q6];
Expand[q1])

(*This works out that unstable period of r1, as a function
of r_j and r_{j+1} where j is the appropriate index.  The
value of j increases by 1 each time there is a parity of 1
in the list A. *)

UnstableRecurrence[A_,B_]:=(
Clear[r1,r2,r3,r4,r5,r6,r7,r8,r9,r10];
r={r1,r2,r3,r4,r5,r6,r7,r8,r9,r10};
B2=f2[A,B];
s=r;
For[i=1,i<Length[B2],i=i+1,s[[i]]=g[B2[[i]],B2[[i+1]],r,i]];
r=Take[r,Length[B2]-1];
r1=s[[1]];
r2=s[[2]];
r3=s[[3]];
r4=s[[4]];
r5=s[[5]];
r6=s[[6]];
r7=s[[7]];
r8=s[[8]];
r9=s[[9]];
Expand[r1])

(*This implemenets the local recurrence rule
 for the unstable period computation.*)

g[c1_,c2_,r_,i_]:=(
Clear[a0,a1,a2,a3,a4];
a0=g0[c1,c2,r,i];
a1=g1[c1,c2,r,i];
a2=g2[c1,c2,r,i];
a3=g3[c1,c2,r,i];
a4=g4[c1,c2,r,i];

If[((Mod[c1,2]==0)&&(Mod[c2,2]==0)),a0,
If[c2==1,a1,
If[((c1==1)&&(Mod[c2,2]==1)),a2,
If[((c1==1)&&(Mod[c2,2]==0)),a3,
a4]]]])

(*Here are the local recurrence rules for
the unstable period computation.*)

g0[c1_,c2_,r_,i_]:=   c2  r[[i+1]]+1 r[[i+2]];
g1[c1_,c2_,r_,i_]:=    1  r[[i+1]]+1 r[[i+2]];
g2[c1_,c2_,r_,i_]:=(c2-3) r[[i+1]]+3 r[[i+2]];
g3[c1_,c2_,r_,i_]:=(c2-1) r[[i+1]]+1 r[[i+2]];
g4[c1_,c2_,r_,i_]:=(c2-2) r[[i+1]]+3 r[[i+2]];

