#! /usr/local/bin/wish  -f

canvas .plot -width 800 -height 800 -bg white
canvas .post -width 800 -height 20 -bg white
pack .post
pack .plot
.plot create rectangle -10 -10 1000 1000 -fill white -outline white -tag bg
######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1
set BBOX 800

.plot create rectangle 0 0 800 800 -outline black -tag bb

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

.plot itemconfigure bg -fill white -outline white

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}
######################################


source tiling 
source grid



.post create rectangle 0 0 70 50 -fill green -tag export
.post create rectangle 200 0 270 50 -fill orange -tag bbox

.post bind up <Button-1> {.plot scale X 300 300 1 0.9}
.post bind up <Button-2> {.plot scale X 300 300 1 1.111111}
.post bind up <Button-3> {.plot scale X 300 300 1 1.111111}

.post bind bbox <Button-1> {
global BBOX
    set BBOX [expr $BBOX-50]
.plot delete bb
.plot create rectangle 0 0 800 $BBOX -outline black -tag bb

}

.post bind bbox <Button-3> {
global BBOX
    set BBOX [expr $BBOX+50]
.plot delete bb
.plot create rectangle 0 0 800 $BBOX -outline black -tag bb

}

.post bind bbox <Button-2> {
global BBOX
    set BBOX [expr $BBOX+50]
.plot delete bb
.plot create rectangle 0 0 800 $BBOX -outline black -tag bb

}



.post bind export <Any-Button> post
.post create text 8 13 -anchor w -text "export" -fill black -tag post
.post create text 208 13 -anchor w -text "bbox" -fill black -tag aspect

.plot scale X 0 0 400 -400
.plot move X 400 400
proc post {} {
global BBOX
.plot delete bb
.plot postscript -pageheight 800 \
-height $BBOX \
-file "temp.ps"
}
