import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PETCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M; 
    int TYPE;
    GeneralPath[] GP=new GeneralPath[100000];
    Color[] COLOR=new Color[100000];  
    int[] ORBIT=new int[100000];
    double[] TAG=new double[100000];
    int COUNT;
    int TILE_INDEX;   
    Point JX; 
    Output OUT;

     public PETCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(207,205,100);	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      OUT=new Output("Output/tiling");
      if(M.C.DISPLAY[TYPE].L[0].on==1) drawDomain(g,1);
      if(M.C.DISPLAY[TYPE].L[1].on==1) drawDomain(g,2);
      if(M.C.DISPLAY[TYPE].L[2].on==1) drawLattice(g,1);
      if(M.C.DISPLAY[TYPE].L[3].on==1) drawLattice(g,2);
      if(M.C.DISPLAY[TYPE].L[4].on==1) drawPartition(0,g);   
      if(M.C.DISPLAY[TYPE].L[5].on==1) drawPartition(1,g);   
      if(M.C.DISPLAY[TYPE].L[6].on==1) drawIndividual(g);
      drawTiles(g);   
      drawOctogrid(g);

      if(M.C.REGION.L[4].on==1) drawRenorm(g);
      if(M.C.REGION.L[5].on==1) drawMod1(g);
      if(M.C.REGION.L[6].on==1) drawMod2(g);
      for(int i=0;i<4;++i) {
          if(M.C.REGION.L[i].on==1) drawRegion(g,i);
      }
      drawMaps(g);
      drawSource(g);
      drawFrame(g);

   }

    public void drawMyPoly(Graphics2D g,PolygonWrapper P,Color C1,Color C2,int width) {
	GeneralPath gp=P.toGeneralPath();
	drawMyPoly(g,gp,C1,C2,width);
    }

    public void drawMyPoly(Graphics2D g,GeneralPath gp,Color C1,Color C2,int width) {
	gp=transform(gp);
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.setStroke(new BasicStroke(width));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }

    public void drawMyPoly2(Graphics2D g,PolygonWrapper P) {
	GeneralPath gp=P.toGeneralPath();
	drawMyPoly2(g,gp);
    }

    public void drawMyPoly2(Graphics2D g,GeneralPath gp) {
	OUT.polyWrite(gp,Color.white,Color.black);
	gp=transform(gp);
    }




    public void drawBG(Graphics2D g) {
	g.setColor(new Color(70,0,70));
	if(TYPE==1) g.setColor(new Color(0,0,100));
	g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawFrame(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	int y=this.getHeight();
	g.setColor(Color.white);
	g.drawString("z: zoom in",5,y-10);
	g.drawString("x: action",120,y-10);
	g.drawString("c: zoom out",220,y-10);
	g.drawString("a: coords",5,15);
	g.drawString("s: recolor",120,15);
	g.drawString("d: recolor orbit",220,15);
	g.drawString("r: reset",350,15);
    }

    public void drawTiles(Graphics2D g) {
	int count=0;
	Color COL2=Color.black;
	for(int i=0;i<COUNT;++i) {  
	    GeneralPath gp=new GeneralPath(GP[i]); 
            Color COL=COLOR[i];
	    OUT.polyWrite(gp,COL,COL2);
	    drawMyPoly(g,gp,COL,COL2,2);
	}
    }

    public boolean isTriangle(GeneralPath gp) {
	PolygonWrapper P=PolygonWrapper.fromGeneralPath(gp);
	if(P.count==3) return(true);
	return(false);
    }

    public void drawDomain(Graphics2D g,int choice) {
	double s=M.C.getParameter(TYPE);
	PolygonWrapper P=BasicAlgebra.domain(choice,s);
	drawMyPoly(g,P,M.C.DISPLAY[TYPE].M[0].C,Color.white,1);
    }


    public void drawLattice(Graphics2D g,int choice) {	
        double s=M.C.getParameter(TYPE);
	GeneralPath gp=new GeneralPath();
	Matrix m=BasicAlgebra.dynamicsLattice(choice,s);
	Color COL=M.C.DISPLAY[TYPE].M[1+choice].C;

	for(int i=-5;i<=5;++i) {
            gp.reset();
	    for(int j=-5;j<=5;++j) {
		double[] p={i,j};
		Vector V=new Vector(p);
		V=Matrix.act(m,V);
		Complex z=new Complex(V.x[0],V.x[1]);
		if(j==-5) gp.moveTo((float)(z.x),(float)(z.y));
		if(j>-5) gp.lineTo((float)(z.x),(float)(z.y));	
	    }
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
	for(int i=-5;i<=5;++i) {
            gp.reset();
	    for(int j=-5;j<=5;++j) {
		double[] p={j,i};
		Vector V=new Vector(p);
		V=Matrix.act(m,V);
		Complex z=new Complex(V.x[0],V.x[1]);
		drawPoint(g,z,.01,Color.white,8,true);
		if(j==-5) gp.moveTo((float)(z.x),(float)(z.y));
		if(j>-5) gp.lineTo((float)(z.x),(float)(z.y));	
	    }
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
    }


    public boolean drawRenorm(Graphics2D g) { 
        double s=M.C.getParameter(TYPE);
	for(int i=2;i<20;++i) {
	    if(s==1.0/i) return(false);
	}

        PolygonWrapper P1=Renormalize.renormRange(s);
        PolygonWrapper P2=Renormalize.renormRange(s);
	if(TYPE==1) {
	    P1=Renormalize.renormDomain(s);
	    P2=Renormalize.renormDomain(s);
	}
	for(int i=0;i<P2.count;++i) P2.z[i]=Complex.times(P2.z[i],new Complex(-1,0));
	Color C=M.C.REGION.M[4].C;
	drawMyPoly(g,P1,C,C,1);
	drawMyPoly(g,P1,C,C,1);
	return(true);
    }

    public boolean drawMod1(Graphics2D g) { 
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	if((s<1)||(s>4.0/3)) return(false);
	Color C=M.C.REGION.M[5].C;
        PolygonWrapper P1=Renormalize.mod1Range(s);
	drawMyPoly(g,P1,C,C,1);
	for(int i=0;i<P1.count;++i) P1.z[i]=new Complex(-P1.z[i].x,-P1.z[i].y);
	drawMyPoly(g,P1,C,C,1);
	return(true);
    }

    public boolean drawMod2(Graphics2D g) { 
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	if((s<1)||(s>4.0/3)) return(false);
	Color C=M.C.REGION.M[6].C;
        PolygonWrapper P1=Renormalize.mod2Range(s);
	drawMyPoly(g,P1,C,C,1);
	for(int i=0;i<P1.count;++i) P1.z[i]=new Complex(-P1.z[i].x,-P1.z[i].y);
	drawMyPoly(g,P1,C,C,1);
	return(true);
    }


    public boolean drawRegion(Graphics2D g,int choice) { 
	double[] bound={1,1,.5,.5};
	bound[2]=1;
	bound[3]=1;
        double s=M.C.getParameter(TYPE);
	PolygonWrapper P=new PolygonWrapper();
	if(choice==0) P=Symmetries.pieceALeft(s);
	if(choice==1) P=Symmetries.pieceBLeft(s);
	if(choice==2) P=Symmetries.piecePLeft(s);
	if(choice==3) P=Symmetries.pieceQLeft(s);
	if(P==null) return(false);
	if(s>bound[choice]) return(false);
	Color C=M.C.REGION.M[choice].C;
	drawMyPoly(g,P,C,C,1);
	return(true);
    }


    public boolean drawPartition(int choice,Graphics2D g) {
	Output OUT=new Output("Output/tiling");
	double s=M.C.getParameter(TYPE);
	if(s<1.0/4) {
	    return(false);
	}
	Color C=M.C.DISPLAY[TYPE].M[4].C;
	if(choice==1) C=M.C.DISPLAY[TYPE].M[5].C;
	for(int i=0;i<51;++i) {
	  LongPolyhedron X0=DataPartition.poly(i);
	  if(choice==1) X0=DataPartition.imagePoly(i);
	  Polyhedron X=X0.toPolyhedron();
	  drawSlice(g,X,s,C);
	  drawSlice(g,X,s,C,OUT);
	}
	return(true);
    }

    public boolean drawIndividual(Graphics2D g) {
	int p4=M.C.DISPLAY[TYPE].L[4].on;
	int p5=M.C.DISPLAY[TYPE].L[5].on;
	if(p4+p5!=1) return(false);
	Color C=M.C.DISPLAY[TYPE].M[6].C;
	int i=M.C.POLY.val;
	int j=M.C.FACE.val;
	  double s=M.C.getParameter(TYPE);
	  LongPolyhedron X0=DataPartition.poly(i);
	  if(p5==1) X0=DataPartition.imagePoly(i);
	  Polyhedron X=X0.toPolyhedron();
          drawSlice(g,X,s,C);

	  LongPolyhedron X1=X0.toFace(j);
          X=X1.toPolyhedron();
	  g.setStroke(new BasicStroke(3));
          drawSlice(g,X,s,Color.yellow);
          g.setStroke(new BasicStroke(1));
	  return(true);
    }

    public boolean drawMaps(Graphics2D g) {
	boolean block=false;
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	int v=M.C.MAP.mode;
	int[] lo={0,1,1,33,20};
	int[] hi={-1,32,19,51,32};
	for(int i=lo[v];i<hi[v];++i) {
	    LongPolyhedron X0=new LongPolyhedron();
	    Polyhedron X=new Polyhedron();

	    if(v==1) {
	       block=false;
               X0=DataPartition.imagePoly(i);
	       X0=ProofCalc3.phi(X0);
	       X=X0.toPolyhedron();
	       if(i==19) block=true;
	    }

	    if(v==2) {
               X0=DataPartition.imagePoly(i);
	       X0=ProofCalc4.phi(X0);
	       X=X0.toPolyhedron();
	    } 
 
	    if(v==3) {
               X0=DataPartition.poly(i);
               X0=DataSymmetry.modular1(X0); 
               X=X0.toPolyhedron();
	    }

	    if(v==4) {
               X0=DataPartition.poly(i);
               X0=DataSymmetry.modular2(X0); 
               X=X0.toPolyhedron();
	    }

	    if(block==false) drawSlice(g,X,s,new Color(255,0,0,150));
	}
	return(true);
    }

    public void drawSlice(Graphics2D g,Polyhedron X,double s,Color C) {
         PolygonWrapper P=PolyhedronSlicer.basicSlice(X,s);
	 if(P!=null) drawMyPoly(g,P,C,Color.white,1);
    }

    public void drawSlice(Graphics2D g,Polyhedron X,double s,Color C,Output OUT) {
         PolygonWrapper P=PolyhedronSlicer.basicSlice(X,s);
	 if(P!=null) drawMyPoly2(g,P);
    }


    /*these routines draw the octogrid.  It is
      something from my second paper.*/

    public boolean drawOctogrid(Graphics2D g) {	
        Output OUT2=new Output("Output/grid");
	if(TYPE==1) return(false);
	if(M.C.DISPLAY[0].L[7].on==0) return(false);
	double s=M.C.getParameter(0);
	if(s<=.25) return(false);
	if(s>=.5) return(false);
	Color C=M.C.DISPLAY[0].M[7].C;
	double t=Renormalize.renormReal(s);
	double v=t/(1+t);
	Complex z0=new Complex(-2*s,0);
	int K=Renormalize.getK2(s);
	for(int i=0;i<=K+1;++i) {
	    if(i%2==0) {
		  Complex z1=new Complex(i*v,0);
		  Complex z=Complex.plus(z0,z1);
	          drawStar3(g,z,C,OUT2);
	    }
	}

	for(int i=-K-1;i<=K+1;++i) {
	    if(i%2==0) {
		  Complex z1=new Complex(i*v,0);
		  Complex z=Complex.plus(z0,z1);
	          drawStar4(g,z,C,OUT2);
	    }
	}

	for(int i=-K+1;i<K;++i) {
	    Complex z1=new Complex(i*v,0);
	    Complex z=Complex.plus(z0,z1);
	    drawStar2(g,z,C,OUT2);
	}



	for(int i=-K+1;i<K;++i) {
	    Complex z1=new Complex(0,i*v);
	    Complex z=Complex.plus(z0,z1);
	    drawStar1(g,z,C,OUT2);
	}


	return(true);
    }  



    public void drawStar1(Graphics2D g,Complex z,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	gp.reset();
	gp.moveTo(-2,(float)(z.y));
	gp.lineTo(+2,(float)(z.y));
	OUT.lineWrite(gp,Color.white);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }


    public void drawStar2(Graphics2D g,Complex z,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	gp.reset();
	gp.moveTo((float)(z.x),-2);
	gp.lineTo((float)(z.x),+2);
	OUT.lineWrite(gp,Color.white);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);

    }


    public void drawStar3(Graphics2D g,Complex z,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	gp.reset();
	gp.moveTo((float)(z.x-1),(float)(z.y-1));
	gp.lineTo((float)(z.x+1),(float)(z.y+1));
	OUT.lineWrite(gp,Color.white);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }


    public void drawStar4(Graphics2D g,Complex z,Color C,Output OUT) {
	GeneralPath gp=new GeneralPath();
	gp.reset();
	gp.moveTo((float)(z.x+1),(float)(z.y-1));
	gp.lineTo((float)(z.x-1),(float)(z.y+1));
	OUT.lineWrite(gp,Color.white);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }





    public void getIndex() {
	TILE_INDEX=getIndex(SOURCE);
    }

    public int getIndex(Complex z) {
	int index=-1;
	for(int i=0;i<COUNT;++i) {
	    if(GP[i].contains(z.x,z.y)==true) index=i;
	}
	return(index);
    }

    public boolean recolor() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false);
        COLOR[t]=M.C.CS.C;
	return(true);
    }

    public boolean recolorOrbit() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false); 
        double tag=TAG[t];
        for(int i=0;i<COUNT;++i) {
	   if(TAG[i]==tag) COLOR[i]=M.C.CS.C;
	}
	return(true);
    }



    public boolean polyCoords() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false);
        PolygonWrapper P=PolygonWrapper.fromGeneralPath(GP[t]);
	polyCoords(P);
	M.C.repaint();
	return(true);
    }


    public boolean polyCoords(PolygonWrapper P) {
	int cx=0;
	int cy=0;
	for(int i=0;i<10;++i) M.C.MESSAGE[i]="";
	int orbit=ORBIT[TILE_INDEX];
	Integer O=new Integer(orbit);
	M.C.MESSAGE[11]="current period "+O.toString();
	int[] d=M.C.getFraction(TYPE);
	Integer D=new Integer(d[1]);
	for(int i=0;i<P.count;++i) {
	    int x=MathRational.convert(d[1]*P.z[i].x);
	    int y=MathRational.convert(d[1]*P.z[i].y);
	    cx=cx+x;
	    cy=cy+y;
	    Integer X=new Integer(x);
	    Integer Y=new Integer(y);
	    String S=X.toString()+"/"+D.toString();
	    S=S+"    "+Y.toString()+"/"+D.toString();
	    M.C.MESSAGE[i]=S;
	}
	if(P.count==3) return(false);
	if(cx%P.count!=0) throw new ProofException("bad integer division");
	if(cy%P.count!=0) throw new ProofException("bad integer division");
	cx=cx/P.count;
	cy=cy/P.count;

        Integer X=new Integer(cx);
	Integer Y=new Integer(cy);
	String S=X.toString()+"/"+D.toString();
	S=S+"    "+Y.toString()+"/"+D.toString();
	S="center "+S;
	M.C.MESSAGE[9]=S;
	M.C.repaint();
	return(true);
    }

    public void acceptTileDebug(PolygonWrapper P) {
	acceptTile(P,Color.red,0,0,false);
    }


    public void acceptTile(PolygonWrapper P,Color COL,int orbit,double tag,boolean block) {
	Complex z=P.center();
	int index=getIndex(z);
	if((block==false)||(index==-1)) {
	    GP[COUNT]=P.toGeneralPath();
	    ORBIT[COUNT]=orbit;
	    TAG[COUNT]=tag;
	    COLOR[COUNT]=COL;
	    ++COUNT;
	}
    }




    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	JX=J.X;
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {
	M.C.FOCUS=TYPE;
          if(mode==1)  {
             scaleUp(JX,0);
	  }

          if(mode==3)  {
            scaleUp(JX,1);
	  }

	  if(mode==2)  {
	    SOURCE=unTransform(JX);
	    M.C.doAction();
	  }

	  if(mode==4)  {
	    SOURCE=unTransform(JX);
	    polyCoords();
	  }

	  if(mode==5)  {
	    SOURCE=unTransform(JX);
	    recolor();
	  }

	  if(mode==6)  {
	    SOURCE=unTransform(JX);
	    recolorOrbit();
	  }

	  if(mode==7) {
	      M.C.CP.HALT=true;  //halt the computation if necessary
              COUNT=0;
	  }

        repaint();
    }


    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
    public void mouseDragged(MouseEvent e) {}



    public void keyTyped(KeyEvent e) {

	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(ch=='a') test=4;
	if(ch=='s') test=5;
	if(ch=='d') test=6;
	if(ch=='r') test=7;
	if(test>0) doMouseClick(test);
	repaint();
    }


    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

