import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ShapeEntrySystem {
    int x,y;
    String S;
    String HISTORY;
    boolean ACTIVE;
    ListenSquare MAIN,TEXT,FRACTION,CF,QI,EE,REDUCE;
    ListenSquare[] RAN=new ListenSquare[7];
    ListenSquare INFO;
    SelectInteger DEN;
    Color COLOR;
    SelectInteger TERMS;
    ControlPanelColor P;

    public ShapeEntrySystem(int xx,int yy,String s,Color C,ControlPanelColor PP) {
	this.x=xx;
	this.y=yy;
	this.S=s;
	TEXT=new ListenSquare(x,y,400,40);
	ACTIVE=false;
	COLOR=C;
	TERMS=new SelectInteger(x+255,y+20,35,18,5,1,20,1);

	FRACTION=new ListenSquare(x,y+20,48,18);
	REDUCE=new ListenSquare(x+50,y+20,43,18);
	QI=new ListenSquare(x+95,y+20,58,18);
	CF=new ListenSquare(x+198,y+20,40,18);
	EE=new ListenSquare(x+155,y+20,40,18);
        DEN=new SelectInteger(x+345,y+3,30,17,7,1,10,1);
        INFO=new ListenSquare(x+398,y+2,12,12);
	MAIN=new ListenSquare(x,y,415,40);
	for(int i=0;i<6;++i) {
	     RAN[i]=new ListenSquare(x+315+15*i,y+23,15,15);
	}

	HISTORY="";
	this.P=PP;
    }


    public void render(Graphics2D g) {

	drawBG(g);
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,13));
	g.drawString(S,x+5,y+15);
	TERMS.render(g,Color.blue,Color.white,Color.white,"");
	QI.render(g,Color.blue);
	CF.render(g,Color.blue);
	EE.render(g,Color.blue);
	FRACTION.render(g,Color.blue);
	REDUCE.render(g,Color.blue);
	for(int i=0;i<6;++i) {
	    RAN[i].render(g,new Color(0,0,150));
	}
	RAN[2].render(g,P.M[2].C);
	RAN[3].render(g,P.M[4].C);
	RAN[4].render(g,P.M[3].C);
	RAN[5].render(g,P.M[2].C);
        DEN.render(g,new Color(200,0,200),Color.white,Color.white,"");  
	INFO.infoRender(g);

	g.setColor(Color.white);
	g.drawString("cfe",(int)(CF.x+5),(int)(CF.y+13));
	g.drawString("ee",(int)(EE.x+5),(int)(EE.y+13));
	g.drawString("qi history",(int)(QI.x+5),(int)(QI.y+13));
	g.drawString("fraction",(int)(FRACTION.x+5),(int)(FRACTION.y+13));
	g.drawString("reduce",(int)(REDUCE.x+5),(int)(REDUCE.y+13));
	drawFrame(g);
    }

    public void drawBG(Graphics2D g) {
	g.setColor(COLOR);
	g.fillRect(x,y,410,40);
	g.setColor(Color.blue);
    }

    public void drawFrame(Graphics2D g) {
	int th=1;
	if(ACTIVE==true) {
              g.setColor(Color.yellow);
	      th=3;
	}
	g.setStroke(new BasicStroke(th));
	g.drawRect(x,y+2,410,39);	
	g.setStroke(new BasicStroke(1));
    }

    public void activate(Point X) {
	ACTIVE=false;
	if(TEXT.inside(X)==1) ACTIVE=true;
    }


    /**This decides if we are looking at
       0. a rational
       1. a quadratic irrational
       2. a continued fraction expansion.
       This isn't a very smart routine; it just
       looks for one characteristic feature.
       The routine returns -1 if there is more
       than one characteristic.*/

    public int classify() {
	int c0=countChar(S,'*');
	int c1=countChar(S,':');
	int c2=countChar(S,'/');
	int c3=countChar(S,'(');
	int c4=countChar(S,')');
	if((c0>0)&&(c1+c2+c3+c4>0)) return(-1);
	if((c1>0)&&(c0+c2+c3+c4>0)) return(-1);
	if(c3!=c4) return(-1);
	if(c0>0) return(3);
	if(c1>0) return(2);
	if(c3>0) return(1);
	return(0);
    }

    public int[] interpretFraction() {
	return(interpretFraction(S));
    }

    public int[] interpretFraction(String U) {
	int k=U.indexOf("/");
	if(k==-1) {
	    U=U.replace(" ","");
	    Integer I=new Integer(U);
	    int[] a={I.intValue(),1};
	    return(a);
	}
	String T1=U.substring(0,k);
	String T2=U.substring(k+1,U.length());
	Integer I1=new Integer(T1);
	Integer I2=new Integer(T2);
	int[] I={I1.intValue(),I2.intValue()};
	return(I);
    }


    public int[] interpretCFE() {
	int[] y=interpretSEQ(':');
	return(y);

    }
    public int[] interpretEE() {
	int[] y=interpretSEQ('*');
	return(y);
    }

    public int[] interpretSEQ(char u) {
	int count=1;
	int[] x=new int[50];
	x[0]=-1;
	int s=S.length();
	if(S.charAt(s-1)==u) S=S.substring(0,s-1);
	for(int i=0;i<s;++i) {
	    if(S.charAt(i)==u) {
		x[count]=i;
		++count;
	    }
	}
	x[count]=s;

	int[] y=new int[count];
	for(int i=0;i<count;++i) {
	    String T=S.substring(x[i]+1,x[i+1]);
	    Integer t=new Integer(T);
	    y[i]=t.intValue();
	}
	return(y);
    }



    public int[] interpretQI() {
	int k1=S.indexOf("+");
	int k2=S.indexOf("(");
	int k3=S.indexOf(")");
	String S1=S.substring(0,k1);
	String S2=S.substring(k1+1,k2);
	String S3=S.substring(k2+1,k3);

	S1=S1.replace(" ","");
	S2=S2.replace(" ","");
	S3=S3.replace(" ","");

	int[] a1=interpretFraction(S1);
	int[] a2=interpretFraction(S2);
	Integer b=new Integer(S3);
	int a3=b.intValue();
	int[] c={a1[0],a1[1],a2[0],a2[1],a3};
	return(c);

    }


    public int countChar(String T,char x) {
	int count=0;
	int n=T.length();
	for(int i=0;i<n;++i) {
	    char ch=T.charAt(i);
	    if(ch==x) ++count;
	}
	return(count);
    }

    public boolean convert(Point X) {
	int c=classify();

	if(CF.inside(X)==1) {
	    if(c==0) fractionToCFE();
	    if(c==1) qiToCFE();
	}

	if(EE.inside(X)==1) {
	    if(c==0) fractionToEE();
	}


	if(FRACTION.inside(X)==1) {
	    if(c==1) qiToFraction();
	    if(c==2) cfeToFraction();  
            if(c==3) eeToFraction();
	}

	if(QI.inside(X)==1) {
	    if(HISTORY.length()>0) S=new String(HISTORY);
	}

	return(true);
    }

    public boolean cfeToFraction() {
	int[] a=interpretCFE();
	long[] b=MathRational.toFraction(a);
	acceptFraction(b);
	return(true);
    }

    public boolean eeToFraction() {
	int[] a=interpretEE();
	int[] b=EvenExpansion.toFraction(a);
	acceptFraction(b);
	return(true);
    }



    public boolean qiToFraction() {
       int[] a=interpretQI();
       double d=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
       if(d<=0) return(false);
       double tol=Math.pow(.1,TERMS.val);
       MathRational P=MathRational.approximate0(d,tol);
       long[] p={P.p,P.q};	
       HISTORY=new String(S);
       acceptFraction(p);
       return(true);
    }



    public boolean fractionToCFE() {
       int[] a=interpretFraction();
       if(a[0]<=0) return(false);
       if(a[1]<=0) return(false);
       int[] b=MathRational.cfe(a);
       acceptCFE(b);
       return(true);
    }

    public boolean fractionToEE() {
       int[] a=interpretFraction();
       if(a[0]<=0) return(false);
       if(a[1]<=0) return(false);
       int[] b=EvenExpansion.toSequence(a);
       acceptEE(b);
       return(true);
    }



    public boolean qiToCFE() {
       int[] a=interpretQI();
       double d=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
       if(d<=0) return(false);
       double tol=Math.pow(.1,TERMS.val);
       int[] p=MathRational.approximate(d,tol);
       int[] b=MathRational.cfe(p);   
       HISTORY=new String(S);
       acceptCFE(b);
       return(true);
    }



    public void acceptCFE(int[] a) {
	acceptSEQ(a,":");
    }

    public void acceptEE(int[] a) {
	acceptSEQ(a,"*");
    }


    public boolean acceptSEQ(int[] a,String u) {
	if(a.length==1) return(false);
         String T="";
	 for(int i=0;i<a.length;++i) {
	    Integer A=new Integer(a[i]);
	    if(i<a.length-1) T=T+A.toString()+u;
	    else{T=T+A.toString();}
	 }
	 S=new String(T);
	 if(S.length()>35) S=S.substring(0,35);
	 return(true);
    }



    public boolean acceptFraction(int[] b) {
	long[] c={b[0],b[1]};
	acceptFraction(c);
	return(true);
    }

    public boolean acceptFraction(long[] b) {
	if(b[0]<=0) return(false);
	if(b[1]<=0) return(false);
	Long b0=new Long(b[0]);
	Long b1=new Long(b[1]);
	S=b0.toString()+"/"+b1.toString();
	return(true);
    }



    public void reduce() {
	int[] x=interpretFraction();
        int s=MathRational.GCD(x[0],x[1]);
	x[0]=x[0]/s;
	x[1]=x[1]/s;
	acceptFraction(x);
    }

    public void getRandom(int choice) {
	int lim=DEN.val;
	lim=(int)(Math.pow(2,lim));
	boolean test=false;
	while(test==false) {
	    double d1=2*Math.random();
	    double d2=Math.random();
	    d1=lim*d1;
	    d2=lim*d2;
	    int p=(int)(Math.min(d1,d2));
	    int q=(int)(Math.max(d1,d2));
	    p=2*p;
	    int d=MathRational.GCD(p,q);
	    p=p/d;
	    q=q/d;
	    int[] X={p,q};
	    double val=1.0*p/q;
	    boolean test2=inRange(choice,val);
	    if(MathRational.cfeSmall(X,15)==false) test2=false;
	    if(test2==true) {
		int[] I={p,q};
		acceptFraction(I);
	        test=true;
	    }
	}
    }





    /**the ranges are
     [0,1/4]
     [1/4,1/2]
     [1/2,3/4]
     [3/4,1]
     [1,5/4]
     [5/4,2]
     This funny scheme is dictated by
     the structure of our PET**/

    public boolean inRange(int k,double d) {
	double[] e={0,1.0/4,1.0/2,3.0/4,1,5.0/4,2};
	if((k==0)&&(d<e[1])) return(true);
	if((k==5)&&(d>e[5])) return(true);
	if((k==0)||(k==5)) return(false);
	if((d>e[k])&&(d<e[k+1])) return(true);
	return(false);
    }






    public double getParameter() {
	int c=classify();

	if(c==0) {
	    int[] b=interpretFraction();
	    double y=1.0*b[0]/b[1]; 
	    return(y);
	}

	if(c==1) { 
            int[] a=interpretQI();
            double y=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
	    return(y);
	}

	if(c==2) {
	   int[] a=interpretCFE();
	   long[] b=MathRational.toFraction(a);
	   double y=1.0*b[0]/b[1];
	   return(y);
	}

	if(c==3) {
	   int[] a=interpretEE();
	   int[] b=EvenExpansion.toFraction(a);
	   double y=1.0*b[0]/b[1];
	   return(y);
	}


	return(.5);
    }

    public int[] getFraction() {
	int q=classify();
	if(q==0) return(interpretFraction());
	if(q==2) {
	   int[] a=interpretCFE();
	   long[] b=MathRational.toFraction(a);
	   int[] c={(int)(b[0]),(int)(b[1])};
	   return(c);
	}	
           if(q==3) {
	   int[] a=interpretEE();
	   int[] b=EvenExpansion.toFraction(a);
	   int[] c={(int)(b[0]),(int)(b[1])};
	   return(c);
	}
	return(null);
    }



    /*testing whether the selector is used*/

    public boolean inside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(MAIN.inside(J.X)==1) return(true);
	return(false);
    }

    public boolean inside(Point X) {
	if(MAIN.inside(X)==1) return(true);
	return(false);
    }

    public boolean ranInside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(ranInside(J.X)==true) return(true);
	return(false);
    }

    public boolean ranInside(Point X) {
	for(int i=0;i<6;++i) {
	    if(RAN[i].inside(X)==1) return(true);
	}
	return(false);
    }






    public void process(MouseEvent e) {
	MouseData J=MouseData.process(e);
	activate(J.X);
	TERMS.modify(J.X);
	DEN.modify(J.X);
	try {
             convert(J.X);
	     if(REDUCE.inside(J.X)==1) reduce();
	     for(int i=0;i<7;++i) {
	       if(RAN[i].inside(J.X)==1) getRandom(i);
	     }
	}
        catch(Exception ee) {}
    }


    public boolean processKey(KeyEvent e) {
	if(ACTIVE==false) return(false);
	int n=S.length();

	char ch=e.getKeyChar();

        if(isDigit(ch)==true) S=S+ch;

	int val=0;
	val=(int)(ch-'/');
	if(val==0) S=S+"/";

	val=(int)(ch-'(');
	if(val==0) S=S+"(";

	val=(int)(ch-':');
	if(val==0) S=S+":";

	val=(int)(ch-'*');
	if(val==0) S=S+"*";

	val=(int)(ch-')');
	if(val==0) S=S+")";

	val=(int)(ch-'+');
	if(val==0) S=S+"+";

	val=(int)(ch-'-');
	if(val==0) S=S+"-";

	val=(int)(ch-' ');
	if(val==0) S=S+" ";


        if (ch==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

        if (ch==KeyEvent.VK_DELETE) {
            S="1/2";
        }

	//if((classify()==2)&&(S.charAt(0)!='0')) S="0:"+S;
	if(S.length()>50) S=S.substring(0,n-1);
	return(true);

    }

    public boolean isDigit(char ch) {
        int val=(int)(ch-'0');
        if ((val>=0)&&(val<=9)) {
	    return(true);
	}
	return(false);
    }





    /**This is for the purpose of transforming the parameter*/

    public void copy(ShapeEntrySystem X) {
	X.S=this.S;
    }

    public boolean renorm(ShapeEntrySystem X) {
	  int q=classify();
	  if(q==1) return(false);
	  if(q==0) {
             int[] a=interpretFraction();
	     int[] b=renormFraction(a);
	     X.acceptFraction(b);
	  }
	  return(true);
    }

    public boolean mod1(ShapeEntrySystem X) {
	  int q=classify();
	  if(q==1) return(false);
	  if(q==0) {
             int[] a=interpretFraction();
	     int[] b=mod1Fraction(a);
	     X.acceptFraction(b);
	  }
	  return(true);
    }

    public boolean mod2(ShapeEntrySystem X) {
	  int q=classify();
	  if(q==1) return(false);
	  if(q==0) {
             int[] a=interpretFraction();
	     int[] b=mod2Fraction(a);
	     X.acceptFraction(b);
	  }
	  return(true);
    }



    public static int[] renormFraction(int[] a) {

	if(a[0]>a[1]) {
           int[] b={a[0]-a[1],a[1]};  
           b=MathRational.reduce(b[0],b[1]);
	   return(b);
	}

          if(2*a[0]>a[1]) {
	    int[] b={a[1]-a[0],a[1]}; 
            b=MathRational.reduce(b[0],b[1]);
	    return(b);
	  }

	  if(2*a[0]<a[1]) {
	      int[] b={a[1],2*a[0]};
	      int t=(int)(.5*a[1]/a[0]);
	      b[0]=a[1]-2*t*a[0];
	      b=MathRational.reduce(b[0],b[1]);
	      return(b);
	  }

	  int[] b={1,2};
	  return(b);
    }


    public int[] mod2Fraction(int[] a) {
	if(a[0]>a[1]) return(a);
        int[] b={3*a[0]-2*a[1],2*a[0]-a[1]};
        b=MathRational.reduce(b[0],b[1]);
	return(b);
    }

    public int[] mod1Fraction(int[] a) {
	if(a[0]<a[1]) return(a);
        int[] b={a[0]-2*a[1],2*a[0]-3*a[1]};
        b=MathRational.reduce(b[0],b[1]);
	return(b);
    }



}





