import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class UnstableCounter {
    int[] k=new int[100];
    int length;
    long value;


    public UnstableCounter(int[] a) {
	this.k=a;
	this.length=a.length;
	this.value=1;
    }

    public UnstableCounter(UnstableCounter U) {
	for(int i=0;i<U.length;++i) this.k[i]=U.k[i];
	this.length=U.length;
	this.value=U.value;
    }

    /*This produces the period vector.  See the
      routine evaluate2 for more details.*/

    public static long[] main(int[] q) {
	UnstableCounter U1=new UnstableCounter(q);
	long[] p1=U1.evaluate2();
	int index=q.length-1;
	long[] p2={p1[1],p1[0]};

	if(q[index-1]==1) {
	    p2[1]=p2[1]-p2[0];
	}
	return(p2);
    }

    /*This is a static routine producing the period*/

    public static long periodBasic(int[] q) {
	UnstableCounter U=new UnstableCounter(q);
	long p=U.evaluate();
	return(p);
    }




    /*This produces the coefficents of the period
      vector for the unstable orbit. For instance,
      if the sequence is (a1,a2,a3,a4,a6,a6), then
      the coefficients A and B are such that

        period(a1,a2,a3,a4,a5,a6,b1,b2,...) = 
                  A period(a5,a6,b1,b2,...) +
                     B period(a6,b1,b2,...).
    */

    public long[] evaluate2() {
	UnstableCounter[] LIST=new UnstableCounter[200];
	long[] coeff=new long[2];
	LIST[0]=new UnstableCounter(this);
	int COUNT=1;
	long VALUE=0;
	while(COUNT>0) {
	    UnstableCounter CURRENT=LIST[COUNT-1];
	    if(CURRENT.length<=2) {
		int t=CURRENT.length-1;
		coeff[t]=coeff[t]+CURRENT.value;
		--COUNT;
	    }
	    if(CURRENT.length>2) {
		UnstableCounter[] TEMP=CURRENT.subdivide();
		LIST[COUNT-1]=new UnstableCounter(TEMP[0]);
		LIST[COUNT]=new UnstableCounter(TEMP[1]);
		++COUNT;
	    }
	}
	return(coeff);
    }

    /*This produces the period of the unstable orbit*/

    public long  evaluate() {
	UnstableCounter[] LIST=new UnstableCounter[200];
	LIST[0]=new UnstableCounter(this);
	int COUNT=1;
	long VALUE=0;
	while(COUNT>0) {
	    UnstableCounter CURRENT=LIST[COUNT-1];
	    if(CURRENT.length<=2) {
		VALUE=VALUE+CURRENT.evaluateEnd();
		--COUNT;
	    }
	    if(CURRENT.length>2) {
		UnstableCounter[] TEMP=CURRENT.subdivide();
		LIST[COUNT-1]=new UnstableCounter(TEMP[0]);
		LIST[COUNT]=new UnstableCounter(TEMP[1]);
		++COUNT;
	    }
	}
	return(VALUE);
    }


    /*This does the mechanics of the recursive rule.*/

    public UnstableCounter[] subdivide() {
	UnstableCounter[] X=new UnstableCounter[2];
	X[0]=new UnstableCounter(this);
	X[1]=new UnstableCounter(this);
	X[0].length=X[0].length-1;
	for(int i=0;i<X[0].length;++i) {
              X[0].k[i]=this.k[i+1];
	}
	X[1].length=X[1].length-2;
	for(int i=0;i<X[1].length;++i) {
             X[1].k[i]=this.k[i+2];
	}
	int[] t=this.getCoefficients();
	X[0].value=t[0]*this.value;
	X[1].value=t[1]*this.value;
	return(X);
    }


    /*This implements the basic rules for the
      unstable orbit counter.*/

    public int[] getCoefficients() {
	int[] c={0,0};
	int a=k[0];
	int b=k[1];

	if((a==1)&&(b%2==0)) {
	    c[0]=b-1;
	    c[1]=1;
	}

	if((a==1)&&(b%2==1)) {
	    c[0]=b-3;
	    c[1]=3;
	}

	if((a%2==0)&&(b%2==0)) {
	    c[0]=b;
	    c[1]=1;
	}

	if((a%2==0)&&(b%2==1)) {
	    c[0]=b-2;
	    c[1]=3;
	}


	if((a%2==1)&&(a>1)&&(b==1)) {
	    c[0]=1;
	    c[1]=1;
	}

	return(c);
    }

    /*This evaluates the length 1 and 2 sequences.*/

    public long evaluateEnd() {
	if(this.length==0) return(0);
	if(this.length==1) return(value);
	if(k[0]%2==0) return(k[1]*value);
	if(k[0]>1) return(2*value);
	return(k[1]*value-value);

    }



    public void print() {
	System.out.println("----");
	System.out.println("value  "+value);
	System.out.println("length "+length);
	for(int i=0;i<length;++i) System.out.print(k[i]+" ");
	System.out.println("");
	System.out.println("----");
    }

}
