import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/*This file gives an approximate computation
  of the volume of our polyhedra.  When scaled,
  our polyhedra are all lattice polyhedra.  The
  volume of the scaled polyhedra is (1/6) times
  an integer.  This allows us to deduce the correct
  volume from the approximation computed here.*/

public class VolumeComputer {


    /*Prints out 6 times the 420-scaled volume.  So,
      the actual volume is (this)/6/(420^3).*/

    public static void main() {
	for(int i=0;i<51;++i) {
	    LongPolyhedron P=DataPartition.poly(i);
	    long v=volume6(0,P);
	    System.out.print(v+",");
	}
    }


    /*In the case of triv1, one of the faces has more than 4 vertices. 
      For this poly, we cone to a vertex on this face.*/

    public static void extra() {
	LongPolyhedron P=DataPartitionExtra.triv1();
	long v=volume6(4,P);  
	System.out.println("trivial tile from 1/2 to 3/4: "+v); 
        
        P=DataPartitionExtra.domainF1();
	v=volume6(0,P);
	System.out.println("domain from 1/4 to 2: "+v);

        P=DataPartitionExtra.domainF3();
	v=volume6(0,P);
	System.out.println("domain from 5/4 to 2: "+v);

        P=DataPartitionExtra.domainF4();
	v=volume6(0,P);
	System.out.println("domain from 1/2 to 3/4: "+v);
    }





    /*Computes 6 times the volume, in case no face has more than 4 vertices.*/

    public static long volume6(int q,LongPolyhedron P) {
	LongVector V=P.V[q];
	long total=0;
	for(int i=0;i<P.FACE.length;++i) {
	    LongVector[] W=P.face(i);
	    if(W.length==3) total=total+volumePrism3(V,W);
	    if(W.length==4) total=total+volumePrism4(V,W);
	}
	return(total);
    }





    public static long volumePrism3(LongVector V,LongVector[] W) {
	LongVector[] X=new LongVector[3];
	for(int i=0;i<3;++i) X[i]=LongVector.minus(W[i],V);
	Long t=LongVector.dot(X[0],LongVector.cross(X[1],X[2]));
	if(t<0) t=-t;
	return(t);
    }



    public static long volumePrism4(LongVector V,LongVector[] W) {
	LongVector[] X=new LongVector[4];
	for(int i=0;i<4;++i) X[i]=LongVector.minus(W[i],V);
	Long t1=LongVector.dot(X[0],LongVector.cross(X[1],X[2]));
	Long t2=LongVector.dot(X[0],LongVector.cross(X[1],X[3]));
	Long t3=LongVector.dot(X[0],LongVector.cross(X[2],X[3]));
	Long t4=LongVector.dot(X[1],LongVector.cross(X[2],X[3]));
	Long[] t={t1,t2,t3,t4};
	for(int i=0;i<4;++i) if(t[i]<0) t[i]=-t[i];
	long u=t[0]+t[1]+t[2]+t[3];
	if(u%2!=0) throw new ProofException("not even");
	u=u/2;
	return(u);
    }





}











