
import java.awt.geom.*;

/*This class gets the polyhedra for the polygon exchange map. 
  We have a 1-parameter family of polygon exchanges, and they
  fit together to make a fiber bundle which is an affine polyhedron
  exchange*/

public class DataPartition {

    /**There are 51 polyhedra in the partition from s=1/4 to s=2.*/

    /**This creates the basic partition longPolyhedron.  We scale
       up the picture by 420 so that we can work with integer
       polyhedra*/

    public static LongPolyhedron poly(int k) {
	int[][] u=polyInt(k);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(420,u);
	if(k>31) P=doMap(-1,k,P);
	P.MOVE=move(k);
	P.FACE=faceList(k);
	P.VOLUME=volume(k);
	return(P);
    }

    /*This creates the image under the PET*/

    public static LongPolyhedron imagePoly(int k) {
	LongPolyhedron P=poly(k);
	LongPolyhedron Q=doMap(1,k,P);
	Q.FACE=faceList(k);
	Q.SCALE=P.SCALE;
	Q.VOLUME=volume(k);
	return(Q);
    }

    /*This creates the image under the map F'*/

    public static LongPolyhedron halfImagePoly(int k) {
	LongPolyhedron P=poly(k);
	LongPolyhedron Q=doMap(2,k,P);
	Q.FACE=faceList(k);
	Q.SCALE=P.SCALE;
	return(Q);
    }


    /*This creates the partition for the map alpha f alpha
      used in Calculation 1.*/

    public static LongPolyhedron alphaPoly(int k) {
	LongPolyhedron P=poly(k);
	P=DataSymmetry.alpha(calc1Data(k),P);
	return(P);
    }


    /*This creates the partition for the map beta f^{-1} beta
      used in Calculation 2.*/

    public static LongPolyhedron betaPoly(int k) {
	LongPolyhedron Q=imagePoly(k);
	int m=calc2Data(k);
	int[] q={0,-2,2,-4,4};
	Q=DataSymmetry.beta(q[m],Q);
	return(Q);
    }

    /**here is the raw data*/

    public static int[][] polyInt(int k) {
	if(k<32) return(polyInt0(k));
	return(DataSymmetry.invert(polyInt0(k-32)));
    }

    public static int[][] polyInt0(int k) {
	if(k==0) return(polyA0());
	if(k==1) return(polyA1());
	if(k==2) return(polyA2());
	if(k==3) return(polyA3());
	if(k==4) return(polyA4());
	if(k==5) return(polyA5());
	if(k==6) return(polyA6());
	if(k==7) return(polyA7());
	if(k==8) return(polyA8());
	if(k==9) return(polyA9());
	if(k==10) return(DataSymmetry.reflect(polyA1()));
	if(k==11) return(DataSymmetry.reflect(polyA2()));
	if(k==12) return(DataSymmetry.reflect(polyA3()));
	if(k==13) return(DataSymmetry.reflect(polyA4()));
	if(k==14) return(DataSymmetry.reflect(polyA5()));
	if(k==15) return(DataSymmetry.reflect(polyA6()));
	if(k==16) return(DataSymmetry.reflect(polyA7()));
	if(k==17) return(DataSymmetry.reflect(polyA8()));
	if(k==18) return(DataSymmetry.reflect(polyA9()));
	if(k==19) return(polyB0());
	if(k==20) return(polyB1());
	if(k==21) return(polyB2());
	if(k==22) return(polyB3());
	if(k==23) return(polyB4());
	if(k==24) return(polyB5());
	if(k==25) return(polyB6());
	if(k==26) return(DataSymmetry.reflect(polyB1()));
	if(k==27) return(DataSymmetry.reflect(polyB2()));
	if(k==28) return(DataSymmetry.reflect(polyB3()));
	if(k==29) return(DataSymmetry.reflect(polyB4()));
	if(k==30) return(DataSymmetry.reflect(polyB5()));
	if(k==31) return(DataSymmetry.reflect(polyB6()));
	return(null);
    }


    /*The 19=1+9+9 tiles in [1/4,1/2].  1+9 are listed and the other 9 are
      reflections of the ones listed. The first tile is trivial*/

    public static int[][] polyA0() {
	int[][] t={{1,4,1,4,1,4},{-1,4,1,4,1,4},{-1,4,-1,4,1,4},{1,4,-1,4,1,4},{1,2,1,2,1,2},{-1,2,1,2,1,2},{-1,2,-1,2,1,2},{1,2,-1,2,1,2}};
	return(t);
    }



    public static int[][] polyA1() {
	int[][] t={{1,1,0,1,1,4},{5,4,1,4,1,4},{3,4,1,4,1,4},{2,3,1,3,1,3}};
	return(t);
    }

    public static int[][] polyA2() {
	int[][] t={{1,4,1,4,1,4},{2,3,1,3,1,3},{1,3,1,3,1,3},{1,2,-1,2,1,2}};
	return(t);
    }

    public static int[][] polyA3() {
	int[][] t={{2,3,1,3,1,3},{1,3,1,3,1,3},{1,2,1,2,1,2},{1,2,-1,2,1,2},{1,1,0,1,1,2}};
	return(t);
    }

    public static int[][] polyA4() {
	int[][] t={{5,4,1,4,1,4},{1,1,0,1,1,3},{1,1,0,1,1,2},{3,2,1,2,1,2},{1,2,1,2,1,2}};
	return(t);
    }

    public static int[][] polyA5() {
	int[][] t={{3,4,-1,4,1,4},{1,1,0,1,1,4},{3,4,1,4,1,4},{1,1,0,1,2,7},{9,10,-1,10,3,10}};
	return(t);
    }

    public static int[][] polyA6() {
	int[][] t={{1,1,0,1,2,7},{11,10,1,10,3,10},{1,1,0,1,1,3},{1,1,1,3,1,3},{2,3,1,3,1,3},{1,2,1,2,1,2}};
	return(t);
    }


    public static int[][] polyA7() {
	int[][] t={{3,4,1,4,1,4},{1,1,0,1,2,7},{9,10,-1,10,3,10},{1,1,0,1,1,3}};
	return(t);
    }


    public static int[][] polyA8() {
	int[][] t={{3,4,-1,4,1,4},{3,4,1,4,1,4},{1,4,1,4,1,4},{1,4,-1,4,1,4},{1,1,0,1,1,3},{2,3,1,3,1,3},{1,2,-1,2,1,2},{1,1,0,1,1,2}};
	return(t);
    }


    public static int[][] polyA9() {
	int[][] t={{1,1,0,1,1,4},{5,4,1,4,1,4},{1,1,0,1,2,7},{11,10,1,10,3,10},{1,1,1,3,1,3},{2,3,1,3,1,3}};
	return(t);
    }






    /**the 13=1+6+6 tiles in [1/2,1].  1+6 are listed and the other
       6 are reflections of the ones listed.*/



    public static int[][] polyB0() {
	int[][] t={{1,2,1,2,1,2},{-1,2,1,2,1,2},{-1,2,-1,2,1,2},{1,2,-1,2,1,2},{1,1,0,1,1,1},{-1,1,0,1,1,1},{0,1,-1,1,1,1},{0,1,1,1,1,1}};
	return(t);
    }

    public static int[][] polyB1() {
	int[][] t={{1,1,1,1,1,1},{2,1,1,1,1,1},{1,1,0,1,1,1},{3,2,1,2,1,2}};
	return(t);
    }


    public static int[][] polyB2() {
	int[][] t={{1,1,0,1,1,2},{3,2,1,2,1,2},{1,2,1,2,1,2},{0,1,1,1,1,1}};
	return(t);
    }


    public static int[][] polyB3() {
	int[][] t={{1,1,0,1,2,3},{5,4,1,4,3,4},{1,1,0,1,1,1},{1,1,1,1,1,1},{0,1,1,1,1,1}};
	return(t);
    }


    public static int[][] polyB4() {
	int[][] t={{1,2,1,2,1,2},{1,1,0,1,2,3},{3,4,-1,4,3,4},{1,1,0,1,1,1}};
	return(t);
    }

    public static int[][] polyB5() {
	int[][] t={{1,2,1,2,1,2},{1,2,-1,2,1,2},{1,1,0,1,1,2},{1,1,0,1,2,3},{3,4,-1,4,3,4}};
	return(t);
    }


    public static int[][] polyB6() {
	int[][] t={{1,1,0,1,1,2},{3,2,1,2,1,2},{1,1,0,1,2,3},{5,4,1,4,3,4},{1,1,1,1,1,1},{0,1,1,1,1,1}};
	return(t);
    }



    /**The moves*/

    /*This takes the arithmetic graph data for the
      polyhedron and converts it into an affine map.*/

    public static LongAffine fromIntegers(int[] t) {
	LongMatrix m=new LongMatrix();
	m.a[0][0]=1;
	m.a[1][0]=0;
	m.a[2][0]=0;
	m.a[0][1]=0;
	m.a[1][1]=1;
	m.a[2][1]=0;
	m.a[0][2]=-2*t[3]+2*t[1];
	m.a[1][2]=-2*t[3]-2*t[1];
	m.a[2][2]=1;
	LongVector v=new LongVector(-2*t[0],2*t[2],0);
	LongAffine A=new LongAffine(m,v);
	return(A);
    }

    /*This does the basic maps on the polyhedra, according
      to the following scheme:

      sign=2:  do the map F'
      sign=1   do the map F
      sign=-1  do the map F^{-1}
    */


    public static LongPolyhedron doMap(int sign,int k,LongPolyhedron P) {
	LongPolyhedron Q=new LongPolyhedron(P);
	Q.count=P.count;
        int[] t=move(k);
	for(int i=0;i<4;++i) t[i]=sign*t[i];
	if(sign==2) t=halfMove(k);
	LongAffine A=fromIntegers(t);
	A.v=A.v.scale(P.SCALE);
	for(int i=0;i<P.count;++i) Q.V[i]=A.act(P.V[i]);
	Q.SCALE=P.SCALE;
	return(Q);
    }

    /**The original PET, f'.
       From the way we have defined things, when k>31, we first
       set coords 2 and 3 to zero, and then reverse the coords.
       This has the effect of setting coords 0 and 1 to 0, as indicated.*/

    public static int[] halfMove(int k) {
	int[] t=move(k);
	  t[2]=0;
	  t[3]=0;
	  return(t);
    }

    /*The PET we usually use, f=(f')^2*/

    public static int[] move(int k) {
	if(k<32) return(move0(k));
	int[] s=move0(k-32);
	int[] t={-s[3],-s[2],-s[1],-s[0]};
	return(t);
    }

    public static int[] move0(int k) {

	if(k<19) {
	   int[][] t=moveA();
	   if(k<10) return(t[k]);
	   int[] s=t[k-9];
	   for(int i=0;i<4;++i) s[i]=-s[i];
	   return(s);
	}
 
        int[][] t=moveB();
	if(k<26) return(t[k-19]);
	int[] s=t[k-25];
        for(int i=0;i<4;++i) s[i]=-s[i];
	return(s);
    }


    public static int[][] moveA() {
	int[][] t={{0,0,0,0},{1,2,0,-2},{0,-1,-1,-2},{0,-1,-1,-1},{1,1,0,-1},{0,-2,-1,-2},{1,2,1,1},{0,-2,-1,-1},{0,-1,0,1},{1,2,1,2}};
	return(t);
    }



    public static int[][] moveB() {
	int[][] t={{0,0,0,0},{1,0,-1,-1},{1,1,0,-1},{1,1,1,0},{0,-1,-1,0},{0,-1,-1,-1},{1,1,1,1}};
	return(t);
    }

    /**end of the map section*/



    /*the face list*/

    public static int[] faceList(int k) {
	int[][] t={{15,51,102,153,204,240},{7,11,13,14},{7,11,13,14},{7,14,19,21,26,28},{7,13,19,25,30},{7,14,21,27,28},{7,29,43,54,56},{7,11,13,14},{39,50,77,100,139,146,200,240},{15,19,22,41,49,60},{7,11,13,14},{7,11,13,14},{7,14,19,21,26,28},{7,13,19,25,30},{7,14,21,27,28},{7,29,43,54,56},{7,11,13,14},{39,50,77,100,139,146,200,240},{15,19,22,41,49,60},{15,26,38,50,69,100,137,152,193,240},{7,11,13,14},{7,11,13,14},{7,14,21,27,28},{7,11,13,14},{15,19,22,25,28},{15,19,22,41,49,60},{7,11,13,14},{7,11,13,14},{7,14,21,27,28},{7,11,13,14},{15,19,22,25,28},{15,19,22,41,49,60},{15,51,102,153,204,240},{7,11,13,14},{7,11,13,14},{7,14,19,21,26,28},{7,13,19,25,30},{7,14,21,27,28},{7,29,43,54,56},{7,11,13,14},{39,50,77,100,139,146,200,240},{15,19,22,41,49,60},{7,11,13,14},{7,11,13,14},{7,14,19,21,26,28},{7,13,19,25,30},{7,14,21,27,28},{7,29,43,54,56},{7,11,13,14},{39,50,77,100,139,146,200,240},{15,19,22,41,49,60}};
	return(t[k]);
    }



    /**This is data for the Calculation 1.  In the ith position:
       An entry of 0 means that poly(i) is a subset of hex().
       An entry of 1 means that poly(i) is a subset of tri1();
       An entry of 2 means that poly(1) is a subset of tri2();
    */

    public static int calc1Data(int i) {
        int[] t={0,2,0,0,2,0,2,0,0,2,1,0,0,1,0,1,0,0,1,0,2,2,2,0,0,2,1,1,1,0,0,1};
	if(i<32) return(t[i]);
	return(-1);
    }


    /**This is data for the Calculation 2.  In the ith position:
       An entry of 1 means that imagePoly(i) is a subset of penta1();
       An entry of 2 means that imagePoly(1) is a subset of penta2();
       An entry of 3 means that imagePoly(i) is a subset of tri3();
       An entry of 4 means that imagePoly(1) is a subset of tri4();  
       An entry of 1 means that imagePoly(i) is a central tile*/
    


    public static int calc2Data(int i) {
        int[] t={0,4,4,2,2,4,1,2,1,3,3,3,1,1,3,2,1,2,4};
	if(i<19) return(t[i]);
	return(-1);
    }


    /**the volume list*/
    public static long volume(int k) {
	long[] v={64827000,771750,2058000,10290000,12348000,595350,1881600,176400,21609000,1205400,771750,2058000,10290000,12348000,595350,1881600,176400,21609000,1205400,370440000,37044000,18522000,30870000,6174000,12348000,43218000,37044000,18522000,30870000,6174000,12348000,43218000,889056000,37044000,37044000,74088000,111132000,30870000,30870000,6174000,518616000,43218000,37044000,37044000,74088000,111132000,30870000,30870000,6174000,518616000,43218000};
	return(v[k]);
    }

}