
import java.awt.geom.*;

/*This class gets the polyhedra for the polygon exchange map. 
  We have a 1-parameter family of polygon exchanges, and they
  fit together to make a fiber bundle which is an affine polyhedron
  exchange*/

public class DataSymmetry {

    /**Here are the symmetry transformations*/

    /*90 degree rotation*/


    /*rotation in the origin*/

    public static int[] rotate(int[] s) {
	int[] t={s[2],s[3],-s[0],s[1],s[4],s[5]};
	return(t);
    }

    public static int[][] rotate(int[][] s) {
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=rotate(s[i]);
	return(t);
    }


    /*reflection in the origin*/

    public static int[] reflect(int[] s) {
	int[] t={-s[0],s[1],-s[2],s[3],s[4],s[5]};
	return(t);
    }

    public static int[][] reflect(int[][] s) {
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=reflect(s[i]);
	return(t);
    }


    /**inversion -- from the Inversion Lemma*/

    public static int[][] invert(int[][] s) {
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=invert(s[i]);
	return(t);
    }

    public static int[] invert(int[] s) {
	int[] t=new int[6];
	t[0]=s[1]*s[2]*s[5]+s[0]*s[3]*s[5];
	t[1]=2*s[1]*s[3]*s[4];
	t[2]=-s[1]*s[2]*s[5]+s[0]*s[3]*s[5];
	t[3]=2*s[1]*s[3]*s[4];
	t[4]=s[5];
	t[5]=2*s[4];
	int[] u=MathRational.reduce(t[0],t[1]);
	t[0]=u[0];
	t[1]=u[1];
        u=MathRational.reduce(t[2],t[3]);
	t[2]=u[0];
	t[3]=u[1];
        u=MathRational.reduce(t[4],t[5]);
	t[4]=u[0];
	t[5]=u[1];
	return(t);
    }

    /**The map alpha from Calculation 1*/

    public static LongVector alpha(int q,LongVector V) {
	long r=0;
	if(q==1) r=-420;
	if(q==2) r=+420;
	LongVector W=new LongVector(V);
	W.x[0]=2*r-W.x[0];
	return(W);
    }


    public static LongPolyhedron alpha(int k,LongPolyhedron P) {
	LongPolyhedron Q=new LongPolyhedron();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.V[i]=alpha(k,P.V[i]);
	Q.FACE=P.FACE;
	Q.SCALE=P.SCALE;
	return(Q);
    }

    /**The map beta from Calculation 2*/

    public static LongPolyhedron beta(int k,LongPolyhedron P) {
	LongPolyhedron Q=new LongPolyhedron();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.V[i]=beta(k,P.V[i]);
	Q.FACE=P.FACE;
	Q.SCALE=P.SCALE;
	return(Q);
    }

    public static LongVector beta(int k,LongVector V) {
	LongVector W=new LongVector();
	W.x[0]=k*V.x[2]-V.x[1];
	W.x[1]=k*V.x[2]-V.x[0];
	W.x[2]=V.x[2];
	return(W);
    }


    /*This is the map from Calculation 5*/

    public static LongPolyhedron modular1(LongPolyhedron P) {
	int[][] s=toIntegers(P);
	s=modular1(s);  
	LongPolyhedron Q=LongPolyhedron.fromIntegerList(P.SCALE,s);
	Q.FACE=P.FACE;
	Q.SCALE=P.SCALE;
	return(Q);
    }


    public static int[][] modular1(int[][] s) {
	int test=0;
	for(int i=0;i<s.length;++i) test=test+s[i][0];
	int choice=0;
	if(test>0) choice=1;
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=modular1(choice,s[i]);
	return(t);
    }



    public static int[] modular1(int choice,int[] t) {
	for(int i=0;i<6;++i) {
	    if(t[i]>10000) throw new ProofException("overflow");
	    if(t[i]<-10000) throw new ProofException("overflow");
	}
	int sign=1;
	if(choice==1) sign=-1;
	int[] u=new int[6];
	u[0]=-sign*2*t[1]*t[4]+ t[0]*t[5] + sign*2*t[1]*t[5];
	u[1]=2*t[1]*t[4]-t[1]*t[5];
	u[2]=t[2]*t[5];
	u[3]=2*t[3]*t[4]-t[3]*t[5];
	u[4]=3*t[4]-2*t[5];
	u[5]=2*t[4]-t[5]; 
	return(u);
    }


    /*This is the map from Calculation 7*/


    public static LongPolyhedron modular2(LongPolyhedron P) {
	int[][] s=toIntegers(P);
	s=modular2(s); 
	LongPolyhedron Q=LongPolyhedron.fromIntegerList(P.SCALE,s);
	Q.FACE=P.FACE;
	Q.SCALE=P.SCALE;
	return(Q);
    }


    public static int[][] modular2(int[][] s) {
	int test=0;
	for(int i=0;i<s.length;++i) test=test+s[i][0];
	int choice=0;
	if(test>0) choice=1;
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=modular2(choice,s[i]);
	return(t);
    }



    public static Complex modular2(int choice,double s,Complex z) {
	int sign=1;
	if(choice==1) sign=-1;
	Complex w=new Complex(-sign*2+sign*2*s-z.x+2*s*z.x,-z.y+2*s*z.y);
	return(w);
    }



    public static int[] modular2(int choice,int[] t) {
	for(int i=0;i<6;++i) {
	    if(t[i]>10000) throw new ProofException("overflow");
	    if(t[i]<-10000) throw new ProofException("overflow");
	}
	int sign=1;
	if(choice==1) sign=-1;
	int[] u=new int[6];
	u[0]=-2*sign*t[1]*t[4]-t[0]*t[5]+sign*2*t[1]*t[5];
	u[1]=2*t[1]*t[4]-3*t[1]*t[5];
	u[2]=t[2]*t[5];
	u[3]=-2*t[3]*t[4]+3*t[3]*t[5];
	u[4]=-t[4]+2*t[5];
	u[5]=-2*t[4]+3*t[5]; 
	return(u);
    }







    /*This extracts the integer lists from the polyhedron*/

    public static int[][] toIntegers(LongPolyhedron Q) {
	int[][] t=new int[Q.count][6];
	for(int i=0;i<Q.count;++i) {
	    t[i][0]=(int)(Q.V[i].x[0]);
	    t[i][1]=(int)(Q.SCALE);
	    t[i][2]=(int)(Q.V[i].x[1]);
	    t[i][3]=(int)(Q.SCALE);
	    t[i][4]=(int)(Q.V[i].x[2]);
	    t[i][5]=(int)(Q.SCALE);
	}
	return(t);
    }



}