import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class EvenExpansion {

    /*The purpose of this class is to convert between
      a rational number and its even expansion*/

    public static int[] toSequence(int[] p0) {
	int[] p={p0[0],p0[1]};
	int[] e0=new int[100];
	int count=0;
	while(p[0]>1) {
	    double d=1.0*p[1]/p[0];
   	    int k=MathRational.convert(Math.floor(d));
	    e0[count]=(int)(k);
	    p=ShapeEntrySystem.renormFraction(p);
	    ++count;
	}
	int[] e1=new int[count+1];
	for(int i=0;i<count;++i) e1[i]=e0[i];
        double d=1.0*p[1]/p[0];
   	int k=MathRational.convert(Math.floor(d));
	e1[count]=k;
	return(e1);
    }

    public static int[] toFraction(int[] a) {
	int[] b=reverse(a);
	int[] p=initial(b[0]);
	for(int i=1;i<b.length;++i) p=next(b[i],p);
	p=MathRational.reduce(p[0],p[1]);
	return(p);
    }


    public static int[] initial(int k) {
	int[] p={1,k};
	return(p);
    }

    public static int[] next(int k,int[] p) {
	if(k==1) {
	    int[] q={p[1]-p[0],p[1]};
	    return(q);
	}
	if(k%2==0) {
	  int[] q={p[1],2*p[0]+k*p[1]};
	  return(q);
	}
	int[] q={p[1],2*p[0]+(k-1)*p[1]};
	return(q);
    }

     public static int[] reverse(int[] a) {
	int[] b=new int[a.length];
	for(int i=0;i<a.length;++i) b[i]=a[a.length-i-1];
	return(b);
     }

    
}


