import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**This class describes a parallelotope.  Here is the data:
   M is a matrix whose columns are linear functionals
   V[0], V[1] are vectors such that the parallelotope consists
   of all vectors X such that M.X lies between V[0] and V[1]
   coordinatewise.
   DIM is the dimension of the ambient space*/


public class Parallelotope {

    Matrix M;
    Vector[] V=new Vector[2];
    int size;

    public Parallelotope() {}

    public Parallelotope(Parallelotope P) {
	this.M=new Matrix(P.M);
	this.V[0]=new Vector(P.V[0]);
	this.V[1]=new Vector(P.V[1]);
	this.size=P.size;
    }


    public void print() {
	M.print();
	V[0].print();
	V[1].print();
    }

    public Vector center() {
	Vector W=Vector.plus(V[0],V[1]);
	W=Vector.scale(.5,W);
	W=Matrix.act(M.inverse(),W);
	return(W);
    }

    public static Vector center(Parallelotope X1,Parallelotope X2) {
	Vector W1=X1.center();
	Vector W2=X2.center();
	Vector V=Vector.plus(W1,W2);
	V=Vector.scale(.5,V);
	return(V);
    }
       


    /**checks if the parallelotope contains the point*/

    public boolean contains(Vector v) {
	Vector w=Matrix.act(M,v);
	for(int i=0;i<4;++i) {
	    if(w.x[i]<V[0].x[i]) return(false);
	    if(w.x[i]>V[1].x[i]) return(false);
	}
	return(true);
    }

    /*Here is the same routine with a small tolerance*/

    public boolean contains(Vector v,double tol) {
	Vector w=Matrix.act(M,v);
	for(int i=0;i<4;++i) {
	    if(w.x[i]<V[0].x[i]-tol) return(false);
	    if(w.x[i]>V[1].x[i]+tol) return(false);
	}
	return(true);
    }

    /**This creates the translate of the first parallelotope
       centered at the vector V*/

    public Parallelotope translateBy(Vector V) {
	Parallelotope P=new Parallelotope(this);
	Vector W=Matrix.act(M,V);
	P.V[0]=Vector.plus(P.V[0],W);
	P.V[1]=Vector.plus(P.V[1],W);
	return(P);
    }

    /**This maps the unit cube [0,1]^4 to the parallelotope.*/

    public Vector image(Vector U) {
	Vector W=new Vector();
	for(int i=0;i<4;++i) {
	   W.x[i]=(1-U.x[i])*V[0].x[i]+U.x[i]*V[1].x[i];
	}
	W=Matrix.act(M.inverse(),W);
	return(W);
    }




}



