import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This contains some routines that are useful
for our rigorous calculations.  Some of these routines
were used to generate data for the calculations
and are not actively in use.*/


public class ProofSupport {

    /*This does the basic map F.  The range is
      the bundle X[1/4,2].*/

    public static LongVector F1(LongVector V) {
	for(int i=0;i<51;++i) {
	    LongPolyhedron P=DataPartition.poly(i);
	    if(LongPolyCombinatorics.insideStrict(V,P)==true) {
	      int[] t=DataPartition.move(i);
	      LongAffine A=DataPartition.fromIntegers(t);
	      A.v=A.v.scale(P.SCALE);
	      LongVector W=A.act(V);
	      return(W);
	    }
	}
	return(null);
    }


    /*This does the inverse of F.  The range is
      the bundle X[1/4,2].*/

    public static LongVector F2(LongVector V) {
	for(int i=0;i<51;++i) {
	    LongPolyhedron P=DataPartition.imagePoly(i);
	    if(LongPolyCombinatorics.insideStrict(V,P)==true) {
	      int[] t=DataPartition.move(i);
	      for(int j=0;j<4;++j) t[j]=-t[j];
	      LongAffine A=DataPartition.fromIntegers(t);
	      A.v=A.v.scale(P.SCALE);
	      LongVector W=A.act(V);
	      return(W);
	    }
	}
	return(null);
    }



    /*This does the map alpha.  The range is
      the bundle X[1/4,1].*/

    public static LongVector alpha(LongVector V) {
	int test=-1;
	LongPolyhedron P0=DataPartitionExtra.A();
	LongPolyhedron P1=DataPartitionExtra.B();
	LongPolyhedron P2=DataPartitionExtra.iotaB();
	if(LongPolyCombinatorics.insideStrict(V,P0)==true) test=0;
	if(LongPolyCombinatorics.insideStrict(V,P1)==true) test=1;
	if(LongPolyCombinatorics.insideStrict(V,P2)==true) test=2;
	if(test==-1) return(null);
	long r=0;
	if(test==1) r=-420;
	if(test==2) r=+420;
	LongVector W=new LongVector(V);
	W.x[0]=2*r-W.x[0];
	return(W);
    }

    /*This does the map beta.  The range is
      the bundle X[1/4,1].*/

    public static LongVector beta(LongVector V) {
	long q=0;
	LongPolyhedron P1=DataPartitionExtra.P();
	LongPolyhedron P2=DataPartitionExtra.iotaP();
	LongPolyhedron P3=DataPartitionExtra.Q();
	LongPolyhedron P4=DataPartitionExtra.iotaQ();
	if(LongPolyCombinatorics.insideStrict(V,P1)==true) q=-2;
	if(LongPolyCombinatorics.insideStrict(V,P2)==true) q=2;
	if(LongPolyCombinatorics.insideStrict(V,P3)==true) q=-4;
	if(LongPolyCombinatorics.insideStrict(V,P4)==true) q=4;
	LongVector W=new LongVector(V);
	W.x[0]=q*V.x[2]-V.x[1];
	W.x[1]=q*V.x[2]-V.x[0];
	W.x[2]=V.x[2];
	return(W);
    }



    /*This does the map F1 on polyhedra*/

    public static LongPolyhedron F1(LongPolyhedron P) {
	int i=insidePartition(P);
	if(i==-1) return(null);   
	LongPolyhedron Q=new LongPolyhedron(P);
        int[] t=DataPartition.move(i);
	LongAffine A=DataPartition.fromIntegers(t);
	A.v=A.v.scale(P.SCALE);
	for(int j=0;j<P.count;++j) Q.V[j]=A.act(P.V[j]);
	Q.SCALE=P.SCALE;
	return(Q);
    }

    /*This does the map F2 on polyhedra*/

    public static LongPolyhedron F2(LongPolyhedron P) {
	int i=insideImagePartition(P);
	if(i==-1) return(null);   
	LongPolyhedron Q=new LongPolyhedron(P);
        int[] t=DataPartition.move(i);
	for(int j=0;j<4;++j) t[j]=-t[j];
	LongAffine A=DataPartition.fromIntegers(t);
	A.v=A.v.scale(P.SCALE);
	for(int j=0;j<P.count;++j) Q.V[j]=A.act(P.V[j]);
	Q.SCALE=P.SCALE;
	return(Q);
    }


    /*This returns an integer 0,...,51 if the polyhedron is
      contained in the partition polyhedron ioly(k).  Otherwise
      the return is -1*/

    public static int insidePartition(LongPolyhedron P) {
	for(int i=0;i<51;++i) {
	    if(insidePartition(P,i)==true) return(i);
	}
	return(-1);
    }


    /*This returns an integer 0,...,51 if the polyhedron is
      contained in the partition polyhedron imagePoly(k).  Otherwise
      the return is -1*/

    public static int insideImagePartition(LongPolyhedron P) {
	for(int i=0;i<51;++i) {
	    if(insideImagePartition(P,i)==true) return(i);
	}
	return(-1);
    }



    /*This tests if a polyhedron is contained in the partition
      polyhedron poly(k)*/

    public static boolean insidePartition(LongPolyhedron P,int k) {
	LongPolyhedron Q=DataPartition.poly(k);
	for(int i=0;i<P.count;++i) {
	    if(LongPolyCombinatorics.inside(P.V[i],Q)==false) return(false);
	}
	return(true);
    }


    /*This tests if a polyhedron is contained in the partition
      polyhedron imagePoly(k)*/

    public static boolean insideImagePartition(LongPolyhedron P,int k) {
	LongPolyhedron Q=DataPartition.imagePoly(k);
	for(int i=0;i<P.count;++i) {
	    if(LongPolyCombinatorics.inside(P.V[i],Q)==false) return(false);
	}
	return(true);
    }




    /*prints out the polyhedron*/

    public static void printPoly(LongPolyhedron P) {
            P.texPrint("");
    }



    /*checks that no 3 points are collinear in the polyhedron*/

    public static void noThreeCollinear() {
	for(int i=0;i<51;++i) {
	   LongPolyhedron P=DataPartition.poly(i); 
	   LongPolyFace.checkBad(P);
	} 
        System.out.println("done");
    }


    /**This is a routine used to get the facelist for a polyhedron*/
      
    public static void getFaceList() {
	System.out.print("{");
	for(int i=0;i<51;++i) {
	   LongPolyhedron P=DataPartition.poly(i);
	   int[] t=LongPolyFace.faceList(P);
	   printout(t); System.out.print(",");
	}
    }

    public static void getFaceList(LongPolyhedron P) {
	System.out.print("{");
	int[] t=LongPolyFace.faceList(P);
	printout(t); System.out.print(",");
    }

    public static void printout(int[] t) {
	System.out.print("{");
	for(int i=0;i<t.length;++i) System.out.print(t[i]+",");
  	System.out.print("}");
    }

}









