import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Renormalize {

    /**In this file we study the renorm sets defined
       relative to the two parameters s and t=R(s).
       The s-parameter is considered the range and
       the t-parameter is considered the domain.*/


    /**Here is the renormalization map*/

    public static double renormReal(double s) {
	if(s>1) return(s-1);
	if(s>.5) return(1-s);
	double t=.5/s;
	t=t-Math.floor(t);
	return(t);
    }




    public static int getK(double s) {
	if(s>1.0/2) {
	    double k=Math.floor(1/(2-2*s));
	    int K=MathRational.convert(k);
	    return(K);
	}
	double t=renormReal(s);
	double u=renormReal(t);
	if(t>.5) return(1);
	double k=Math.floor(1/(2*t));
	if(u>.5) k=k+1;
	int K=MathRational.convert(k);
	return(K);
    }

    /**This is used in connection with the octagrid*/

    public static int getK2(double s) {
	if(s>.5) return(0);
	double t=renormReal(s);
	double u=renormReal(t);
	if(t>.5) return(1);
	double k=Math.floor(1/(2*t));
	k=k+1;
	int K=MathRational.convert(k);
	return(K);
    }


    public static PolygonWrapper renormRange(double s) {
	double t=renormReal(s);
	PolygonWrapper P=renormDomain(t);
	for(int i=0;i<P.count;++i) P.z[i]=renormMap(s,P.z[i]);
	return(P);
    }

    public static Complex renormMapSymm(double s,Complex z) {
	if(z.x<=0) return(renormMap(s,z));
	Complex w=new Complex(-z.x,-z.y);
	w=renormMap(s,w);
	w=new Complex(-w.x,-w.y);
	return(w);
    }

    public static Complex renormMap(double s,Complex z) {
	if(s>.5) return(renormMap1(s,z));
	return(renormMap2(s,z));
    }



    public static Complex renormMap1(double s,Complex z) {
	double t=renormReal(s);
	Complex w=Complex.plus(z,new Complex(t-s,t-s));
	return(w);
    }

    public static Complex renormMap2(double s,Complex z) {
	double t=renormReal(s);
	Complex w=Complex.primitiveRoot(8);
	Complex Z=Complex.times(w,z.conjugate());
	Z=Complex.times(Z,new Complex(s*Math.sqrt(2),0));
	Z=Complex.plus(Z,new Complex(-1+2*s*t,0));
	return(Z);
    }


    public static PolygonWrapper renormDomain(double t) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	if(t<.5) {
	    P.z[0]=new Complex(-1-t,-t);
            P.z[1]=new Complex(-t,-t);
	    P.z[2]=new Complex(-t,t);
	    P.z[3]=new Complex(-1+t,t);
	return(P);
	}
	if((t<1)&&(t>1.0/2)) {	
            P.z[0]=new Complex(-1-t,-t);
	    P.z[1]=new Complex(-1+t,-t);
	    P.z[2]=new Complex(-t,-1+t);
	    P.z[3]=new Complex(-t,1-t);
	    return(P);
	}
	P.z[0]=new Complex(-1-t,-t);
        P.z[1]=new Complex(1-t,-t);
	P.z[2]=new Complex(0,-1);
	P.z[3]=new Complex(-1,0);
	return(P);
    }



    /**MODULARITY*/



    /*mod1 map*/

    public static double mod1Real(double s) {
	double t=(s-2)/(2*s-3);
	return(t);
    }

    public static PolygonWrapper mod1Range(double s) {
	double t=mod1Real(s);
	PolygonWrapper P=renormDomain(t);
	Complex z=P.center();
	int choice=0;
	if(z.x>0) choice=1;
	for(int i=0;i<P.count;++i) P.z[i]=modular1(choice,s,P.z[i]);
	return(P);
    }

    public static Complex modular1(int choice,double s,Complex z) {
	double sc=3-2*s;
	Complex u=new Complex(sc*z.x+sc-1,sc*z.y);
	if(choice==1)  u=new Complex(sc*z.x-sc+1,sc*z.y);
	return(u);
    }

    public static Complex modular1(double s,Complex z) {
	int choice=0;
	if(z.x>0) choice=1;
	return(modular1(choice,s,z));
    }


    /*mod 2 map*/

    public static double mod2Real(double s) {
	double t=(2-3*s)/(1-2*s);
	return(t);
    }

    public static PolygonWrapper mod2Range(double s) {
	double t=mod2Real(s);
	PolygonWrapper P=renormDomain(t);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) {
              Q.z[i]=modular2(s,P.z[i]);
	}
	return(Q);
    }

    public static Complex modular2(int choice,double s,Complex z) {
	int sign=1;
	if(choice==1) sign=-1;
	Complex w=new Complex(-sign*2+sign*2*s-z.x+2*s*z.x,-z.y+2*s*z.y);
	return(w);
    }

    public static Complex modular2(double s,Complex z) {
	int choice=0;
	if(z.x>0) choice=1;
	return(modular2(choice,s,z));
    }

}


