import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/*This file contains the domains and maps associated
  to the symmetries of the system.*/

public class Symmetries {


    public static PolygonWrapper pieceBLeft(double s) {
	double t=1/s;
	PolygonWrapper P=new PolygonWrapper();
	P.count=3;
	P.z[0]=new Complex(-1,0);
	P.z[1]=new Complex(-s-1,-s);
	P.z[2]=new Complex(+s-1,-s);
	return(P);
    }

    public static PolygonWrapper pieceBRight(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=3;
	P.z[0]=new Complex(1,0);
	P.z[1]=new Complex(s+1,+s);
	P.z[2]=new Complex(-s+1,+s);
	return(P);
    }

    public static PolygonWrapper pieceALeft(double s) {
	PolygonWrapper P=new PolygonWrapper();
	if(s<=1.0/2) {
	  P.count=5;
	  P.z[0]=new Complex(-1+s,-s);
	  P.z[1]=new Complex(-1,0);
	  P.z[2]=new Complex(-1+s,s);
	  P.z[3]=new Complex(-s,s);
	  P.z[4]=new Complex(-s,-s);
	}

	if(s>1.0/2) {
	    P.count=3;	 
            P.z[0]=new Complex(-1,0);
            P.z[1]=new Complex(-s,s-1);
            P.z[2]=new Complex(-s,1-s);
	}

	return(P);
    }


    public static PolygonWrapper piecePLeft(double s) {
	if(s<.25) return(null);
	if(s>.5) return(null);
	PolygonWrapper P=new PolygonWrapper();
	P.count=5;
	P.z[0]=new Complex(-s,s);
	P.z[1]=new Complex(-1+s,s);
	P.z[2]=new Complex(-3*s,1-3*s);
	P.z[3]=new Complex(-3*s,-s);
	P.z[4]=new Complex(-s,-s);
	return(P);
    }

    public static PolygonWrapper piecePRight(double s) {
	if(s<.25) return(null);
	if(s>.5) return(null);
	PolygonWrapper P=piecePLeft(s);
	for(int i=0;i<5;++i) P.z[i]=new Complex(-P.z[i].x,-P.z[i].y);
	return(P);
    }




    public static PolygonWrapper pieceQLeft(double s) {	
        if(s<.25) return(null);
	if(s>.5) return(null);
	PolygonWrapper P=new PolygonWrapper();
	P.count=3;
	P.z[0]=new Complex(-1-s,-s);
	P.z[1]=new Complex(-3*s,-s);
	P.z[2]=new Complex(-3*s,1-3*s);
	return(P);
    }

    public static PolygonWrapper pieceQRight(double s) {	
        if(s<.25) return(null);
	if(s>.5) return(null);
	PolygonWrapper P=pieceQLeft(s);
	for(int i=0;i<3;++i) P.z[i]=new Complex(-P.z[i].x,-P.z[i].y);
	return(P);
    }

    public static Complex map1(double s,Complex z) {
	PolygonWrapper P1=pieceBLeft(s);
	PolygonWrapper P2=pieceBLeft(s);
	PolygonWrapper P3=pieceBRight(s);
	if(P1.contains(z)==true) {
	    Complex w=new Complex(-z.x,z.y);
	    return(w);
	}
	if(P2.contains(z)==true) {
   	   Complex w=new Complex(-z.x-2,z.y);
	   return(w);
	}
	if(P3.contains(z)==true) {
   	   Complex w=new Complex(-z.x+2,z.y);
	   return(w);
	}
	return(null);
    }


    public static boolean map2Range(double s,Complex z) {
	PolygonWrapper P1=piecePLeft(s);
	PolygonWrapper P2=piecePRight(s);
	PolygonWrapper P3=pieceQLeft(s);
	PolygonWrapper P4=pieceQRight(s);
	if(P1.contains(z)==true) return(true);
	if(P2.contains(z)==true) return(true);
	if(P3.contains(z)==true) return(true);
	if(P4.contains(z)==true) return(true);
	return(false);
    }

    public static Complex map2(double s,Complex z) {
	PolygonWrapper P1=piecePLeft(s);
	PolygonWrapper P2=piecePRight(s);
	PolygonWrapper P3=pieceQLeft(s);
	PolygonWrapper P4=pieceQRight(s);

	if(P1.contains(z)==true) {
	    Complex w=flipPentaLeft(s,z);
	    if(P1.contains(w)==false) System.out.println("bad1");
	    return(w);
	}
	if(P2.contains(z)==true) {
            Complex w=flipPentaRight(s,z); 
            if(P2.contains(w)==false) System.out.println("bad2");
	    return(w);
	}
	if(P3.contains(z)==true) {
            Complex w=flipTriLeft(s,z); 
            if(P3.contains(w)==false) System.out.println("bad3");
	    return(w);
	}
	if(P4.contains(z)==true) {
            Complex w=flipTriRight(s,z); 
            if(P4.contains(w)==false) System.out.println("bad4");
	    return(w);
	}
	return(null);
    }

    public static Complex flipPentaLeft(double s,Complex z) {
	Complex w=new Complex(-2*s-z.y,-2*s-z.x);
	return(w);
    }

    public static Complex flipPentaRight(double s,Complex z) {
	Complex a=new Complex(-1,0);
	Complex w=Complex.times(a,z);
	w=flipPentaLeft(s,w);
	w=Complex.times(a,w);
	return(w);
    }

    public static Complex flipTriLeft(double s,Complex z) {
	Complex w=new Complex(-4*s-z.y,-4*s-z.x);
	return(w);
    }


    public static Complex flipTriRight(double s,Complex z) {
	Complex a=new Complex(-1,0);
	Complex w=Complex.times(a,z);
	w=flipTriLeft(s,w);
	w=Complex.times(a,w);
	return(w);
    }





}
