import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This tile computes the polytope exchange tiles and also
   the arithmetic graph.*/

public class ComputePET implements Runnable {
    boolean HALT;
    Manager M;
    double SHAPE;
    int LIMIT;
    int FOCUS;

    public ComputePET() {
	HALT=true;
    }

    public ComputePET(Manager MM) {
	this.M=MM;	
	HALT=true;
        FOCUS=M.C.FOCUS;
        SHAPE=M.C.getParameter();	
	LIMIT=M.C.LIMIT.powerOfTwo();
    }

    public void run() {	
	HALT=false;
	int choice=M.C.PET.mode;
	if(choice==0) tilePlot(false,M.C.CS.C,false);
	if(choice==1) tilePlot(true,M.C.CS.C,false);
	if(choice==2) carpetPlot();
	HALT=true;
	M.C.repaint();
	PETCanvas B=M.B1;
	if(FOCUS==1) B=M.B2;
	B.repaint();	
    }


    /**The navigator specifies a vector in the
       unit cube Q=[-.5,.5]^4.  However, we really
       want a vector in the domain FUN1=m^{-1}(Q).*/

    public Complex getInitialPoint() {
	Complex z=new Complex(M.B1.SOURCE);
	if(FOCUS==1)  z=new Complex(M.B2.SOURCE);
	return(z);
    }

    public Vector[] getConstraints(Complex z) {
	Complex z1=new Complex(z);
	Complex z2=BasicAlgebra.reduce(2,SHAPE,z1);
	Complex z3=BasicAlgebra.reduce(1,SHAPE,z2);
	Vector[] V1=BasicAlgebra.getBounds(1,SHAPE,z1);
	Vector[] V2=BasicAlgebra.getBounds(2,SHAPE,z2);
	Vector[] V3=BasicAlgebra.getBounds(1,SHAPE,z3);
	V1[0]=Vector.max(V1[0],V3[0]);
	V1[1]=Vector.min(V1[1],V3[1]);
	Vector[] BOUNDS={V1[0],V1[1],V2[0],V2[1]};
	return(BOUNDS);
    }
    public Vector[] getConstraintsHalf(Complex z) {
	Complex z1=new Complex(z);
	Complex z2=BasicAlgebra.reduce(2,SHAPE,z1);
	Vector[] V1=BasicAlgebra.getBounds(1,SHAPE,z1);
	Vector[] V2=BasicAlgebra.getBounds(2,SHAPE,z2);
	Vector[] BOUNDS={V1[0],V1[1],V2[0],V2[1]};
	return(BOUNDS);
    }

    public Vector[] shrinkWrap(Vector[] V1,Vector[] V2) {
	Vector[] W=new Vector[4];
	W[0]=Vector.max(V1[0],V2[0]);
	W[1]=Vector.min(V1[1],V2[1]);
	W[2]=Vector.max(V1[2],V2[2]);
	W[3]=Vector.min(V1[3],V2[3]);
	return(W);
    }

    public Vector[] initialConstraints() {
	double[] q0={1,1,};
	double[] q1={-1,-1};
	Vector[] W=new Vector[4];
	W[0]=new Vector(q1);
	W[1]=new Vector(q0);
	W[2]=new Vector(q1);
	W[3]=new Vector(q0);
	return(W);
    }

    public void tilePlot(boolean TOTAL,Color COL,boolean block) {
	Complex z=getInitialPoint();
	tilePlot(TOTAL,z,COL,block);
    }

    /**here are the parameters.
       TOTAL: do we plot the whole orbit or just the first tile?
       z0: initial point
       COL: color of tile
       block: will we plot over an already existing tile?
    **/


    public void tilePlot(boolean TOTAL,Complex z0,Color COL,boolean block) {

	Complex z=new Complex(z0);
	Vector[] BOUND=initialConstraints();
	int i=0;
	boolean test=false;
	while((i<LIMIT)&&(test==false)) {
	  Vector[] W=getConstraints(z);
	  BOUND=shrinkWrap(BOUND,W);
	  z=BasicAlgebra.map(SHAPE,z);
	  if(Complex.dist(z,z0)<.0000001) test=true;
	  ++i;
	}

	int orbit=i;i=0;
	if(test==true) {
	  int[] orbit2={orbit,orbit};
	  if(TOTAL==false) orbit2[1]=1;
	  double tag=Math.random();
          sendTile(z0,BOUND,orbit2,COL,tag,block);
	}
    }





    public void sendTile(Complex z0,Vector[] BOUND,int[] orbit,Color COL,double tag,boolean block) {
	Complex z=new Complex(z0);
        PETCanvas B=new PETCanvas();
	if(FOCUS==0) B=M.B1;
	if(FOCUS==1) B=M.B2;

	int i=0;
	while((i<orbit[1])&&(HALT==false)) {
	    PolygonWrapper P=BasicAlgebra.realize(SHAPE,z,BOUND);
	    B.acceptTile(P,COL,orbit[0],tag,block);
	    z=BasicAlgebra.map(SHAPE,z);
	  ++i;
	}
    }


    public void carpetPlot() {
	long t1=Time.time();
	PETCanvas B=M.B1;
	if(FOCUS==1) B=M.B2;	
        PolygonWrapper P=BasicAlgebra.domain(1,SHAPE);
	GeneralPath gp=P.toGeneralPath();
	Complex[] bound=GraphicsHelp.getBounds(P);
	Complex w=new Complex();
	int COUNT=0;
	while(HALT==false) {
	    long t2=Time.time();
	    long t3=t2-t1;
	    if(t3>1000) HALT=true;
	    w=Complex.random(bound[0],bound[1]);
	    if(gp.contains(w.x,w.y)==true) {
		int t=B.getIndex(w);
		if(t==-1) {
		    tilePlot(false,w,M.C.CS.C,true);
		    t1=Time.time();
		    B.repaint();
		    M.C.repaint();
		}
	    }
	}
    }
}









