import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    SelectColor CS;
    ShapeEntrySystem SHAPE,SHAPE2;
    ControlPanelColor REGION,PARAMETER;
    ControlPanelColor[] DISPLAY=new ControlPanelColor[2];
    ControlPanel RESET,ACTION,PET,CHOICE,EXACT,MAP;
    ListenSquare GO,STOP,CANONICAL;
    ComputePET CP;
    ComputeProof CPR;
    int FOCUS;
    SelectInteger POLY;
    SelectInteger FACE;
    ListenSquare INFO,INFO2; 
    SelectInteger LIMIT;
    String[] MESSAGE=new String[10];


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setControlPanels();
	 setColorPanels();
	 setComputers();
	 setModifiers();
	 FOCUS=0;
	 POLY=new SelectInteger(95,192,40,20,0,0,51,1);
	 FACE=new SelectInteger(95,230,40,20,0,0,1,1);
	 MESSAGE[0]="message center";
	 for(int i=1;i<10;++i) MESSAGE[i]="";
     }

    public void setModifiers() {
	SHAPE=new ShapeEntrySystem(3,2,"1/2",new Color(70,0,70),PARAMETER);
         SHAPE2=new ShapeEntrySystem(3,44,"1/2",new Color(0,0,100),PARAMETER);
	 CS=new SelectColor(M,3,86,320,50);
     }


    public void setComputers() { 
         GO=new ListenSquare(90,160,30,18);
	 STOP=new ListenSquare(137,160,34,18);
	 INFO=new ListenSquare(122,163,12,12);
	 INFO2=new ListenSquare(311,138,12,12);
         LIMIT=new SelectInteger(90,140,27,17,15,0,20,1);
	 CP=new ComputePET();	 
	 CPR=new ComputeProof();	 
    }

    public void setControlPanels() {	 
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
         Color[] C1={new Color(100,0,180),Color.white,Color.white,Color.white,Color.red};
         Color[] C2={new Color(0,0,70),Color.white,Color.white,Color.white,Color.red};
         Color[] C3={new Color(200,0,0),Color.white,Color.white,Color.white,Color.red};

	 //reset
	 String[] ResetString={"PET1","PET2","reset"};
	 int[] ResetState={0,0,0};
         RESET=new ControlPanel(C3,ResetString,ResetState,2);

	 //action
	 String[] ActionString={"action","info","button-2"};
	 int[] ActionState={1,0};
         ACTION=new ControlPanel(C3,ActionString,ActionState,2);
	 ACTION.mode=0;

	 //choice
	 String[] ChoiceString={"PET","proofs","calc choice"};
	 int[] ChoiceState={1,0};
          CHOICE=new ControlPanel(C1,ChoiceString,ChoiceState,2);
	  CHOICE.mode=0;

	 //action_pet
	  String[] Action_petString={"single","orbit","carpet","pet action"};
	  int[] Action_petState={1,0,0};
         PET=new ControlPanel(C1,Action_petString,Action_petState,3);
	 PET.mode=0;

	 //action_exact
	 String[] Action_exactString={"partition","calc 1","calc 2","calc 3","calc 4","calc 5","calc 6","calc 7","calc 8","ptoofs"};
	 int[] Action_exactState={1,0,0,0,0,0,0,0,0};
         EXACT=new ControlPanel(C1,Action_exactString,Action_exactState,9);
	 EXACT.mode=0;

	 //map
	 String[] MapString={"none","R (c3)","R (c4)","mod1 (c5)","mod2 (c7)","map"};
	 int[] MapState={1,0,0,0,0};
          MAP=new ControlPanel(C0,MapString,MapState,5);
	  MAP.mode=0;


    }


    public void setColorPanels() {
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
         Color[] C1={new Color(100,0,180),Color.white,Color.white,Color.white,Color.red};
         Color[] C2={new Color(0,0,100),Color.white,Color.white,Color.white,Color.red};


	 Color[] DISPLAYCOLOR={new Color(255,0,255,120),new Color(255,0,255,120),new Color(0,0,255,100),new Color(255,0,255,100),new Color(200,0,200,150),new Color(200,0,200,150),Color.red};
	 String[] DisplayString={"F1","F2","L1","L2","partition","inv. part.","piece","display"};
	 int[] DisplayState={1,0,0,0,0,0,0};
         DISPLAY[0]=new ControlPanelColor(C0,DisplayString,DisplayState,7,DISPLAYCOLOR);
         DISPLAY[1]=new ControlPanelColor(C0,DisplayString,DisplayState,7,DISPLAYCOLOR);
	 DISPLAY[1].M[0].C=new Color(0,0,255,120);
	 DISPLAY[1].M[1].C=new Color(0,0,255,120);

	 Color[] REGIONCOLOR={new Color(255,255,255,100),new Color(255,0,0,100),new Color(0,0,255,100),new Color(0,200,0,140),new Color(0,0,255,150),new Color(100,100,100,140),new Color(100,100,100,140)};
	 String[] RegionString={"hex","tri","penta","tri2","R","mod1","mod2","regions"};
	 int[] RegionState={0,0,0,0,0,0,0};
         REGION=new ControlPanelColor(C0,RegionString,RegionState,7,REGIONCOLOR);

	 Color[] PARAMETERCOLOR={new Color(150,150,150),new Color(255,0,0),new Color(0,200,0),new Color(255,0,255),new Color(50,100,255)};

	 String[] ParameterString={"none","copy","R","mod1","mod2","transforms"};
	 int[] ParameterState={1,0,0,0,0};
         PARAMETER=new ControlPanelColor(C2,ParameterString,ParameterState,5,PARAMETERCOLOR);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawPanels(g); 
      drawMessage(g);
      drawFrame(g);
   }


    public void drawBG(Graphics2D g) {
	g.setColor(new Color(50,0,0));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(new Color(0,50,50));
	g.fillRect(173,138,150,144);
	g.setColor(Color.white);
	g.drawRect(173,138,150,144);
        g.setFont(new Font("Helvetica",Font.PLAIN,11));
        g.setColor(Color.white);
	for(int i=0;i<10;++i) {
	    g.drawString(MESSAGE[i],177,152+14*i);
	}
 	INFO2.infoRender(g);
    }


    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(0,50,255));
	g.fillRect(400,0,10,400);
	g.fillRect(0,390,400,10);
    }

    public void drawControls(Graphics2D g) {
	if((DISPLAY[0].L[6].on+DISPLAY[1].L[6].on>0)) {
	    POLY.render(g,new Color(80,140,255),Color.white,Color.white);
	    FACE.render(g,new Color(80,140,255),Color.white,Color.white);
	  g.setColor(Color.white);
	  g.drawString("piece",(int)(POLY.x+10),(int)(POLY.y+30));
	  g.drawString("face",(int)(FACE.x+10),(int)(FACE.y+30));
	}

	SHAPE.render(g); 
	SHAPE2.render(g); 
	LIMIT.render2(g,new Color(0,200,0),Color.white,Color.white,"");
        CS.render(g);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));  
	g.setColor(Color.white);
	INFO.infoRender(g);
	if(isIdle()==true) {
            GO.render(g,new Color(0,150,0));  
            g.drawString("go",(int)(GO.x+8),(int)(GO.y+13));
	}
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	if(isIdle()==false) {
           STOP.render(g,Color.red);
	   g.drawString("stop",(int)(STOP.x+8),(int)(STOP.y+13));
	}
    }


    public void drawPanels(Graphics2D g) {
        PARAMETER.render(g,325,87,73);

        RESET.render(g,247,338,74);
	ACTION.render(g,247,285,74);
 
        CHOICE.render(g,325,184,73);
 	if(CHOICE.mode==0) PET.render(g,325,234,73); 
 	if(CHOICE.mode==1) EXACT.render(g,325,234,73); 
  
        DISPLAY[0].render(g,3,138,84);
        DISPLAY[1].render(g,3,263,84);
        REGION.render(g,90,263,75);
	MAP.render(g,168,293,75);
    }

    public void resetStuff(Point X) {
	int t=RESET.getValue(X);
	if(t==0) M.B1.COUNT=0;
	if(t==1) M.B2.COUNT=0;
    }

    /*These are the computational routines.*/

    public boolean doAction() {
	if(isIdle()==false) return(false);
	computePET();
	return(true);
    }

    public boolean isIdle() {
        if(CP.HALT==false) return(false);
	return(true);
    }
  
    public boolean doAction(Point X) {
	if((STOP.inside(X)!=1)&&(GO.inside(X)!=1)) return(false);
	if((STOP.inside(X)==1)&&(isIdle()==false)) {
	   CP.HALT=true;
	   return(true);
	}

	if((isIdle()==true)&&(GO.inside(X)==1)) {
	  ACTION.forceMode(0);	
	  if(CHOICE.mode==0) computePET();
	  if(CHOICE.mode==1) computeProof();
	  return(true);
	}
	return(false);
    }

    public void computePET() {
       CP=new ComputePET(this.M);
       new Thread(CP).start();
    }

    public void computeProof() {
	CPR=new ComputeProof(this.M);
        new Thread(CPR).start();
    }

    /**end computational routines*/


    public double getParameter() {
	return(getParameter(FOCUS));
    }
    public double getParameter(int v) {
	if(v==0) return(SHAPE.getParameter());
	else return(SHAPE2.getParameter());
    }

    public int[] getFraction(int v) {
	if(v==0) return(SHAPE.getFraction());
	else return(SHAPE2.getFraction());
    }

    public void modifyPanels(Point X) {
	ACTION.switchMode(X);
	MAP.switchMode(X);
	DISPLAY[0].process(X,CS.C);
	DISPLAY[1].process(X,CS.C);
	REGION.process(X,CS.C);
	if(CHOICE.mode==0) PET.switchMode(X);
	if(CHOICE.mode==1) EXACT.switchMode(X);
	CHOICE.switchMode(X);
    }

    public void transformParameter(Point X) {
	  PARAMETER.switchMode(X);
	  int val=PARAMETER.mode;
	  transformParameter(val);
    }

    public void transformParameter(int val) {
	if(val==1) SHAPE.copy(SHAPE2);
	if(val==2) SHAPE.renorm(SHAPE2);
	if(val==3) SHAPE.mod1(SHAPE2);
	if(val==4) SHAPE.mod2(SHAPE2);
    }

  public boolean setShape(MouseEvent e) {  
    SHAPE.process(e); 
    SHAPE2.process(e);
    if(SHAPE2.ACTIVE==false) {
      int val=PARAMETER.mode;
      transformParameter(val);
    }
    return(true);
  }

    public void displayRenorm() {
	for(int i=0;i<10;++i) MESSAGE[i]="";
	int[] p=SHAPE.getFraction();
	int count=0;
	while((count<9)&&(p[0]>1)) {
	    assign(count,p);
	    p=ShapeEntrySystem.renormFraction(p);
	    ++count;
	}
	assign(count,p);
    }

    public void assign(int count,int[] p) {
	double d=1.0*p[1]/p[0];
	int k=MathRational.convert(Math.floor(d));
	Integer K=new Integer(k);
        Integer p0=new Integer(p[0]);
	Integer p1=new Integer(p[1]);
	MESSAGE[count]="("+K.toString()+") "+p0.toString()+"/"+p1.toString();



    }


    public void changeFocus(Point X) {
	if(SHAPE.inside(X)==true) {
	    displayRenorm();
	    FOCUS=0;
	    SHAPE.ACTIVE=true;
	    SHAPE2.ACTIVE=false;
	}
	if(SHAPE2.inside(X)==true) {
	    FOCUS=1;
	    SHAPE2.ACTIVE=true;
	    SHAPE.ACTIVE=false;
	}
    }

    public void polySelector(Point X) {
	  POLY.modify(X);
	  FACE.modifyCyclic(X);
	  if(POLY.isModified(X)!=0) {
	  int[] t=DataPartition.faceList(POLY.val);
	  FACE.max=t.length;
	  FACE.val=0;
	}
    }

    public void documentStuff(Point X) {
	int test;
	Documentation DOC=new Documentation();
	DOC.M=this.M;
	if(CS.INFO.inside(X)==1) DOC.colorSelectorInfo();
	if(SHAPE.INFO.inside(X)==1) DOC.shapeEntryInfo();
	if(SHAPE2.INFO.inside(X)==1) DOC.shapeEntryInfo();
	if(PARAMETER.getInfo(X)==true) DOC.transformInfo();
	if(RESET.getInfo(X)==true) DOC.resetInfo();
	if((CHOICE.mode==0)&&(PET.getInfo(X)==true)) DOC.petPlotInfo();
	if((CHOICE.mode==1)&&(EXACT.getInfo(X)==true)) DOC.proofInfo();
	if(CHOICE.getInfo(X)==true) DOC.calcInfo();
	if(ACTION.getInfo(X)==true) DOC.actionInfo();
	if(DISPLAY[0].getInfo(X)==true) DOC.displayInfo();
	if(DISPLAY[1].getInfo(X)==true) DOC.displayInfo();
	if(REGION.getInfo(X)==true) DOC.regionInfo();
	if(MAP.getInfo(X)==true) DOC.mapInfo();
	if(INFO.inside(X)==1) DOC.goInfo();
	if(INFO2.inside(X)==1) DOC.messageInfo();
    }
    
    public void mouseClicked(MouseEvent e) {  
        MouseData J=MouseData.process(e);
        CS.process(e);  
	polySelector(J.X);
	LIMIT.modify(J.X);
	resetStuff(J.X);
	modifyPanels(J.X);
	setShape(e);
	transformParameter(J.X);
	doAction(J.X);
	changeFocus(J.X);
	documentStuff(J.X);
	M.repaint();
    }


    public void mousePressed(MouseEvent e) {
    }

     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
    public void mouseDragged(MouseEvent e) { }

     public void keyPressed(KeyEvent e) {}
     public void keyReleased(KeyEvent e) {}
     public void keyTyped(KeyEvent e) {	
         SHAPE.processKey(e);
         SHAPE2.processKey(e);
         repaint();
     }


}

