import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class Documentation {
    Manager M;

    public Documentation() {}

    public void messageInfo() {
        String S="message center.";

	S=S+"\n\nSometimes the program will write messages here to let you know the results of some calculation.";

	S=S+"\n\nIf you want to find out the coordinates of the vertices of a tile, you can select the 'info' button on the 'button 2' panel and then click button-2 over a plotted tile.  The coordinates all have the form a/q, where q is the denominator of the rational parameter.";

	S=S+"\n\nWhen you run the integer arithmetic calculations associated to the proof, the message center will show a brief record of the calculation.";

	S=S+"\n\nOccasionally, you may select an object (such as 'mod1') which is only defined for parameters in a certain range. If you try to view this object outside the parameter range, you'll get a message to the effect that you are out of range. I have not been completely systematic in writing in these messages.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void colorSelectorInfo() {
        String S="color selector.";

S=S+"\n\nWhen you plot tiles in the PET windows, you can select the color of the plot using this interface.  You can click and drag the mouse in the three bars to the left in order to change the red, green, and blue components of the color. You can also click or drag on the bottom bar in order to change the transparency level of the color.  It is best to experiment around to see how this works.  When you have altered the color selector the new color will appear in the vertical bar.";

        S=S+"\n\nThere is also a preset palette of colors on the right hand side of the color selector.  You can select these colors  by clicking on the squares.";

	S=S+"\n\nSome of the control panels have 2 columns of buttons.  The right column of buttons selects and de-selects the objectes.  The left column of buttons determines the colors of the objects. You can change these colors by first choosing a color on the color selector and then clicking on a button in the left column.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void mapInfo() {
        String S="partition display.";

	S=S+"\n\nWhen we prove things about the auxiliary regions in Calculations 3,4,5,7, the first step is to take the appropriate tiling of these regions by polyhedra. This control panel allows you to see these tilings, and serves as a sanity check that we have computed them correctly.";

	S=S+"\n\nnone: Select this when you don't want to see any of these tilings.";

	S=S+"\n\nR (c3) this shows the tiling of the region Z_s for s in the range [5/4,2].";

	S=S+"\n\nR (c4) this shows the tiling of the region Z_s for s in the range [1/2,3/4].";

	S=S+"\n\nmod1 (c5) this shows the tiling of the region W_s for s in the range [1,4/3], though we only care about this tiling in the range [1,5/4].";

	S=S+"\n\nmod1 (c7) this shows the tiling of the region W_s for s in the range [3/4,1].";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void displayInfo() {
        String S="display panel.";

	S=S+"\n\nThis panel lets you display some auxiliary objects associated with the system.  The top display panel controls the top PET window and the bottom display panel controls the bottom PET window.";

	S=S+"\n\nThe PET is defined in terms of a pair F1, F2 of fundamental domains and a pair L1, L2 of lattices.  The first 4 options on this panel let you display these objects. The set F1 is the domain for the PET.  It is a good idea to keep this one on at all times.";

	S=S+"\n\nThe 'partition' option shows the maximal domains of continuity for the PET, and the 'inv. part.' shows the maximal domains for the inverse map. If you want to best use these displays, you should select the 'copy' option on the 'transforms' panel, and then select a parameter from the top number entry region.  Then turn on the 'partition' option in the top display panel and the 'inv part' option in the bottom one.  The PET is defined to be the unique piecewise isometry which carries the partition to the inverse partition and is entirely defined on each of the pieces of the partition.";

	S=S+"\n\nThe 'piece' option allows you to survey the pieces of the partition individually. This will only work if you have also turned on either the 'partition' or the 'inv part' option. When you turn on this option on either panel, a pair of arrows appears.  One of the arrows allows you to cycle through the list of polyhedra in the partition and the other arrow lets you cycle through the faces of a given polyhedron.";

S=S+"\n\nWe say 'polyhedra' here because we really think of our system as a 3-dimensional fiber bundle.  Each fiber is the system at a different parameter.  The polygons you see in the partitions are the result of slicing the polyhedra with a fiber.  Note that not every polyhedron intersects every fiber, so sometimes you will select something with the 'piece' arrow and you will not see anything in the window light up.";

	S=S+"\n\nThe 'face' option allows you to plot the faces of the selected piece.  These faces will almost always appear as line segments, for this is what a 2-dimensional slice of a 2-dimensional face typically looks like.  Some of the faces lie in fibers.  If you happen to select such a fiber and such a face, you will see a polygon.  The 'faces' option served as a sanity check for us; we wanted to make sure that we correctly computed the faces of the polyhedra.";


        M.D.setExplain(S);
        M.D.repaint();
    }

    public void regionInfo() {
        String S="display panel.";

	S=S+"\n\nThis panel lets you display some auxiliary objects associated with the system.  The top display panel controls the top PET window and the bottom display panel controls the bottom PET window.";

	S=S+"\n\n'hex' and 'tri': These regions are related to Calculation 1. The domain (F1) of the PET is divided into 3 regions of bilateral symmetry:\n\n 'hex'\n'tri'\n'I(tri)'\n\n Here I is reflection in the origin.  If you plot the tilings, relative to any parameter, you will see that they have bilateral symmetry in each of these 3 regions.";

	S=S+"\n\n'penta' and 'tri2': These regions are related to Calculation 2. When the parameter is between 1/4 and 1/2, the domain (F1) of the PET is divided into 4 regions of bilateral symmetry:\n\n'penta'\n'tri2'\n'I(penta)'\nI(tri2)\n\nHere I is reflection in the origin.  If you plot the tilings, relative to any parameter, you will see that they have bilateral symmetry in each of these 4 regions.";

	S=S+"\n\n'R': This region relates to the Main Theorem in the paper.  In the top PET window, 'R' is the region Z_s and in the bottom PET window 'R' is the region Y_t. Here t=R(s). To see this feature in action, do the following.\n\n1. Select 'R' on the 'transforms' panel.\n2.Press any 'random button' on the top number entry region.\n3.Select the 'R' option on the 'regions' panel.\n4. Select the 'PET' option on the 'calc choice' panel.\n5. Select the 'carpet' option on the 'plot action' panel.\n6. Press 'go'.\n7. Once the calculation has run a while, press 'stop'.\n8. Click in a blank spot in the lower shape region to change the focus to the lower PET window.\n9. Press 'go' again.\n\nWhen you compare the pictures in the top and bottom PET windows, you will see that they are the same, inside the 'R' region.";

	S=S+"\n\n'mod1':  This corresponds to the first modular symmetry for the parameters s in (1,4/3] and u=mod1(s) in (1,2]. The 'mod1' reqion on top is the set W_s from the Calculation 5 and the 'mod1' region on the bottom is the region Y_u from the Main Theorem. You can see a demo for this region, as follows.\n\n1.Select 'mod1' on the 'transforms' panel.\n2.Press the pink button on the top number entry region.\n3.Select the 'mod1' option on the 'regions' panel.\n4. Select the 'PET' option on the 'calc choice' panel.\n5. Select the 'carpet' option on the 'plot action' panel.\n6. Press 'go'.\n7. Once the calculation has run a while, press 'stop'.\n8. Click in a blank spot in the lower shape region to change the focus to the lower PET window.\n9. Press 'go' again.\n\nWhen you compare the pictures in the top and bottom PET windows, you will see that they are the same, inside the 'mod1' region.";

	S=S+"\n\nmod2:  This corresponds to the second modular symmetry for the parameters s in [3/4,1) and u=mod2(s) in [1/2,1)  You can see a demo of what this calculation checks by following the same procedure as for 'mod1', except for the following changes.\n\n1.Select 'mod2' on the 'transforms' panel.\n2.Press the light blue button on the top number entry region.\n3.Select the 'mod2' option on the 'regions' panel.\n";

        M.D.setExplain(S);
        M.D.repaint();
    }


    public void shapeEntryInfo() {
        String S="parameter selection.";

	S=S+"\n\nThis long and thin region allows you to select a parameter for the system. The top region corresponds to the system shown in top left window and the bottom region corresponds to the system shown in the bottom left window.  The regions are color-coded, so that you can remember which region corresponds to which picture window.";

	S=S+"\n\nThere are 4 ways to enter in a parameter:\n\n1.Use the keyboard to enter in a rational number, such as 3/4 or 21/35.  If you do not enter a fraction in lowest terms, you can use the 'reduce' button to reduce it to lowest terms.\n\n2. Use the keyboard to enter in a continued fraction expansion for a number, in the format such as 0:2:3:2:1:2.  The two keys labelled 'fraction' and 'cfe' convert back and forth between a fraction and its continued fraction expansion.  You shouldn't end the continued fraction expansion in 1; this can cause inaccuracies.\n\n3.You can enter in a quadratic irrational in the format 1/2+3/2(5). The parens indicate the radical.  Once you have a quadratic irrational, you can take rational approximations by pushing the 'fraction' button. The blue arrow keys control the degree of approximation.\n\n4.You can push one of the 6 keys at right to select a random parameter. Each of the 6 buttons has a different range.  The ranges are\n0-1/4\n1/4-1/2\n1/2-3/4\n3/4-1\n1-5/4\n5/4-2.\n Each of these ranges has some significance in the paper.";

	S=S+"\n\nThe top parameter control is considered the leader and the bottom one is considered the follower.  The control panel labeled 'transforms' allows you to determine the bottom parameter as a function of the top one, in various ways.  You can learn about this by clicking on the info button of the 'transforms' panel.  The random key buttons in this window are color coded in a way that corresponds with the options on the 'transforms' panel. For instance, the pink button, denoting the range [5/4,2], is the range for the 'mod1' transform.";

	S=S+"\n\nWhen you press the top parameter selector, the renormalization orbit (up to 10 steps) will appear in the green information window on the control panel. The number in parenthesis tells which interval (1,1/2), (1/2,1/3),... contains the fraction";

        M.D.setExplain(S);
        M.D.repaint();
    }



    public void transformInfo() {
        String S="coordinate transforms.";

	S=S+"\n\nThe two number entry regions let you enter parameter values for the systems. This panel allows you to specify the botton number as a function of the top number.  There are 5 options:";
	S=S+"\n\nnone: This simply does nothing. The two parameters are independent.";
	S=S+"\n\ncopy: This copies the first parameter to the second one.  This option is useful when you want to compare the partition for the map with the its image, called the inverse partition.";
	S=S+"\n\nR: This is the renormalization map.  It acts as follows.\n\nIn the range (0,1/2) we have R(x)=1/(2x) - floor(1/(2x)).\n\nIn the range (1/2,1) we have R(x)=1-x.\n\nIn the range (1,2) we have R(x)=x-1.\n\nThe map R works for all parameters, but Calculations 3 and 4 in the paper are done with respect to the parameter ranges corresponding to the green buttons on the shape entry regions.  \n\nFor whatever parameters you pick, you can plot the pictures in the two left windows using the 'carpet plot' option.  This will show the connection between the pictures at the parameters s and t=R(s).  This connection is highlighted by the 'R' region in the regions control panel.";
	S=S+"\n\nmod1: This is the map x->(x-2)/(2x-3). It is the subject of Calculation 5 in the paper, where we call it the first modular symmetry.  The range of interest for this map is (1,5/4) though in Calculation 5 we find it convenient to use the larger interval (1,4/3).  If you plot the pictures at parameters related by mod1, you will see the connection. The connection is made especially clear if you turn on the 'mod1' option on the regions control panel.";

	S=S+"\n\nmod2: This is the map x->(3x-2)/(2x-1).  It is the subject of Calculation 7 in the paper, where we call it the second modular symmetry.  The connection between the pictures at these 2 parameters is highlighted by the 'mod2' option on the regions control panel.  The range of interest for this map is (3/4,1).";
        M.D.setExplain(S);
        M.D.repaint();
    }

    public void goInfo() {
        String S="go button.";

	S=S+"\n\n Pressing the go button is one way to launch a calculation. You select the calculation you want as follows. First, you select one of the two options on the 'calc choice' panel.  Each of these choices brings forth a secondary control panel. This panel is either called 'pet action' or 'proofs', depending on the option you have taken on the 'calc choice' panel.  You also need to select an option on this secondary panel.";

	S=S+"\n\nThe 'pet' option tells the computer to plot pictures in the PET windows on the left. The picture is plotted in one of the two PET windows depending on which of the number entry regions is highlighted with a yellow band.  You can also activate the PET calculations by clicking the middle buttons on the PET windows.";
	S=S+"\n\nThe green arrows allow you to select an orbit length cutoff.  Some of the PET orbits are will be quite long, or even infinite, and we don't want the computer to get hung up on one orbit. So, we cut off the calculation if the orbit is longer than the amount specified by the arrows.  You can change this amount by clicking on the arrows.";

	S=S+"\n\nSometimes the PET calculations can be quite long.  When these calculations are run, a stop button appears and you can stop the calculation by pressing it. This happens most usually when you choose the 'carpet' option on the 'pat action' panel.";

	S=S+"\n\nThe 8 proof options correspond to the 8 calculations in my paper. These run in several seconds each, but there is no graphics output.";

        M.D.setExplain(S);
        M.D.repaint();
    }


    public void resetInfo() {
        String S="reset button.";
	S=S+"\n\npressing these buttons, you clear all previously made plots in the left hand windows.  If you press the reset button during a 'carpet plot', the window will refill with tiles automatically.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void actionInfo() {
        String S="button 2 options.";
	S=S+"\n\nWhen you press buttons 1 and 3 on the PET windows, you scale the picture.  This control panel lets you select one of two options for what button 2 does.\n\n1.action: This launches a calculation just as the 'go' button would. This feature is very handy when you are using the 'single' or 'orbit' plot options.\n\n2. info: This recolors already plotted tiles and also prints out information about the tiles.";
        M.D.setExplain(S);
        M.D.repaint();
    }


    public void calcInfo() {
        String S="calculation options.";
	S=S+"\n\nThere are two options for calculation.\n\nPET: The options here make plots in the two PET windows on the left.  You can force the plot to take place in the one window or the other by clicking on the corresponding number entry regions in advance of the plot.\n\nproofs: These are the 8 calculations made in the paper. (Actually, there is a 9th calculation as well.) There is no visual output here.";

        M.D.setExplain(S);
        M.D.repaint();
    }
    public void petPlotInfo() {
        String S="PET plot options.";
	S=S+"\n\nWhat the program plots in the PET windows are the periodic tiles for the system. These are the maximal convex sets on which the map is defined and periodic.  There are 3 plot options.";

	S=S+"\n\nsingle: This computes the periodic tile containing the point you have clicked, and then plots the tile.  Note that the computer needs to compute the entire orbit before it knows the periodic tile. However, only the one tile is plotted with this option.";

	S=S+"\n\norbit: This computes the periodic tile containing the point you have clicked, and then plots the tile and its orbit.  It is generally a good practice to first plot the single tile before plotting its whole orbit. If the single tile is very small, its orbit will probably be long. When long orbits are plotted, they slow down the program.";

	S=S+"\n\ncarpet: This is by far the best plotting routine. The routine randomly selects points in the domain and plots the periodic tiles contianing them.  When you use the carpet plot, you are in a sense plotting all tiles.  The green arrow keys are important here.  These keys specify when the computer should cutoff the calculation of an orbit.  If the number is too small here, the computer will abandon too many calculations and not plot enough tiles to give a good picture. If the number is too large, the computer might get hung up on computing a very long orbit.";
        M.D.setExplain(S);
        M.D.repaint();
    }


    public void proofInfo() {
        String S="proof calculation options.";
	S=S+"\n\nThese are the integer arithmetic calculations described in the paper. Here is a brief summary.";

	S=S+"\n\npartition: This checks that the partitions for the map, defined in terms of rational convex polyhedra, are correct.  You can see slices of these partitions by turning on the 'partition' options in the 'display' control panels.";

	S=S+"\n\ncalc 1: This checks that the tiling has bilateral symmetry in each of the regions labeled 'hex' and 'tri' on the 'regions' window.  You can see this visually by selecting these regions and then making a 'carpet' plot.  This is the slowest of the calculations. It takes about 30 seconds.  The calculation prints out numbers 1 to 48, and then says 'done'";

	S=S+"\n\ncalc 2: This checks that the tiling has bilateral symmetry in each of the regions labeled 'penta' and 'tri2' on the 'regions' window.  You can see this visually by selecting these regions and then making a 'carpet' plot. This is the second slowest of the calculations. It takes about 15 seconds.  The calculation prints out numbers 1 to 27, and then says 'done'";

	S=S+"\n\ncalc 3: This checks that the renormalization property for parameters s in the interval [5/4,2] and t=R(s) in the interval [1/4,1].  You can see what this calculation checks as follows:\n\n1.Select 'R' on the 'transforms' panel.\n2.Press the right green button on the top number entry region.\n3.Select the 'R' option on the 'regions' panel.\n4. Select the 'PET' option on the 'calc choice' panel.\n5. Select the 'carpet' option on the 'plot action' panel.\n6. Press 'go'.\n7. Once the calculation has run a while, press 'stop'.\n8. Click in a blank spot in the lower shape region to change the focus to the lower PET window.\n9. Press 'go' again.\n\nWhen you compare the pictures in the top and bottom PET windows, you will see that they are the same, inside the 'R' region.  The 'R' reqion on top is the set Z_s from the Main Theorem and the 'R' region on the bottom is the region Y_t from the Main Theorem.";

	S=S+"\n\ncalc 4:  This checks that the renormalization property for parameters s in the interval [1/2,3/4] and t=R(s) in the interval [1/4,1/2].  You can see a demo of what this calculation checks by following the procedure described for calc3, except that you for step 2 you should press the left green button on the top shape entry region.";

	S=S+"\n\ncalc 5:  This checks the first modular symmetry in the paper for the parameters s in (1,4/3] and u=mod1(s) in (1,2].  You can see a demo of what this calculation checks by following the same procedure as for calc3.\n\n1.Select 'mod1' on the 'transforms' panel.\n2.Press the pink button on the top number entry region.\n3.Select the 'mod1' option on the 'regions' panel.\n4. Select the 'PET' option on the 'calc choice' panel.\n5. Select the 'carpet' option on the 'plot action' panel.\n6. Press 'go'.\n7. Once the calculation has run a while, press 'stop'.\n8. Click in a blank spot in the lower shape region to change the focus to the lower PET window.\n9. Press 'go' again.\n\nWhen you compare the pictures in the top and bottom PET windows, you will see that they are the same, inside the 'mod1' region. The 'mod1' reqion on top is the set W_s from the Calculation 5 and the 'mod1' region on the bottom is the region Y_u from the Main Theorem.";

	S=S+"\ncalc6: This checks certain relations between the partitions for the PET and the auxilliary sets that appear in Calculation 5.  To see what this calculation is checking, follow the following procedure.\n\n1.Press the pink button on the top shape entry region.\n2.Select the 'inv. part.' (inverse partition) option from the 'display' panel.\n3. Select the 'R' and 'mod1' options from the 'regions' panel.\n4. Select the 'PET' option from the 'calc choice' panel.\n5. Select the 'orbit' option from the 'plot action' panel.\n6. Click the middle mouse button just to the right of the 'R' set in the top PET window.  (2 square tiles should appear.)";

	S=S+"\n\ncalc6 checks the following things.\n\n1.The square tile really exists and has period 2.\n2.The 'R' set is contained in a single tile of the inverse partition.\n3.The set outside 'R' and 'mod1' is contained in a union of 4 tiles in the inverse partition.";

	S=S+"\n\ncalc 7:  This checks the second modular symmetry in the paper for the parameters s in [3/4,1) and u=mod2(s) in [1/2,1)  You can see a demo of what this calculation checks by following the same procedure as for calc5, except for the following changes.\n\n1.Select 'mod2' on the 'transforms' panel.\n2.Press the light blue button on the top number entry region.\n3.Select the 'mod2' option on the 'regions' panel.\n";

	S=S+"\ncalc8: This checks certain relations between the partitions for the PET and the auxilliary sets that appear in Calculation 6.  To see what this calculation is checking, follow the following procedure.\n\n1.Press the light button on the top shape entry region.\n2.Select the 'partition' option from the 'display' panel.\n3. Select the 'R' and 'mod2' options from the 'regions' panel.\n4. Select the 'PET' option from the 'calc choice' panel.\n5. Select the 'orbit' option from the 'plot action' panel.\n6. Click the middle mouse button in the inside right of the 'R' set in the top PET window.  (2 square tiles should appear.)";

	S=S+"\n\ncalc8 checks the following things.\n\n1.The square tile really exists and has period 2.\n2.The 'R' set minus the square tiles is contained in a single tile of the partition.\n3.The set outside 'R' and 'mod1' is contained in a union of 4 tiles in the partition.";

        M.D.setExplain(S);
        M.D.repaint();
    }





}



