import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This is a class used in our rigorous computations.
  It is a vector in Z^3.  With each routine, we check
  to make sure that there is no overflow error*/



public class LongVector {
    long[] x=new long[3];

    public LongVector(){}


    public LongVector(long a0,long a1,long a2) {
	x[0]=a0;
	x[1]=a1;
	x[2]=a2;
    }

    public LongVector(long[] X) {
	for(int i=0;i<3;++i) x[i]=X[i];
    }

    public LongVector(LongVector V) {
	for(int i=0;i<3;++i) x[i]=V.x[i];
    }



    public static LongVector cross(LongVector v,LongVector w) {
	v.checkRangeLittle();
	w.checkRangeLittle();
	LongVector X=new LongVector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }


    public static LongVector plus(LongVector v1,LongVector v2) {
	v1.checkRangeBig();
	v2.checkRangeBig();
	LongVector w=new LongVector();
	for(int i=0;i<3;++i) w.x[i]=v1.x[i]+v2.x[i];
	return(w);
    }

    public static LongVector minus(LongVector v1,LongVector v2) {
	v1.checkRangeBig();
	v2.checkRangeBig();
	LongVector w=new LongVector();
	for(int i=0;i<3;++i) w.x[i]=v1.x[i]-v2.x[i];
	return(w);
    }

    public static LongVector scale(long r,LongVector v) {
	v.checkRangeLittle();
	checkRangeLittle(r);
	LongVector w=new LongVector();
	for(int i=0;i<3;++i) w.x[i]=r*v.x[i];
	return(w);
    }

    public LongVector scale(long r) {
	return(scale(r,this));
    }

    public static long dot(LongVector v,LongVector w) {	
        v.checkRangeLittle();
	w.checkRangeLittle();
	long d=0;
	for(int i=0;i<3;++i) d=d+v.x[i]*w.x[i];
	return(d);
    }

    public static LongVector normal(LongVector[] V) {
	LongVector W1=minus(V[1],V[0]);
	LongVector W2=minus(V[2],V[0]);
	LongVector X=cross(W1,W2);
	X=process(X);
	return(X);
    }

    public static LongVector process(LongVector W) {
	LongVector V=new LongVector(W);
	for(int i=0;i<3;++i) {
	    if(V.x[i]<0) V.x[i]=-V.x[i];
	}
	long min=1000000000000L;
	for(int i=0;i<3;++i) {
	    if((V.x[i]>0)&&(min>V.x[i])) min=V.x[i];
	}
	for(int i=0;i<3;++i) {
	    long d=V.x[i]%min;
	    if(d!=0) {
		return(W);
	    }
	}
	for(int i=0;i<3;++i) V.x[i]=W.x[i]/min;
	return(V);
    }

    public void print() {
	for(int i=0;i<3;++i)	{
	    System.out.print(x[i]+" ");
	}
	System.out.println("");
    }




    /*Checks for avoiding overflow error*/

    /*This checks if all the coords are less than 2^{62} in
      absolute value.  We use this before we add vectors or
      subtract them to make sure there is no overflow.*/

    public void checkRangeBig() {
	for(int i=0;i<3;++i) checkRangeBig(x[i]);
    }


    /*This checks if all the coords are less than 2^{30} in
      absolute value.  We use this before we use the dot
      or cross product to make sure there is no overflow.*/

    public void checkRangeLittle() {
	for(int i=0;i<3;++i) checkRangeLittle(x[i]);
    }

    /*This checks if a long is less than 2^{62} in absolute value*/

    public static void checkRangeBig(long r) {
	long m= 4611686018427387903L;
	if(r>m)   {throw new ProofException("number out of range 1");}
	if(r<-m)  {throw new ProofException("number out of range 2");}
    }


    /*This checks if a long is less than 2^{30} in absolute value.*/

    public static void checkRangeLittle(long r) {
        long m=1073741824L;
	if(r>m)   {throw new ProofException("number out of range 1");}
	if(r<-m)  {throw new ProofException("number out of range 2");}
    }
}




