import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PETCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M; 
    int TYPE;
    GeneralPath[] GP=new GeneralPath[100000];
    Color[] COLOR=new Color[100000];  
    int[] ORBIT=new int[100000];
    double[] TAG=new double[100000];
    int COUNT;
    int TILE_INDEX;   
    Point JX; 

     public PETCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,195,100);	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(M.C.DISPLAY[TYPE].L[0].on==1) drawDomain(g,1);
      if(M.C.DISPLAY[TYPE].L[1].on==1) drawDomain(g,2);
      if(M.C.DISPLAY[TYPE].L[2].on==1) drawLattice(g,1);
      if(M.C.DISPLAY[TYPE].L[3].on==1) drawLattice(g,2);
      drawTiles(g);
      if(M.C.DISPLAY[TYPE].L[4].on==1) drawPartition(0,g);   
      if(M.C.DISPLAY[TYPE].L[5].on==1) drawPartition(1,g);   
      if(M.C.DISPLAY[TYPE].L[6].on==1) drawIndividual(g);

      if(M.C.REGION.L[4].on==1) drawRenorm(g);
      if(M.C.REGION.L[5].on==1) drawMod1(g);
      if(M.C.REGION.L[6].on==1) drawMod2(g);
      for(int i=0;i<4;++i) {
          if(M.C.REGION.L[i].on==1) drawRegion(g,i);
      }
      drawMaps(g);
      drawSource(g);
      //      drawFrame(g);

   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(70,0,70));
	if(TYPE==1) g.setColor(new Color(0,0,100));
	g.fillRect(0,0,getWidth(),getHeight());
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("Z: zoom in",35,384);
	g.drawString("X: select point",150,384);
	g.drawString("C: zoom out",275,384);

    }

    public void drawFrame(Graphics2D g) {
	g.setStroke(new BasicStroke(3));
        g.setColor(new Color(50,100,255));
        g.drawRect(0,0,398,388);
	g.setStroke(new BasicStroke(1));
    }

    public void drawTiles(Graphics2D g) {
	Color COL2=Color.black;
	Output OUT=new Output("Output/tiling");
	for(int i=0;i<COUNT;++i) {  
	    GeneralPath gp=new GeneralPath(GP[i]); 
            Color COL=COLOR[i];
	    OUT.polyWrite(gp,COL,COL2);
	    gp=transform(gp);
	    g.setColor(COL);
	    g.fill(gp);
	    g.setColor(COL2);
	    g.draw(gp);
	}
    }

    public void drawDomain(Graphics2D g,int choice) {
	double s=M.C.getParameter(TYPE);
	PolygonWrapper P=BasicAlgebra.domain(choice,s);
	GeneralPath gp=P.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.DISPLAY[TYPE].M[0].C);
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }


    public void drawLattice(Graphics2D g,int choice) {	
        double s=M.C.getParameter(TYPE);
	GeneralPath gp=new GeneralPath();
	Matrix m=BasicAlgebra.dynamicsLattice(choice,s);
	Color COL=M.C.DISPLAY[TYPE].M[1+choice].C;

	for(int i=-5;i<=5;++i) {
            gp.reset();
	    for(int j=-5;j<=5;++j) {
		double[] p={i,j};
		Vector V=new Vector(p);
		V=Matrix.act(m,V);
		Complex z=new Complex(V.x[0],V.x[1]);
		//drawPoint(g,z,.005,COL,8,true);
		if(j==-5) gp.moveTo((float)(z.x),(float)(z.y));
		if(j>-5) gp.lineTo((float)(z.x),(float)(z.y));	
	    }
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
	for(int i=-5;i<=5;++i) {
            gp.reset();
	    for(int j=-5;j<=5;++j) {
		double[] p={j,i};
		Vector V=new Vector(p);
		V=Matrix.act(m,V);
		Complex z=new Complex(V.x[0],V.x[1]);
		drawPoint(g,z,.01,Color.white,8,true);
		if(j==-5) gp.moveTo((float)(z.x),(float)(z.y));
		if(j>-5) gp.lineTo((float)(z.x),(float)(z.y));	
	    }
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
    }


    public boolean drawRenorm(Graphics2D g) { 
        double s=M.C.getParameter(TYPE);
	for(int i=2;i<20;++i) {
	    if(s==1.0/i) return(false);
	}

        PolygonWrapper P1=Renormalize.renormRange(s);
        PolygonWrapper P2=Renormalize.renormRange(s);
	if(TYPE==1) {
	    P1=Renormalize.renormDomain(s);
	    P2=Renormalize.renormDomain(s);
	}
	for(int i=0;i<P2.count;++i) P2.z[i]=Complex.times(P2.z[i],new Complex(-1,0));
	GeneralPath gp1=P1.toGeneralPath();
	gp1=transform(gp1);
	GeneralPath gp2=P2.toGeneralPath();
	gp2=transform(gp2);
	g.setColor(M.C.REGION.M[4].C);
	g.fill(gp1);
	g.draw(gp1);
	g.fill(gp2);
	g.draw(gp2);
	return(true);
    }

    public boolean drawMod1(Graphics2D g) { 
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	if((s<1)||(s>4.0/3)) {
	    return(false);
	}
        PolygonWrapper P1=Renormalize.mod1Range(s);
	GeneralPath gp=P1.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.REGION.M[5].C);
	g.fill(gp);
	g.draw(gp);
	for(int i=0;i<P1.count;++i) P1.z[i]=new Complex(-P1.z[i].x,-P1.z[i].y);
        gp=P1.toGeneralPath();
	gp=transform(gp);
	g.fill(gp);
	g.draw(gp);
	return(true);
    }

    public boolean drawMod2(Graphics2D g) { 
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	if((s<3.0/4)||(s>1)) {
	    return(false);
	}
        PolygonWrapper P1=Renormalize.mod2Range(s);
	GeneralPath gp=P1.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.REGION.M[6].C);
	g.fill(gp);
	g.draw(gp);
	for(int i=0;i<P1.count;++i) P1.z[i]=new Complex(-P1.z[i].x,-P1.z[i].y);
        gp=P1.toGeneralPath();
	gp=transform(gp);
	g.fill(gp);
	g.draw(gp);
	return(true);
    }




    public boolean drawRegion(Graphics2D g,int choice) { 
	double[] bound={1,1,.5,.5};
        double s=M.C.getParameter(TYPE);
	PolygonWrapper P=new PolygonWrapper();
	if(choice==0) P=Symmetries.hexDomain(s);
	if(choice==1) P=Symmetries.triDomainLeft(s);
	if(choice==2) P=Symmetries.pentaDomainLeft(s);
	if(choice==3) P=Symmetries.triDomain2Left(s);
	if(P==null) return(false);
	if(s>bound[choice]) return(false);
	GeneralPath gp=P.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.REGION.M[choice].C);
	g.fill(gp);
	g.draw(gp);
	return(true);
    }


    public boolean drawPartition(int choice,Graphics2D g) {
	double s=M.C.getParameter(TYPE);
	if(s<1.0/4) {
	    return(false);
	}
	Color C=M.C.DISPLAY[TYPE].M[4].C;
	if(choice==1) C=M.C.DISPLAY[TYPE].M[5].C;
	for(int i=0;i<51;++i) {
	  LongPolyhedron X0=DataPartition.poly(i);
	  if(choice==1) X0=DataPartition.imagePoly(i);
	  Polyhedron X=X0.toPolyhedron();
	  drawSlice(g,X,s,C);
	}
	return(true);
    }

    public boolean drawIndividual(Graphics2D g) {
	int p4=M.C.DISPLAY[TYPE].L[4].on;
	int p5=M.C.DISPLAY[TYPE].L[5].on;
	if(p4+p5!=1) return(false);
	Color C=M.C.DISPLAY[TYPE].M[6].C;
	int i=M.C.POLY.val;
	int j=M.C.FACE.val;
	  double s=M.C.getParameter(TYPE);
	  LongPolyhedron X0=DataPartition.poly(i);
	  if(p5==1) X0=DataPartition.imagePoly(i);
	  Polyhedron X=X0.toPolyhedron();
          drawSlice(g,X,s,C);

	  LongPolyhedron X1=X0.toFace(j);
          X=X1.toPolyhedron();
	  g.setStroke(new BasicStroke(3));
          drawSlice(g,X,s,Color.yellow);
          g.setStroke(new BasicStroke(1));
	  return(true);
    }

    public boolean drawMaps(Graphics2D g) {
	boolean block=false;
	if(TYPE==1) return(false);
	double s=M.C.getParameter(TYPE);
	int v=M.C.MAP.mode;
	int[] lo={0,1,1,33,20};
	int[] hi={-1,32,19,51,32};
	for(int i=lo[v];i<hi[v];++i) {
	    LongPolyhedron X0=new LongPolyhedron();
	    Polyhedron X=new Polyhedron();

	    if(v==1) {
	       block=false;
               X0=DataPartition.imagePoly(i);
	       X0=ProofCalc3.phi(X0);
	       X=X0.toPolyhedron();
	       if(i==19) block=true;
	    }

	    if(v==2) {
               X0=DataPartition.imagePoly(i);
	       X0=ProofCalc4.phi(X0);
	       X=X0.toPolyhedron();
	    } 
 
	    if(v==3) {
               X0=DataPartition.poly(i);
               X0=DataSymmetry.modular1(X0); 
               X=X0.toPolyhedron();
	    }

	    if(v==4) {
               X0=DataPartition.poly(i);
               X0=DataSymmetry.modular2(X0); 
               X=X0.toPolyhedron();
	    }

	    if(block==false) drawSlice(g,X,s,new Color(255,0,0,150));
	}
	return(true);
    }

    public void drawSlice(Graphics2D g,Polyhedron X,double s,Color C) {
         PolygonWrapper P=PolyhedronSlicer.basicSlice(X,s);
	 if(P!=null) {
	    GeneralPath gp=P.toGeneralPath();
	    gp=transform(gp);
	    g.setColor(C);
            g.fill(gp);
	    g.setColor(Color.white);
	    g.draw(gp);
	 }
    }







    public void getIndex() {
	TILE_INDEX=getIndex(SOURCE);
    }

    public int getIndex(Complex z) {
	int index=-1;
	for(int i=0;i<COUNT;++i) {
	    if(GP[i].contains(z.x,z.y)==true) index=i;
	}
	return(index);
    }


    public void doAction() {
	getIndex();
	int t=TILE_INDEX;
	int m=M.C.ACTION.mode;

	if(m==0) M.C.doAction();

	if(t!=-1) {
	    if(m==1) {
               COLOR[t]=M.C.CS.C;
	       double tag=TAG[TILE_INDEX];
	       for(int i=0;i<COUNT;++i) {
		   if(TAG[i]==tag) {
                       COLOR[i]=M.C.CS.C;
		       PolygonWrapper P=PolygonWrapper.fromGeneralPath(GP[i]);
		       polyCoords(P);
		   }
	       }
	    }
	}
    }

    public void polyCoords(PolygonWrapper P) {
	for(int i=0;i<8;++i) M.C.MESSAGE[i]="";
	int[] d=M.C.getFraction(TYPE);
	Integer D=new Integer(d[1]);
	for(int i=0;i<P.count;++i) {
	    int x=MathRational.convert(d[1]*P.z[i].x);
	    int y=MathRational.convert(d[1]*P.z[i].y);
	    Integer X=new Integer(x);
	    Integer Y=new Integer(y);
	    String S=X.toString()+"/"+D.toString();
	    S=S+"    "+Y.toString()+"/"+D.toString();
	    M.C.MESSAGE[i]=S;
	    M.C.repaint();
	}
    }

    public void acceptTileDebug(PolygonWrapper P) {
	acceptTile(P,Color.red,0,0,false);
    }


    public void acceptTile(PolygonWrapper P,Color COL,int orbit,double tag,boolean block) {
	Complex z=P.center();
	int index=getIndex(z);
	if((block==false)||(index==-1)) {
	    GP[COUNT]=P.toGeneralPath();
	    ORBIT[COUNT]=orbit;
	    TAG[COUNT]=tag;
	    COLOR[COUNT]=COL;
	    ++COUNT;
	}
    }




    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	JX=J.X;
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {
	M.C.FOCUS=TYPE;
          if(mode==1)  {
             scaleUp(JX,0);
	  }

          if(mode==3)  {
            scaleUp(JX,1);
	  }

	  if(mode==2)  {
	    SOURCE=unTransform(JX);
	    doAction();
	  }
        repaint();
    }


    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
    public void mouseDragged(MouseEvent e) {}



    public void keyTyped(KeyEvent e) {

	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	repaint();
    }


    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

