

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Lever REFINE,SPEED,SEED,COLOR,STYLE;
    Lever[] GHOST=new Lever[2];
    Lever[] BRIGHT=new Lever[2];
    Lever[] OUTLINE=new Lever[2];
    int MARKER_VAL,INNER;
    int[][] LOCAL=new int[2][2];

    IntegerSelector[] MARKER=new IntegerSelector[2];
    ListenSquare  MARKER_TOGGLE,TEXT,MAG,DISMISS;
    ListenSquare CONTROL1,CONTROL2,GO,HALT;
    Wedge[] WEDGE=new Wedge[62500];
    Quad[] QUAD=new Quad[62500];
    int W_COUNT,Q_COUNT;
    Documentation DOC;
    Sampler S;

     public ControlCanvas() {
	 setScales(250,240);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 S=new Sampler();

	 SEED=new Lever(130,548,0,3);
	 SEED.val=2;
	 REFINE=new Lever(180,548,0,8);
	 GHOST[0]=new Lever(10,18,7,8);
	 GHOST[1]=new Lever(590,18,7,8);
	 BRIGHT[0]=new Lever(160,18,7,8);
	 BRIGHT[1]=new Lever(740,18,7,8);
	 OUTLINE[0]=new Lever(310,18,7,8);
	 OUTLINE[1]=new Lever(890,18,7,8);
	 COLOR=new Lever(450,18,1,2);
	 STYLE=new Lever(520,18,2,3);


	 TEXT=new ListenSquare(0,530,15,15,null);TEXT.on=1;
	 MAG=new ListenSquare(0,545,15,15,null);MAG.on=1;
	 DISMISS=new ListenSquare(55,530,15,15,null);DISMISS.on=1;
	 INNER=0;

	 SPEED=new Lever(840,548,4,8);
	 MARKER[0]=new IntegerSelector(720,530,60,30,0,0,8,1);
	 MARKER_TOGGLE=new ListenSquare(520,530,70,15,null);
	 MARKER_TOGGLE.on=1;
	 MARKER_VAL=1;

	 CONTROL1=new ListenSquare(0,0,1000,30,null); CONTROL1.on=1;
	 CONTROL2=new ListenSquare(0,530,1000,30,null); CONTROL2.on=1;
	 GO=new ListenSquare(950,530,40,15,null); GO.on=1;
	 HALT=new ListenSquare(950,545,40,15,null); HALT.on=1;

	 initializeWedges();	
	 initializeQuads();
	 DOC=new Documentation();

     }


    public void initializeWedges() {
	int k=SEED.val;
	if(k==0) initializeWedges0();
	if(k==1) initializeWedges1();
	if(k==2) initializeWedges2();
	if(k==3) initializeWedges2();     
                  for(int i=0;i<W_COUNT;++i) {
	 WEDGE[i]=WEDGE[i].translate(new Complex(0,.125));
	}
    }

    public void initializeQuads() {
	int k=SEED.val;
	if(k==0) initializeQuads0();
	if(k==1) initializeQuads1();
	if(k==2) initializeQuads2();	
                  for(int i=0;i<Q_COUNT;++i) {
                   QUAD[i]=QUAD[i].scale(new Complex(1.0/9.0,0));
	 QUAD[i]=QUAD[i].translate(new Complex(2.09,.125));
	}
    }


    public void initializeWedges0() {
	W_COUNT=1;
	WEDGE[0]=Wedge.initialWedge(0);
    }
    public void initializeQuads0() {

	Q_COUNT=1;
	QUAD[0]=Quad.initialQuad(1);
    }

    public void initializeWedges1() {	
                  MARKER[0].val=0;
	W_COUNT=1;	
                  WEDGE[0]=Wedge.initialWedge(0);
	Wedge[] temp=WEDGE[0].subdivide();
	WEDGE[0]=new Wedge(temp[0]);
    }

    public void initializeQuads1() {
                   MARKER[0].val=0;
	Q_COUNT=1;
	QUAD[0]=Quad.initialQuad(1);
	Quad[] temp=QUAD[0].subdivide();
	QUAD[0]=new Quad(temp[0]);

    }



    public void initializeWedges2() {
	W_COUNT=8;
	for(int i=0;i<8;++i)
	WEDGE[i]=Wedge.initialWedge(i);
    }

    public void initializeQuads2() {
	Q_COUNT=4;
	for(int i=0;i<4;++i)
	    QUAD[i]=Quad.initialQuad((i+1)%4);
    }

    public void setPaintWindow() {}

    public void drawMagnifier(Graphics2D g) {

	int val=MARKER[0].val;
	int max=W_COUNT;
	Wedge[] MAG=new Wedge[7];
	for(int i=0;i<7;++i) {
	    MAG[i]=new Wedge(WEDGE[(i+val-3+max)%max]);
	}
	Quad Z=Poly.getSquare(MAG,7);
	Quad W=Quad.smallSquare();

	GeneralPath gp1=W.toGeneralPath(1);
	gp1=transform(gp1);	  
	g.setColor(new Color(0,0,60));
	g.fill(gp1);
	g.setColor(Color.white);
	g.draw(gp1);
                  g.setStroke(new BasicStroke(1));

	for(int i=0;i<7;++i) {
                     MAG[i]=Poly.finalMap(Z,W,MAG[i]);

	  GeneralPath gp=MAG[i].toGeneralPath(STYLE.val);
	  gp=transform(gp);
	  Color C=getColor2(MAG[i].type);
	  g.setColor(C);
	  g.fill(gp);	
                   if(STYLE.val!=0) g.setColor(Color.white);
	if(STYLE.val==1) g.setStroke(new BasicStroke(2));
	  g.draw(gp);
	}

    }

    public void refineWedge(int mode) {
	if(mode==0) refineWedge0();
	if(mode==1) refineWedge1();
    }


    public void refineQuad(int mode) {
	if(mode==0) refineQuad0();
	if(mode==1) refineQuad1();
    }




    public void refineWedge0() {
	Wedge[] temp1=new Wedge[5*W_COUNT];
	int count=0;
	for(int i=0;i<W_COUNT;++i) {
	    Wedge[] temp2=WEDGE[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp1[count]=new Wedge(temp2[j]);
		++count;
	       }
	}
	W_COUNT=count;
	for(int i=0;i<W_COUNT;++i) {
	    WEDGE[i]=new Wedge(temp1[(i+2)%W_COUNT]);
	}
    }


    public void refineWedge1() {

	Wedge[] temp1=new Wedge[5*W_COUNT];
	int count=0;
	for(int i=0;i<W_COUNT;++i) {
	    Wedge[] temp2=WEDGE[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp1[count]=new Wedge(temp2[j]);
		++count;
	       }
	}
	W_COUNT=count;
	for(int i=0;i<W_COUNT;++i) {
	    WEDGE[i]=new Wedge(temp1[(i+2)%W_COUNT]);
	}

	Wedge[] temp3=new Wedge[5*W_COUNT];
	count=0;

	for(int i=0;i<W_COUNT;++i) {
	    if(WEDGE[i].type==0) {
		temp3[count]=new Wedge(WEDGE[i]);
	              ++count;
	    }
	    if(WEDGE[i].type==1) {
	         Wedge[] temp2=WEDGE[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp3[count]=new Wedge(temp2[j]);
		++count;
	       }
	    }
	}
	W_COUNT=count;
	for(int i=0;i<W_COUNT;++i) {
	    WEDGE[i]=new Wedge(temp3[(i+2)%W_COUNT]);
	}
    }





    public void refineQuad0() {
	Quad[] temp1=new Quad[12*Q_COUNT];
	int count=0;
	for(int i=0;i<Q_COUNT;++i) {
	    Quad[] temp2=QUAD[i].subdivide();
	    for(int j=0;j<temp2.length;++j) {
		temp1[count]=new Quad(temp2[j]);
		++count;
	    }
	}
	Q_COUNT=count;
	for(int i=0;i<Q_COUNT;++i) {
	    QUAD[i]=new Quad(temp1[(i+2)%Q_COUNT]);
	}
    }


    public void refineQuad1() {

	Quad[] temp1=new Quad[5*Q_COUNT];
	int count=0;
	for(int i=0;i<Q_COUNT;++i) {
	    Quad[] temp2=QUAD[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp1[count]=new Quad(temp2[j]);
		++count;
	       }
	}
	Q_COUNT=count;
	for(int i=0;i<Q_COUNT;++i) {
	    QUAD[i]=new Quad(temp1[(i+2)%Q_COUNT]);
	}

	Quad[] temp3=new Quad[5*Q_COUNT];
	count=0;

	for(int i=0;i<Q_COUNT;++i) {
	    if(QUAD[i].type==0) {
                                temp3[count]=new Quad(QUAD[i]);
	              ++count;
	    }
	    if(QUAD[i].type==1) {
	         Quad[] temp2=QUAD[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp3[count]=new Quad(temp2[j]);
		++count;
	       }
	    }
	}
	Q_COUNT=count;
	for(int i=0;i<Q_COUNT;++i) {
	    QUAD[i]=new Quad(temp3[(i+2)%Q_COUNT]);
	}
    }




    public void refineQuadSelect(int type) {
	Quad[] temp3=new Quad[5*Q_COUNT];
	int count=0;

	for(int i=0;i<Q_COUNT;++i) {
	    if(QUAD[i].type!=type) {
		temp3[count]=new Quad(QUAD[i]);
	              ++count;
	    }
	    if(QUAD[i].type==type) {
	         Quad[] temp2=QUAD[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp3[count]=new Quad(temp2[j]);
		++count;
	       }
	    }
	}
	Q_COUNT=count;
	for(int i=0;i<Q_COUNT;++i) {
	    QUAD[i]=new Quad(temp3[(i+2)%Q_COUNT]);
	}
    }







    public void refineWedgeSelect(int type) {
	Wedge[] temp3=new Wedge[5*W_COUNT];
	int count=0;

	for(int i=0;i<W_COUNT;++i) {
	    if(WEDGE[i].type!=type) {
		temp3[count]=new Wedge(WEDGE[i]);
	              ++count;
	    }
	    if(WEDGE[i].type==type) {
	         Wedge[] temp2=WEDGE[i].subdivide();
	       for(int j=0;j<temp2.length;++j) {
		temp3[count]=new Wedge(temp2[j]);
		++count;
	       }
	    }
	}
	W_COUNT=count;
	for(int i=0;i<W_COUNT;++i) {
	    WEDGE[i]=new Wedge(temp3[(i+2)%W_COUNT]);
	}
    }



    public void doRefineWedge() {     
                  MARKER[0].val=0;
	initializeWedges();
	for(int i=0;i<REFINE.val;++i) {
	    refineWedgeSelect(i%2);
	}
    }

    public void doRefineQuad() {	
	initializeQuads();
	for(int i=0;i<REFINE.val;++i) {
	    refineQuadSelect(i%2);
	}
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      g.fillRect(0,0,getWidth(),getHeight()); 
      drawControls(g);
      drawSnowflake(g);    
      drawCarpet(g);
      setPaintWindow();
      if(MARKER_VAL==1) highlightSnowflake(g);
      if(MARKER_VAL==1) highlightCarpet(g);
      if(INNER==0) DOC.render(g);
      if(INNER==1) drawMagnifier(g);
      drawTitle(g);
   }

    public void drawTitle(Graphics2D g) {

	g.setColor(new Color(200,0,200));
	g.fillRect(290,530,220,30);
	g.setColor(Color.white);
	g.drawRect(290,530,220,30);

      g.setFont(new Font("Helvetica",Font.PLAIN,20));
      g.setColor(Color.yellow);
      g.drawString("OctoMap",300,552);

      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.drawString("by Rich Schwartz",400,552);

    }

    public void drawControls(Graphics2D g) {	
	CONTROL1.render(g,new Color(0,0,220));
	CONTROL2.render(g,new Color(0,0,220));

	if(INNER==0) TEXT.render(g,Color.yellow);
	if(INNER!=0) TEXT.render(g,new Color(150,0,150));
	if(INNER==1) MAG.render(g,Color.yellow);
	if(INNER!=1) MAG.render(g,new Color(150,0,150));
	DISMISS.render(g,new Color(150,0,150));



                  g.setFont(new Font("Helvetica",Font.PLAIN,11));
		  g.setColor(Color.white);
		  g.drawString("text",20,541);
		  g.drawString("dismiss",75,541);
		  g.drawString("mag",20,556);

	if(MARKER_VAL==0) MARKER_TOGGLE.render(g,new Color(200,0,200),"marker: off");
	if(MARKER_VAL==1) MARKER_TOGGLE.render(g,new Color(200,0,200),"marker: on");

	SEED.render(g,"seed");
	REFINE.render(g,"refine");

	for(int i=0;i<2;++i) {
	GHOST[i].render(g,"transparency");
	BRIGHT[i].render(g,"brightness");
	OUTLINE[i].render(g,"outline");
	}
	COLOR.render(g,"color");
	STYLE.render(g,"style");
	
	if(MARKER_VAL==1) {
	    MARKER[0].render(g,new Color(150,0,150),Color.white,new Color(0,0,0,0));
                     g.setFont(new Font("Helvetica",Font.PLAIN,12));
		     g.setColor(Color.white);
	     g.drawString("marker position",620,550);
                       SPEED.render(g,"speed");
	}

	if((MARKER_VAL==1)&&(S.halt==0)) {
                         GO.render(g,new Color(200,0,200),"GO");
	}
	if(S.halt==1) HALT.render(g,new Color(200,0,200),"STOP");
	g.setColor(Color.white);  

    }

    /**i specifies snowflake/carpet, j specifies type color**/

    public Color getColor(int i,int j) {
	if(COLOR.val==0) return(Color.white);
	int ghost=32*GHOST[i].val+31;
	int bright=32*BRIGHT[i].val+31;

	  Color C1=new Color(bright,0,bright,ghost);
	  Color C2=new Color(bright/6,bright/3,bright,ghost);
	  if(j==0) return(C1);
	  return(C2);

    }

    public Color getOutline(int i) {
 	int ghost=32*OUTLINE[i].val+31;
	Color C1=new Color(255,255,255,ghost);
	  return(C1);
    }

    public Color getColor2(int j) {

	int ghost=255;
	int bright=255;
	  Color C1=new Color(bright,0,bright,ghost);
	  Color C2=new Color(bright/6,bright/3,bright,ghost);
	  if(j==0) return(C1);
	  return(C2);

    }



    public void drawSnowflake(Graphics2D g) {	
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<W_COUNT;++i) {
	    gp=WEDGE[i].toGeneralPath(STYLE.val);
	    gp=transform(gp);     
	    Color C=getColor(0,WEDGE[i].type);    
                      g.setColor(C);
	    g.fill(gp);
                      if(STYLE.val!=0) {
                               C=getOutline(0);    	
	    }	    
	    if(STYLE.val==0) {
		g.setStroke(new BasicStroke(2));
	    }
                      g.setColor(C);
	    g.draw(gp);
	}	
                  g.setStroke(new BasicStroke(1));
    }

    public void drawCarpet(Graphics2D g) {
	if(STYLE.val==2) {
	  drawCarpet(g,1);
	  drawCarpet(g,0);
	}
	if(STYLE.val!=2) {
	  drawCarpet(g,0);
	  drawCarpet(g,1);
	}

    }

    public void drawCarpet(Graphics2D g,int type) {
	int ghost=32*GHOST[0].val+31;
	 g.setColor(Color.red);
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<Q_COUNT;++i) {
	    if(QUAD[i].type==type) {
	    gp=QUAD[i].toGeneralPath(STYLE.val);
	    gp=transform(gp);     
	    Color C=getColor(1,QUAD[i].type);
	    g.setColor(C);
	    g.fill(gp);	    
	    if(STYLE.val!=0) {
                               C=getOutline(1);    	
	    }	    
	    if(STYLE.val==0) {
		g.setStroke(new BasicStroke(2));
	    }

                      g.setColor(C);
	    g.draw(gp);
	    }
	}
	g.setStroke(new BasicStroke(1));
    }




    public void highlightSnowflake(Graphics2D g) {
	g.setColor(Color.white);
	int lim=0;
	GeneralPath gp=new GeneralPath();
	int init0=MARKER[0].val;
	for(int i=init0-lim;i<=init0+lim;++i) {
	    int j=(i+W_COUNT)%W_COUNT;
	    gp=WEDGE[j].toGeneralPath(STYLE.val);
	    gp=transform(gp);     
	    Color C=Color.white;
	    g.fill(gp);     
                      g.setStroke(new BasicStroke(4));
	    g.draw(gp);
                      g.setStroke(new BasicStroke(1));
	}
    }


    public void highlightCarpet(Graphics2D g) {
	g.setColor(Color.white);
	GeneralPath gp=new GeneralPath();
	int init0=MARKER[0].val;
	for(int i=init0;i<init0+1;++i) {
	    int j=i%Q_COUNT;
	    gp=QUAD[j].toGeneralPath(STYLE.val);
	    gp=transform(gp);     
	    Color C=Color.white;

	    if(STYLE.val==1) {
		g.setStroke(new BasicStroke(4));
	    }
	    g.fill(gp);
	    g.draw(gp);
	}    
                    g.setStroke(new BasicStroke(1));
    }

    public void setHighlight(Point X) {
	   MARKER[0].max=W_COUNT;
	   MARKER[0].modifyCyclic(X);
    }

    public void getNearestWedge(Point X) {
	int TEST=1;
	if(CONTROL1.inside(X)==1) TEST=0;
	if(CONTROL2.inside(X)==1) TEST=0;
	if(TEST==1) {


	int index=-1;
	if(X.x<500) {
	    Complex z=unTransform(X);

	    for(int i=0;i<W_COUNT;++i) {
		if(WEDGE[i].contains(z)==true) index=i;
	    }
	    if(index!=-1) MARKER[0].val=index;
	    if(index==-1) {
	      double min=100;
	      for(int i=0;i<W_COUNT;++i) {
	           double test=WEDGE[i].dist(z);
		   if(min>test) {
		       min=test;
		       index=i;
		   }
	      }
                         if(index!=-1) MARKER[0].val=index;
	    }
	}
	}
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	int test=0;
	if(INNER==0) {
                       test=DOC.process(e);
                       if(test==1) repaint();
	}


                  if(test==0) doControls(e);
    }

    
    public void doControls(MouseEvent e) {
                 MouseData J=MouseData.process(e);
	int test1=REFINE.process(J.X);	
	SEED.process(J.X);


	if(REFINE.val>6) S.halt=0;
	    int test2=SEED.isUsed(J.X);

	   if(test1+test2>0) {
	    doRefineWedge();
	    doRefineQuad();
	}

	   for(int i=0;i<2;++i) {
	      GHOST[i].process(J.X);
	      BRIGHT[i].process(J.X);
	      OUTLINE[i].process(J.X);
	   }
	SPEED.process(J.X);
	setHighlight(J.X);
	if(TEXT.inside(J.X)==1) INNER=0;
	if(MAG.inside(J.X)==1) INNER=1;
	if(DISMISS.inside(J.X)==1) INNER=-1;

	if(MARKER_TOGGLE.inside(J.X)==1) MARKER_VAL=1-MARKER_VAL;


	COLOR.process(J.X);
	STYLE.process(J.X);
	getNearestWedge(J.X);
	DOC.process(e);
	if((S.halt==0)&&(GO.inside(J.X)==1)) doRun();
	if(HALT.inside(J.X)==1) S.halt=0;
	repaint();
    }

    public void doRun() {
	S=new Sampler(this);
	new Thread(S).start();
    }


    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 


}

