#! /usr/local/bin/wish  -f

set HEIGHT 600
canvas .plot -width 600 -height 600 -bg red
canvas .post -width 600 -height 20 -bg white
pack .post
pack .plot

.plot create rectangle -100 -100 1000 1000 -fill white -tag backdrop
.plot create rectangle 1 1 598 $HEIGHT -fill #ddd -outline black -tag screen


######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}
######################################




.post create rectangle 0 0 70 50 -fill green -tag export
.post create rectangle 100 0 170 50 -fill #ddd -tag window
.post create rectangle 200 0 270 50 -fill orange -tag aspect


#### export window height########

.post bind window <Button-1> {
global HEIGHT
set HEIGHT [expr $HEIGHT + 50]
.plot delete screen
.plot create rectangle 0 0 600 $HEIGHT -tag screen -fill  #ddd -outline black
.plot lower screen
.plot lower backdrop
}

.post bind window <Button-1> {
.plot delete screen
    change_window 50 }

.post bind window <Button-2> {
.plot delete screen
    change_window -50 }

.post bind window <Button-3> {
.plot delete screen
    change_window -50 }

proc change_window {x} {
global HEIGHT
set HEIGHT [expr $HEIGHT +$x]
.plot create rectangle 1 1 598 $HEIGHT -tag screen -fill  #ddd -outline black
.plot lower screen
.plot lower backdrop
}


#######aspect ratio ##########

set a1 1.05
set a2 [expr 1.0/$a1]
.post bind aspect <Button-1> {
global a1
.plot scale X 300 300  $a1 1 }

.post bind aspect <Button-2> {
global a2
.plot scale X 300 300  $a2 1 }

.post bind aspect <Button-3> {
global a2
.plot scale X 300 300  $a2 1 }


#########exporting###########

.post bind export <Any-Button> post
.post create text 8 13 -anchor w -text "export" -fill black -tag post
.post create text 108 13 -anchor w -text "window" -fill black -tag window
.post create text 208 13 -anchor w -text "aspect" -fill black -tag aspect

source picture_data 
.plot move X  0 0
.plot scale X 0 0 1.2 1.2

proc post {} {
global HEIGHT
.plot delete screen
.plot postscript -pageheight 600 \
-height $HEIGHT \
-file "temp.ps"
}
