

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Lever REFINE,GHOST,BRIGHT;
    IntegerSelector MARKER,PATH_SKIP;
    ListenSquare CONTROL;
    Wedge[] WEDGE=new Wedge[62500];
    Quad[] QUAD=new Quad[62500];
    int W_COUNT,Q_COUNT;
    ControlPanel START,OUTLINE1,OUTLINE2,COLOR,TEXT,ISO;
    Documentation DOC;

     public ControlCanvas() {
	 setScales(250,240);
	 addMouseListener(this);
	 addMouseMotionListener(this);

	 REFINE=new Lever(502,150,0,6);
	 GHOST=new Lever(502,190,7,8);
	 BRIGHT=new Lever(502,230,7,8);

	 MARKER=new IntegerSelector(505,335,50,25,0,0,8,1);

	 CONTROL=new ListenSquare(500,0,100,500,null); CONTROL.on=1;	 
                   makePanels();	
	 initializeWedges();	
	 initializeQuads();
	 DOC=new Documentation();

     }

  public void makePanels() {
      Color[] C1={new Color(200,0,200),Color.white,Color.white,Color.black,Color.green};
      Color[] C2={new Color(50,100,255),Color.white,Color.white,Color.black,Color.green};
      String[] S1={"0","1","2","seed"};
      int[] state1={0,0,1};
                   START=new ControlPanel(C1,S1,state1,3);
	 START.mode=2;

	 String[] S2={"yes","no","outline"};
	 int[] state2={1,0};
                   OUTLINE1=new ControlPanel(C1,S2,state2,2);

	 String[] S4={"yes","no","outline"};
	 int[] state4={1,0};
                   OUTLINE2=new ControlPanel(C1,S4,state4,2);

	 String[] S5={"text","magnifier","empty","inner display"};
	 int[] state5={1,0,0};
                   TEXT=new ControlPanel(C1,S5,state5,3);

	 String[] S3={"white","red/blue","colors"};
	 int[] state3={0,1,0};
                   COLOR=new ControlPanel(C1,S3,state3,2);
	 COLOR.L[1].on=1;
	 COLOR.mode=1;

	 String[] S6={"on","off","marker"};
	 int[] state6={1,0};
                   ISO=new ControlPanel(C1,S6,state6,2);
  }

    public void initializeWedges() {
	int k=START.mode;
	if(k==0) initializeWedges0();
	if(k==1) initializeWedges1();
	if(k==2) initializeWedges2();
	if(k==3) initializeWedges2();
    }
    public void initializeQuads() {
	int k=START.mode;
	if(k==0) initializeQuads0();
	if(k==1) initializeQuads1();
	if(k==2) initializeQuads2();
    }


    public void initializeWedges0() {
	W_COUNT=1;
	WEDGE[0]=Wedge.initialWedge(0);
    }
    public void initializeQuads0() {

	Q_COUNT=1;
	QUAD[0]=Quad.initialQuad(1);
	for(int i=0;i<1;++i) {
                   QUAD[i]=QUAD[i].scale(new Complex(1.0/9.0,0));
	 QUAD[i]=QUAD[i].translate(new Complex(2.5,0));
	}
    }

    public void initializeWedges1() {	
                 MARKER.val=0;
	W_COUNT=1;	
                  WEDGE[0]=Wedge.initialWedge(0);
	Wedge[] temp=WEDGE[0].subdivide();
	WEDGE[0]=new Wedge(temp[0]);
    }

    public void initializeQuads1() {

	Q_COUNT=1;
	QUAD[0]=Quad.initialQuad(1);
	for(int i=0;i<1;++i) {
                                QUAD[i]=QUAD[i].scale(new Complex(1.0/9.0,0));
	              QUAD[i]=QUAD[i].translate(new Complex(2.5,0));
	}
	Quad[] temp=QUAD[0].subdivide();
	QUAD[0]=new Quad(temp[0]);

    }



    public void initializeWedges2() {
	W_COUNT=8;
	for(int i=0;i<8;++i)
	WEDGE[i]=Wedge.initialWedge(i);
    }

    public void initializeQuads2() {

	Q_COUNT=4;
	for(int i=0;i<4;++i)
	    QUAD[i]=Quad.initialQuad((i+1)%4);
	for(int i=0;i<4;++i) {
                                QUAD[i]=QUAD[i].scale(new Complex(1.0/9.0,0));
	              QUAD[i]=QUAD[i].translate(new Complex(2.5,0));
	}
    }


    public void drawMagnifier(Graphics2D g) {

	int val=MARKER.val;
	int max=W_COUNT;
	Wedge[] MAG=new Wedge[7];
	for(int i=0;i<7;++i) {
	    MAG[i]=new Wedge(WEDGE[(i+val-3+max)%max]);
	}
	Quad Z=Poly.getSquare(MAG,7);
	Quad W=Quad.smallSquare();


	GeneralPath gp1=W.toGeneralPath();
	gp1=transform(gp1);	  
	g.setColor(new Color(0,0,60));
	g.fill(gp1);
                  g.setColor(Color.white);
	g.draw(gp1);


	for(int i=0;i<7;++i) {
                     MAG[i]=Poly.finalMap(Z,W,MAG[i]);

	  GeneralPath gp=MAG[i].toGeneralPath();
	  gp=transform(gp);
	  Color C=getColor2(MAG[i].type);
	  g.setColor(C);
	  if((ISO.mode==0)&&(i==3)) g.setColor(Color.white);
	  g.fill(gp);
	  g.setColor(Color.white);
	  g.draw(gp);
	}

    }


    public void refineWedge() {

	Wedge[] temp1=new Wedge[5*W_COUNT];
	int count=0;
	for(int i=0;i<W_COUNT;++i) {
	    Wedge[] temp2=WEDGE[i].subdivide();
	       for(int j=0;j<5;++j) {
		temp1[count]=new Wedge(temp2[j]);
		++count;
	       }
	}
	W_COUNT=5*W_COUNT;
	for(int i=0;i<W_COUNT;++i) {
	    WEDGE[i]=new Wedge(temp1[(i+2)%W_COUNT]);
	}
    }


    public void refineQuad() {
	Quad[] temp1=new Quad[5*Q_COUNT];
	int count=0;
	for(int i=0;i<Q_COUNT;++i) {
	    Quad[] temp2=QUAD[i].subdivide();
	    for(int j=0;j<5;++j) {
		temp1[count]=new Quad(temp2[j]);
		++count;
	    }
	}
	Q_COUNT=5*Q_COUNT;
	for(int i=0;i<Q_COUNT;++i) {
	    QUAD[i]=new Quad(temp1[(i+2)%Q_COUNT]);
	}
    }

    public void doRefineWedge() {     
                  MARKER.val=0;
	initializeWedges();
	for(int i=0;i<REFINE.val;++i) refineWedge();
    }

    public void doRefineQuad() {
	initializeQuads();
	for(int i=0;i<REFINE.val;++i) refineQuad();
    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      g.fillRect(0,0,getWidth(),getHeight()); 
      drawControls(g);
      drawSnowflake(g);    
      drawCarpet(g);
      if(ISO.mode==0) highlightSnowflake(g);
      if(ISO.mode==0) highlightCarpet(g);
      if(TEXT.mode==0) DOC.render(g);
      if(TEXT.mode==1) drawMagnifier(g);
   }



    public void drawControls(Graphics2D g) {	
	CONTROL.render(g,new Color(0,0,220));
	START.render(g,500,0,35);
	COLOR.render(g,535,0,65);
	OUTLINE1.render(g,500,65,50);
	OUTLINE2.render(g,550,65,50);
	TEXT.render(g,510,425,80);
	ISO.render(g,500,265,45);

	REFINE.render(g);
	Integer I=new Integer(REFINE.val);
	g.setColor(Color.white);
	g.drawString(I.toString(),580,REFINE.y+10);
	GHOST.render(g);
	BRIGHT.render(g);
	
	if(ISO.mode==0) {
                        MARKER.render(g,new Color(150,0,150),Color.white,Color.white);
                        g.drawString("marker position",510,330);
	}

                 g.setColor(Color.white);
                 g.drawString("refine",510,145);
                 g.drawString("transparency",510,185);
                 g.drawString("brightness",510,225);

    }

    /**i specifies snowflake/carpet, j specifies type color**/

    public Color getColor(int j) {
	if(COLOR.mode==0) return(Color.white);
	int ghost=32*GHOST.val+31;
	int bright=32*BRIGHT.val+31;

	  Color C1=new Color(bright,0,bright,ghost);
	  Color C2=new Color(bright/6,bright/3,bright,ghost);
	  if(j==0) return(C1);
	  return(C2);
    }

    public Color getOutline(int j) {
	if(COLOR.mode==0) return(Color.white);
	int ghost=32*GHOST.val+31;
	int bright=32*BRIGHT.val+31;

	Color C1=new Color(255,255,255,ghost);
	  return(C1);
    }

    public Color getColor2(int j) {

	int ghost=255;
	int bright=255;
	  Color C1=new Color(bright,0,bright,ghost);
	  Color C2=new Color(bright/6,bright/3,bright,ghost);
	  if(j==0) return(C1);
	  return(C2);

    }




    public void drawSnowflake(Graphics2D g) {	
                  //IO temp=new IO("IO/picture_data");
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<W_COUNT;++i) {
	    gp=WEDGE[i].toGeneralPath();
	    gp=transform(gp);     
	    //  if(WEDGE[i].type==0) temp.solidWrite(gp,new Color(200,200,200),Color.black);
	    //  if(WEDGE[i].type==1) temp.solidWrite(gp,new Color(100,100,100),Color.black);	 
	    Color C=getColor(WEDGE[i].type);    
                      g.setColor(C);
	    g.fill(gp);
                     if(OUTLINE1.mode==0) {
	        g.setColor(getOutline(0));
	        g.draw(gp);
	    }

	}
    }


    public void drawCarpet(Graphics2D g) {
	int ghost=32*GHOST.val+31;
	//IO temp=new IO("IO/picture_data");
	 g.setColor(Color.red);
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<Q_COUNT;++i) {
	    gp=QUAD[i].toGeneralPath();
	    gp=transform(gp);     
	    //  if(QUAD[i].type==0) temp.solidWrite(gp,new Color(200,200,200),Color.black);
	    //  if(QUAD[i].type==1) temp.solidWrite(gp,new Color(100,100,100),Color.black);	     
                      Color C=getColor(WEDGE[i].type);
	    g.setColor(C);
	    g.fill(gp);
	    if(OUTLINE2.mode==0) {     
                          g.setColor(getOutline(1));
	        g.draw(gp);
	    }
	}
    }


    public void highlightSnowflake(Graphics2D g) {
	g.setColor(Color.white);
	GeneralPath gp=new GeneralPath();
	int init0=MARKER.val;
	for(int i=init0;i<init0+1;++i) {
	    int j=i%W_COUNT;
	    gp=WEDGE[j].toGeneralPath();
	    gp=transform(gp);     
	    Color C=Color.white;
	    g.fill(gp);
	    g.draw(gp);

	}
    }


    public void highlightCarpet(Graphics2D g) {
	g.setColor(Color.white);
	GeneralPath gp=new GeneralPath();
	int init0=MARKER.val;
	for(int i=init0;i<init0+1;++i) {
	    int j=i%Q_COUNT;
	    gp=QUAD[j].toGeneralPath();
	    gp=transform(gp);     
	    Color C=Color.white;
	    g.fill(gp);
	    g.draw(gp);

	}
    }

    public void setHighlight(Point X) {
	MARKER.max=W_COUNT;
	MARKER.modifyCyclic(X);
    }

    public void getNearestWedge(Point X) {
	int index=-1;
	if(X.x<500) {
	    Complex z=unTransform(X);

	    for(int i=0;i<W_COUNT;++i) {
		if(WEDGE[i].contains(z)==true) index=i;
	    }
	    if(index!=-1) MARKER.val=index;
	    if(index==-1) {
	      double min=100;
	      for(int i=0;i<W_COUNT;++i) {
	           double test=WEDGE[i].dist(z);
		   if(min>test) {
		       min=test;
		       index=i;
		   }
	      }
                         if(index!=-1) MARKER.val=index;
	    }
	}
    }


    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	int test=0;
	if(TEXT.mode==0) {
                       test=DOC.process(e);
                       if(test==1) repaint();
	}
                  if(test==0) doControls(e);
    }

    
    public void doControls(MouseEvent e) {
                 MouseData J=MouseData.process(e);
	int test1=REFINE.process(J.X);	
                  START.switchMode(J.X);
	    int test2=START.isUsed(J.X);
	   if(test1+test2>0) {
	    doRefineWedge();
	    doRefineQuad();
	}

	GHOST.process(J.X);
	BRIGHT.process(J.X);
	setHighlight(J.X);
	TEXT.switchMode(J.X);
	START.switchMode(J.X);
	ISO.switchMode(J.X);
	OUTLINE1.switchMode(J.X);
	OUTLINE2.switchMode(J.X);
	COLOR.switchMode(J.X);
	getNearestWedge(J.X);
	DOC.process(e);
	repaint();
    }



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 


}

