import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**this is a wrapper class for Wedges and Quads**/

public class Poly {
    Complex[] z=new Complex[4];
    int type;
    int count;

    public Poly() {}


    public Poly(Wedge W) {
	for(int i=0;i<3;++i) z[i]=new Complex(W.z[i]);
	type=W.type;
	count=3;
    }

    public Poly(Quad W) {
	for(int i=0;i<4;++i) z[i]=new Complex(W.z[i]);
	type=W.type;
	count=4;
    }

    public Wedge toWedge() {
	Wedge W=new Wedge();
	for(int i=0;i<3;++i) {
	    W.z[i]=this.z[i];
	    W.type=type;
	}
	return(W);
    }


    public Quad toQuad() {
	Quad W=new Quad();
	for(int i=0;i<4;++i) {
	    W.z[i]=this.z[i];
	    W.type=type;
	}	
                  return(W);
    }





    /**This is the complex affine map that carries z1,z2 to w1,w2**/

    public static Complex affineMap(Complex z1,Complex z2,Complex w1,Complex w2, Complex A) {
	Complex[] u=new Complex[10];
	u[0]=Complex.times(A,w1);
	u[1]=Complex.times(A,w2);
	u[2]=Complex.times(w2,z1);
	u[3]=Complex.times(w1,z2);
	u[4]=Complex.minus(z1,z2);
	u[5]=Complex.minus(u[0],u[1]);
	u[6]=Complex.minus(u[2],u[3]);
	u[7]=Complex.plus(u[5],u[6]);
	u[8]=Complex.divide(u[7],u[4]);
	return(u[8]);
    }



    public static Poly affineMap(Poly Z,Poly W,Poly A) {
	Complex z1=new Complex(Z.z[0]);
	Complex z2=new Complex(Z.z[1]);
	Complex w1=new Complex(W.z[0]);
	Complex w2=new Complex(W.z[1]);

	Poly B=new Poly();
	for(int i=0;i<A.count;++i) B.z[i]=affineMap(z1,z2,w1,w2,A.z[i]);
	B.type=A.type;
	return(B);
    }


    /**anti-holomorphic map that fixes z1 and z2**/

    public static Complex anti(Complex z1,Complex z2,Complex u) {
	Complex w1=z1.conjugate();
	Complex w2=z2.conjugate();
	Complex w3=affineMap(z1,z2,w1,w2,u);
	return(w3.conjugate());
    }

    /**antiholomorphic map that sends z1,z2 to w1,w2*/

    public static Complex antiAffineMap(Complex z1,Complex z2,Complex w1,Complex w2,Complex A) {
	Complex B=A.conjugate();
	Complex zz1=z1.conjugate();
	Complex zz2=z2.conjugate();
	Complex C=affineMap(zz1,zz2,w1,w2,B);
	return(C);
    }



    public static Poly antiAffineMap(Poly Z,Poly W,Poly A) {
	Complex z1=new Complex(Z.z[0]);
	Complex z2=new Complex(Z.z[1]);
	Complex w1=new Complex(W.z[0]);
	Complex w2=new Complex(W.z[1]);

	Poly B=new Poly();
	for(int i=0;i<A.count;++i) B.z[i]=antiAffineMap(z1,z2,w1,w2,A.z[i]);
	B.type=A.type;
	return(B);
    }


    public static Poly finalMap(Poly Z,Poly W,Poly A) {
	int test=Complex.isPositivelyOriented(W.z[0],W.z[1],W.z[2]);
	if(test==1) return(affineMap(Z,W,A));
	return(antiAffineMap(Z,W,A));
    }

    public static Wedge finalMap(Wedge Z,Wedge W,Wedge A) {
	Poly ZZ=new Poly(Z);
	Poly WW=new Poly(W);
	Poly AA=new Poly(A);
	Poly X=finalMap(ZZ,WW,AA);
	return(X.toWedge());
    }

    public static Quad finalMap(Quad Z,Quad W,Quad A) {
	Poly ZZ=new Poly(Z);
	Poly WW=new Poly(W);
	Poly AA=new Poly(A);
	Poly X=finalMap(ZZ,WW,AA);
	return(X.toQuad());
    }


    public static Wedge finalMap(Quad Z,Quad W,Wedge A) {
	Poly ZZ=new Poly(Z);
	Poly WW=new Poly(W);
	Poly AA=new Poly(A);
	Poly X=finalMap(ZZ,WW,AA);
	return(X.toWedge());
    }


    public static Quad getSquare(Poly[] X,int count) {
	double x1,y1,x2,y2;
	x2=-100;
	y2=-100;
	x1=100;
	y1=100;
	for(int i=0;i<count;++i) {
	    for(int j=0;j<X[i].count;++j) {
		if(x1>X[i].z[j].x) x1=X[i].z[j].x;
		if(x2<X[i].z[j].x) x2=X[i].z[j].x;
		if(y1>X[i].z[j].y) y1=X[i].z[j].y;
		if(y2<X[i].z[j].y) y2=X[i].z[j].y;
	    }
	}

	double x3=(x1+x2)/2;
	double y3=(y1+y2)/2;
	double x4=x3-x1;
	double y4=y3-y1;
	double r=Math.max(x4,y4);
	x1=x3-r;
	x2=x3+r;
	y1=y3-r;
	y2=y3+r;
	    Quad P=new Quad();
	    P.z[0]=new Complex(x1,y1);
	    P.z[3]=new Complex(x1,y2);
	    P.z[2]=new Complex(x2,y2);
	    P.z[1]=new Complex(x2,y1);
	    return(P);
    }



    public static Quad getSquare(Wedge[] X,int count) {
	Poly[] XX=new Poly[X.length];
	for(int i=0;i<X.length;++i) {
	    XX[i]=new Poly(X[i]);
	}   
                   return(getSquare(XX,count));
    }



    public static Quad getSquare(Quad[] X,int count) {
	Poly[] XX=new Poly[X.length];
	for(int i=0;i<X.length;++i) {
	    XX[i]=new Poly(X[i]);
	}   
                   return(getSquare(XX,count));
    }





}

