import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Quad {
    Complex[] z=new Complex[4];
    int type;

    public Quad() {}


    public Quad(Complex[] a) {
	for(int i=0;i<4;++i) z[i]=new Complex(a[i]);
    }
    public Quad(Complex b,Complex c,Complex d,Complex e) {
	Complex[] a={b,c,d,e};
	for(int i=0;i<4;++i) z[i]=new Complex(a[i]);
    }

    public Quad(Quad S) {	
                  for(int i=0;i<4;++i) z[i]=new Complex(S.z[i]);	
	type=S.type;
    }

    public void print() {
	System.out.println("----quad----");
	for(int i=0;i<4;++i) z[i].print();
	System.out.println("--------------");
    }


    public Quad translate(Complex w) {	
	Quad S=new Quad();
	for(int i=0;i<4;++i)  S.z[i]=Complex.plus(z[i],w);	
	S.type=type;
	return(S);
    }
    public Quad scale(Complex w) {
	Quad S=new Quad();
	for(int i=0;i<4;++i)  S.z[i]=Complex.times(z[i],w);	
                  S.type=type;
	return(S);
    }

    public Quad conjugate() {
	Quad Q=new Quad();
	for(int i=0;i<4;++i) 
	    Q.z[i]=z[i].conjugate();
	Q.type=this.type;
	return(Q);
    }

    public Quad reverse() {
	Quad S=new Quad();
	S.z[1]=new Complex(z[0]);
	S.z[0]=new Complex(z[1]);
	S.z[3]=new Complex(z[2]);
	S.z[2]=new Complex(z[3]);
                  S.type=type;
	return(S);
    }

    public static Quad smallSquare() {
	Complex[] w=new Complex[4];
	w[0]=new Complex(0,0);
	w[1]=new Complex(1,0);
	w[2]=new Complex(1,1);
	w[3]=new Complex(0,1);
	Complex u=new Complex(1,0);
	Complex v=new Complex(-.5,-.377);
	for(int i=0;i<4;++i) {
	    w[i]=Complex.times(u,w[i]);
	    w[i]=Complex.plus(v,w[i]);
	}
	Quad X=new Quad(w);
	return(X);
    }

    public GeneralPath toGeneralPath(int k) {
	if(k==0) return(toGeneralPath0());
	return(toGeneralPath1());
    }


    public GeneralPath toGeneralPath1() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	gp.lineTo((float)(z[1].x),(float)(z[1].y));
	gp.lineTo((float)(z[2].x),(float)(z[2].y));
	gp.lineTo((float)(z[3].x),(float)(z[3].y));
	gp.closePath();
	return(gp);
    }
    public GeneralPath toGeneralPath0() {
	GeneralPath gp=new GeneralPath();
	Complex w1=Complex.average(z[0],z[3]);
	Complex w2=Complex.average(z[1],z[2]);
	gp.moveTo((float)(w1.x),(float)(w1.y));
	gp.lineTo((float)(w2.x),(float)(w2.y));
	gp.closePath();
	return(gp);
    }

    public static Quad initialQuad(int k) {
	Complex z=new Complex(0,1);
	Quad B=initialQuad();
	for(int i=0;i<k;++i) B=B.scale(z);
	B.type=0;
	return(B);
    }

    public static Quad initialQuad() {
	Quad B=new Quad();
	B.z[0]=new Complex(-9,-9);
	B.z[1]=new Complex(9,-9);
	B.z[2]=new Complex(3,-3);
	B.z[3]=new Complex(-3,-3);
	B.type=0;
	return(B);
    }

    public static Quad secondQuad() {
	Quad B=new Quad();
	B.z[0]=new Complex(-9,-9);
	B.z[1]=new Complex(-3,-9);
	B.z[2]=new Complex(3,-3);
	B.z[3]=new Complex(-3,-3);
	B.type=1;
	return(B);
    }



    public Quad[] subdivide() {
	Quad[] C=new Quad[5];
	    for(int i=0;i<5;++i) C[i]=this.subdivideChoice(i);
	return(C);
    }

    public Quad subdivideChoice(int k) {
	if(type==0) return(subdivide0(k));
	return(subdivide1(k));
    }

    public Quad subdivide0(int k) {
	Quad Z=initialQuad();
	Quad W=new Quad(this);
	Quad A=specialQuad(k);
	Quad B=Poly.finalMap(Z,W,A);
	B.type=this.type;
	if(k==0) B.type=1-this.type;
	if(k==4) B.type=1-this.type;
	return(B);
    }

    public Quad subdivide1(int k) {
	Quad Z=secondQuad();
	Quad W=new Quad(this);
	Quad A=specialQuad(k+5);
	Quad B=Poly.finalMap(Z,W,A);	
	B.type=this.type;
	if(k==0) B.type=1-this.type;
	if(k==4) B.type=1-this.type;
	return(B);
    }





    public static Quad specialQuad(int k) {
	if(k==0) return(specialQuad0());
	if(k==1) return(specialQuad1());
	if(k==2) return(specialQuad2());
	if(k==3) return(specialQuad3());
	if(k==4) return(specialQuad4());
	if(k==5) return(specialQuad5());
	if(k==6) return(specialQuad6());
	if(k==7) return(specialQuad7());
	if(k==8) return(specialQuad8());
	if(k==9) return(specialQuad9());
	return(null);
    }

    public static Quad specialQuad0() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-9,-9);
	Q.z[1]=new Complex(-3,-9);
	Q.z[2]=new Complex(3,-3);
	Q.z[3]=new Complex(-3,-3);
	return(Q);
    }

    public static Quad specialQuad1() {
	Quad Q=new Quad();
	Q.z[1]=new Complex(3,-9);
	Q.z[0]=new Complex(3,-3);
	Q.z[3]=new Complex(1,-5);
	Q.z[2]=new Complex(1,-7);
	return(Q);
    }

    public static Quad specialQuad2() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(3,-9);
	Q.z[1]=new Complex(-3,-9);
	Q.z[2]=new Complex(-1,-7);
	Q.z[3]=new Complex(1,-7);
	return(Q);
    }

    public static Quad specialQuad3() {
	Quad Q=new Quad();
	Q.z[1]=new Complex(-3,-3);
	Q.z[0]=new Complex(-3,-9);
	Q.z[3]=new Complex(-1,-7);
	Q.z[2]=new Complex(-1,-5);
	return(Q);
    }


    public static Quad specialQuad4() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-3,-3);
	Q.z[1]=new Complex(3,-3);
	Q.z[2]=new Complex(9,-9);
	Q.z[3]=new Complex(3,-9);
	return(Q);
    }

    public static Quad specialQuad5() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-9,-9);
	Q.z[1]=new Complex(-3,-9);
	Q.z[2]=new Complex(-5,-7);
	Q.z[3]=new Complex(-7,-7);
	return(Q);
    }


    public static Quad specialQuad6() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-3,-9);
	Q.z[1]=new Complex(-3,-7);
	Q.z[2]=new Complex(-5,-5);
	Q.z[3]=new Complex(-5,-7);
	return(Q);
    }


    public static Quad specialQuad7() {
	Quad Q=new Quad();
	Q.z[2]=new Complex(-1,-7);
	Q.z[3]=new Complex(-3,-7);
	Q.z[0]=new Complex(-5,-5);
	Q.z[1]=new Complex(-3,-5);
	return(Q);
    }

    public static Quad specialQuad8() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-1,-7);
	Q.z[1]=new Complex(-1,-5);
	Q.z[2]=new Complex(-3,-3);
	Q.z[3]=new Complex(-3,-5);
	return(Q);
    }


    public static Quad specialQuad9() {
	Quad Q=new Quad();
	Q.z[0]=new Complex(-3,-3);
	Q.z[1]=new Complex(3,-3);
	Q.z[2]=new Complex(1,-5);
	Q.z[3]=new Complex(-1,-5);
	return(Q);
    }




}

