import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Segment {
    Complex[] z=new Complex[2];

    public Segment() {}

    public Segment(Complex a,Complex b) {
	z[0]=new Complex(a);
	z[1]=new Complex(b);
    }

    public Segment(Complex[] a) {
	z[0]=new Complex(a[0]);
	z[1]=new Complex(a[1]);
    }
    public Segment(Segment S) {
	z[0]=new Complex(S.z[0]);
	z[1]=new Complex(S.z[1]);
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	gp.lineTo((float)(z[1].x),(float)(z[1].y));
	return(gp);
    }

    public Segment translate(Complex w) {
	Segment S=new Segment();
	S.z[0]=Complex.plus(z[0],w);
	S.z[1]=Complex.plus(z[1],w);
	return(S);
    }

    public Segment scale(Complex w) {
	Segment S=new Segment();
	S.z[0]=Complex.times(z[0],w);
	S.z[1]=Complex.times(z[1],w);
	return(S);
    }

    public Segment unScale(Complex w) {
	Segment S=new Segment();
	S.z[0]=Complex.divide(z[0],w);
	S.z[1]=Complex.divide(z[1],w);
	return(S);
    }

    public Segment rotate1(Complex u) {
	Complex w=Complex.minus(z[1],z[0]);
	w=Complex.times(w,u);
	Segment S=new Segment();
	S.z[0]=new Complex(z[0]);
	S.z[1]=Complex.plus(S.z[0],w);
	return(S);
    }

    public Segment[] sub() {
	Segment T=new Segment(this);
	Complex w=Complex.minus(T.z[1],T.z[0]);
	T=T.unScale(w);
	Segment[] X=T.hSub();
	for(int i=0;i<5;++i) {
	    X[i]=X[i].scale(w);
	}
	return(X);
    }


    public Segment[] hSub() {
	Segment[] S=new Segment[5];
	S[0]=sub0();
	S[1]=sub1();
	S[2]=sub2();
	S[3]=sub3();
	S[4]=sub4();
	return(S);
    }


    public Segment sub0() {
	Complex s=new Complex(Math.sqrt(2)-1,0);
	Segment S=new Segment();
	S.z[1]=new Complex(z[0]);
	Complex w1=Complex.minus(z[1],z[0]);
	S.z[0]=Complex.plus(z[0],Complex.times(w1,s));
	return(S);
    }

    public Segment sub1() {	
	double x=Math.sqrt(2)-1;
	Complex s=new Complex(x*x,0);
	Segment S=new Segment();
	S.z[0]=new Complex(z[0]);
	Complex w1=Complex.minus(z[1],z[0]);
	S.z[1]=Complex.plus(z[0],Complex.times(w1,s));
	double x2=3-2*Math.sqrt(2);
	S=S.translate(new Complex(x,-x*x));
	S=S.rotate1(new Complex(0,1));
	S=new Segment(S.z[1],S.z[0]);
	return(S);
    }

    public Segment sub2() {	
	double x=Math.sqrt(2)-1;
	Complex s=new Complex(x*x,0);
	Segment S=new Segment();
	S.z[0]=new Complex(z[0]);
	Complex w1=Complex.minus(z[1],z[0]);
	S.z[1]=Complex.plus(z[0],Complex.times(w1,s));
	double x2=3-2*Math.sqrt(2);
	S=S.translate(new Complex(x,-x*x));
	return(S);
    }


    public Segment sub3() {	
	double x=Math.sqrt(2)-1;
	Complex s=new Complex(x*x,0);
	Segment S=new Segment();
	S.z[0]=new Complex(z[0]);
	Complex w1=Complex.minus(z[1],z[0]);
	S.z[1]=Complex.plus(z[0],Complex.times(w1,s));
	double x2=3-2*Math.sqrt(2);
	S=S.translate(new Complex(x,-x*x));
	S=S.rotate1(new Complex(0,1));
	S=S.translate(new Complex(x*x,0));
	return(S);
    }



    public Segment sub4() {
	Complex s=new Complex(Math.sqrt(2)-1,0);
	Segment S=new Segment();
	S.z[1]=new Complex(z[0]);
	Complex w1=Complex.minus(z[1],z[0]);
	S.z[0]=Complex.plus(z[0],Complex.times(w1,s));
	S=S.translate(new Complex(2-Math.sqrt(2),0));
	return(S);
    }


}

