import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Wedge {
    Complex[] z=new Complex[3];
    int type;

    public Wedge() {}


    public Wedge(Complex[] a) {
	for(int i=0;i<3;++i) z[i]=new Complex(a[i]);
    }
    public Wedge(Complex b,Complex c,Complex d) {
	Complex[] a={b,c,d};
	for(int i=0;i<3;++i) z[i]=new Complex(a[i]);
    }

    public Wedge(Wedge S) {	
                  for(int i=0;i<3;++i) z[i]=new Complex(S.z[i]);	
	type=S.type;
    }

    public void print() {
	System.out.println("----wedge----");
	for(int i=0;i<3;++i) z[i].print();
	System.out.println("--------------");
    }


    public Wedge translate(Complex w) {	
	Wedge S=new Wedge();
	for(int i=0;i<3;++i)  S.z[i]=Complex.plus(z[i],w);	
	S.type=type;
	return(S);
    }
    public Wedge scale(Complex w) {
	Wedge S=new Wedge();
	for(int i=0;i<3;++i)  S.z[i]=Complex.times(z[i],w);	
                  S.type=type;
	return(S);
    }

    public Complex getCenter() {
	Complex w=new Complex();
	for(int i=0;i<3;++i) {
	    w=Complex.plus(w,z[i]);
	}
	w=Complex.times(w,new Complex(1.0/3,0));
	return(w);
    }

    public double dist(Complex z) {
	Complex w=getCenter();
	return(Complex.dist(z,w));
    }

    public boolean contains(Complex w) {
	GeneralPath gp=this.toGeneralPath(0);
	return(gp.contains(w.x,w.y));
    }


    public GeneralPath toGeneralPath(int k) {
	if(k==0) return(toGeneralPath0());
	return(toGeneralPath1());
    }



    public GeneralPath toGeneralPath1() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	gp.lineTo((float)(z[1].x),(float)(z[1].y));
	gp.lineTo((float)(z[2].x),(float)(z[2].y));
	gp.closePath();
	return(gp);
    }

    public GeneralPath toGeneralPath0() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	gp.lineTo((float)(z[1].x),(float)(z[1].y));
	gp.closePath();
	return(gp);
    }






    public static Wedge initialWedge(int k) {
	double t=Math.sqrt(2)/2;
	Complex z=new Complex(t,t);
	Wedge B=initialWedge();
	for(int i=0;i<k;++i) B=B.scale(z);
	B.type=0;
	return(B);
    }

    public static Wedge initialWedge() {
	Wedge B=new Wedge();
	double s=1-Math.sqrt(2)/2;
	double t=Math.sqrt(2)/2;
	B.z[0]=new Complex(t,s);
	B.z[1]=new Complex(t,-s);
	B.z[2]=new Complex(1,0);
	return(B);
    }

    public static Wedge referenceWedge() {
	Wedge B=new Wedge();
	B.z[0]=new Complex(0,0);
	B.z[1]=new Complex(2,0);
	B.z[2]=new Complex(1,1);
	return(B);
    }


    public Wedge[] subdivide() {
	Wedge[] C=new Wedge[5];
	for(int i=0;i<5;++i) C[4-i]=this.subdivideChoice(i);
	return(C);
    }

    public Wedge subdivideChoice(int k) {
	Wedge Z=referenceWedge();
	Wedge W=new Wedge(this);
	Wedge A=specialWedge(k);
	Wedge B=Poly.finalMap(Z,W,A);
	B.type=this.type;
	if(k==0) B.type=1-this.type;
	if(k==4) B.type=1-this.type;
	return(B);
    }


    public static Wedge specialWedge(int k) {
	if(k==0) return(specialWedge0());
	if(k==1) return(specialWedge1());
	if(k==2) return(specialWedge2());
	if(k==3) return(specialWedge3());
	if(k==4) return(specialWedge4());
	return(null);
    }

    public static Wedge specialWedge0() {
	double s=2-Math.sqrt(2);
	Wedge B=new Wedge();	
	B.z[0]=new Complex(0,0);
	B.z[1]=new Complex(s,s);
	B.z[2]=new Complex(s,0);
	return(B);
    }

    public static Wedge specialWedge1() {
	double s=2-Math.sqrt(2);
	double t=2*Math.sqrt(2)-2;
	Wedge B=new Wedge();	
                  B.z[0]=new Complex(s,s);
	B.z[1]=new Complex(t,t);
	B.z[2]=new Complex(s,t);
	return(B);
    }


    public static Wedge specialWedge2() {
	double s=2-Math.sqrt(2);
	double t=2*Math.sqrt(2)-2;
	Wedge B=new Wedge();
	B.z[0]=new Complex(t,t);
	B.z[1]=new Complex(2-t,t);
	B.z[2]=new Complex(1,1);
	return(B);
    }

    public static Wedge specialWedge3() {
	double s=2-Math.sqrt(2);
	double t=2*Math.sqrt(2)-2;
	Wedge B=new Wedge();
	B.z[0]=new Complex(2-t,t);
	B.z[1]=new Complex(2-s,s);
	B.z[2]=new Complex(2-s,t);
	return(B);
    }

    public static Wedge specialWedge4() {
	double s=2-Math.sqrt(2);
	Wedge B=new Wedge();
	B.z[0]=new Complex(2-s,s);	
                  B.z[1]=new Complex(2-0,0);
	B.z[2]=new Complex(2-s,0);
	return(B);
    }




}

