import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class Hexagon {
    Complex[] z=new Complex[10];
    Complex center;
    int count;
    int[] address=new int[2];
    int state;
    Color C;


    public Hexagon() {}


    public Hexagon(Hexagon Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.z[i]=Q.z[i];
	state=0;
    }

    public static Hexagon basic() {
	Hexagon P=new Hexagon();
	P.count=6;
	for(int i=0;i<6;++i) {
	    double t=Math.PI*i/3.0;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    P.z[i]=new Complex(c,s);
	}
	return(P);
    }


    public void print() {
	System.out.println("Hexagon");
	for(int i=0;i<count;++i) z[i].print();
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	for(int i=0;i<count;++i) {
	    gp.lineTo((float)(z[i].x),(float)(z[i].y));
	}
	gp.closePath();
	return(gp);
    }


    public Complex getCenter() {
	double x=0;
	double y=0;
	for(int i=0;i<count;++i) {
	    x=x+z[i].x/count;
	    y=y+z[i].y/count;
	}
	return(new Complex(x,y));
    }

    public Hexagon translate(Complex Z) {
	Hexagon Q=new Hexagon();
	Q.count=count;
	for(int i=0;i<count;++i) Q.z[i]=Complex.plus(z[i],Z);
	return(Q);
    }


    public Hexagon shrink(double d) {
	Hexagon P=new Hexagon();
	P.count=count;
	Complex Z=getCenter();
	for(int i=0;i<count;++i) {
	    P.z[i]=new Complex(d*Z.x+(1-d)*z[i].x,d*Z.y+(1-d)*z[i].y);
	}
	return(P);
    }




}

