import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    int TYPE;
    Hexagon[] HEX=new Hexagon[20000];
    int COUNT=0;
    int COUNT1;
    SelectInteger NUM;
    ListenSquare CONTROLS;
    SelectColor CS;

    /**This works with a linked list of hexagons.  Each hexagon is linked
       to its neghbords.  There are 2 kinds of hexagons - the faces and the
       (fat) edges.  The links are between faces and edges.**/

     public PictureCanvas(int type) {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(300,50);
	 TYPE=type;	
	 CONTROLS=new ListenSquare(0,0,800,50,null);CONTROLS.on=1;
	 NUM=new SelectInteger(520,15,40,20,5,5,50,1);
	 setHex();
	 CS=new SelectColor(0,0,500,50);
     }


    public void setHex() {
	COUNT=0;
	Hexagon B0=Hexagon.basic();
	setHex(B0);
    }


    /**Basis for the triangular lattice*/

    public Complex[] latticeBasis() {
	double c=Math.cos(Math.PI/3);
	double s=Math.sin(Math.PI/3);
	Complex z1=new Complex(c+1,s);
	Complex z2=new Complex(c+1,-s);
	Complex[] Z={z1,z2};
	return(Z);
    }

    /**size of the hexagon array*/


    /**The hexagons are drawn in a spiral pattern,
       so that each list (depending on val) includes
       in a larger list of hexagons.**/


    public void setHex(Hexagon H) {
	int t=NUM.val;
	Complex[] Z=latticeBasis();
	for(int i=0;i<t;++i) {
	    for(int j=0;j<t;++j) {
	     if(i+j<t) {
	      Complex w1=Complex.times(Z[0],new Complex(i,0));
	      Complex w2=Complex.times(Z[1],new Complex(j,0));
	      Complex w=Complex.plus(w1,w2);
	        HEX[COUNT]=H.translate(w);
	        HEX[COUNT].state=0;
		HEX[COUNT].address[0]=i;
		HEX[COUNT].address[1]=j;
		HEX[COUNT].C=Color.black;
	        ++COUNT;
	     }
	    }
	}
    }



    /**gets the bounding box of the last graph drawn**/

    public void getPathBox() {

	 Complex[] Z=latticeBasis();
	 int t=NUM.val;
	 Complex w1=new Complex(t*Z[0].x,t*Z[0].y);
	 Complex w2=new Complex(t*Z[1].x,t*Z[1].y);
	 GeneralPath gp=new GeneralPath();
	 gp.moveTo(0,0);
	 gp.lineTo((float)(w1.x),(float)(w1.y));
	 gp.lineTo((float)(w2.x),(float)(w2.y));
	 gp.closePath();

	 Rectangle2D R=gp.getBounds2D();
	 Rectangle2D.Float RR=(Rectangle.Float)(R);

	 int hh=getHeight();
	 int ww=getWidth();

	 double x1=(ww-2)/RR.getWidth();
	 double x2=(hh-150)/RR.getHeight();
	 double sc=x1;
	 if(sc>x2) sc=x2;

	 double cenx=RR.x+RR.getWidth()/2;
	 double ceny=RR.y+RR.getHeight()/2;

	 A[0]=AffineTransform.getTranslateInstance(-cenx*sc+.5*ww,ceny*sc+.5*hh);
	 A[1]=AffineTransform.getScaleInstance(sc,-sc);
    }





   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);  
      getPathBox();
      drawHex(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(50,60,70));
	g.fillRect(0,0,getWidth(),getHeight());
    }


    public void drawControls(Graphics2D g) {
	CONTROLS.render(g,new Color(0,0,0));
	NUM.render(g,Color.blue,Color.white,Color.white);
	CS.render(g);
    }


    public void drawHex(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<COUNT;++i) {
	      gp=HEX[i].toGeneralPath();
	      gp=transform(gp);
	      g.setColor(HEX[i].C);
	      g.fill(gp);
	      g.setColor(Color.white);
	      g.draw(gp);
	}
    }

    public void toggle(Color C) {
 	GeneralPath gp=new GeneralPath();
	for(int i=0;i<COUNT;++i) {
          gp=HEX[i].toGeneralPath();
	  if(gp.contains(SOURCE.x,SOURCE.y)==true) {
	      HEX[i].C=C;
	  }
	}
    }

    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROLS.inside(J.X)==0) {
             SOURCE=unTransform(J.X);
	     toggle(CS.C);
	}
	else {
	    NUM.modify(J.X);
	    if(NUM.isModified(J.X)==1) setHex();
	    CS.process(e);
	}
	repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROLS.inside(J.X)==0) {
             SOURCE=unTransform(J.X);
	     toggle(CS.C);
	     repaint();
	}


     }


}

