import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener,MouseListener,MouseMotionListener {
    Manager M;
    Parameter PAR;
    ControlPanelColor MODEL;
    ControlPanel SCALE;
    ColorSelector CS;
    ListenSquare EXPORT;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 PAR=new Parameter(120,0,"2/9");
	 CS=new ColorSelector(0,153,330,50);
	 ControlPanelSetup.setPanels(this);
	 EXPORT=new ListenSquare(130,130,40,20);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,0,100));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawControls(Graphics2D g) { 
	PAR.render(g);
        CS.render(g);   
        MODEL.render(g,0,0,115);
        SCALE.render(g,0,100,115);
	EXPORT.render(g,Color.red);
    }	

    public void doPanels(Point X) {
	MODEL.process(X,M.color());
	SCALE.switchMode(X);
    }

    public void doExport() {
	ExportRoutines.main(this.M);
    }

    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e); 
        PAR.process(e,M);
	doPanels(J.X);
	CS.process(e);
	if(EXPORT.inside(J.X)==1) doExport();
	M.repaint();
    }


    public void mousePressed(MouseEvent e) {
    }
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);  
	M.repaint();

     }


    public void keyTyped(KeyEvent e) {
        PAR.processKey(e);
   	M.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

