import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ExportRoutines {

    public static void main(Manager M) {
	main1(M);
	main2(M);
    }

    public static void main1(Manager M) {  
	int p0=M.p();
	int q0=M.q();
	int[] a=MathRational.predecessor(p0,q0);
	int c=MathRational.classify(p0,q0);
	int p1=a[0];
	int q1=a[1];
	boolean shrink=false;
	boolean shift=false;
	if(c==2) shift=true;
	if(c==0) shrink=true;

	int p=M.p();
	int q=M.q();
        Output OUT1=new Output("Output/plaid1");
	Integer P=new Integer(p);
	Integer Q=new Integer(q);
	OUT1.writeln("set P "+P.toString());
	OUT1.writeln("set Q "+Q.toString());
	drawCopy(OUT1,true,false,p0,q0,p0,q0,Color.white);
	drawCopy(OUT1,shrink,shift,p1,q1,p0,q0,new Color(220,220,220));
	drawTiles(OUT1,p,q);
	drawFirstPlaid(OUT1,p,q);
	drawCopy(OUT1,true,false,p0,q0,p0,q0);
	drawCopy(OUT1,shrink,shift,p1,q1,p0,q0);
	drawCap2(OUT1,p,q);
    }

    public static void main2(Manager M) {   

	int p0=M.p();
	int q0=M.q();
	int[] a=MathRational.predecessor(p0,q0);
	int c=MathRational.classify(p0,q0);
	int p1=a[0];
	int q1=a[1];
	boolean shrink=false;
	boolean shift=false;
	if(c==2) shift=true;
	if(c==0) shrink=true;

	Integer P=new Integer(p1);
	Integer Q=new Integer(q1);
        Output OUT2=new Output("Output/plaid2");
	OUT2.writeln("set P "+P.toString());
	OUT2.writeln("set Q "+Q.toString());

	drawCopy(OUT2,shrink,false,p1,q1,p0,q0,new Color(220,220,220));
	drawTiles(OUT2,a[0],a[1]);
	drawFirstPlaid(OUT2,a[0],a[1]);
	drawCopy(OUT2,shrink,false,p1,q1,p0,q0);
	drawCap2(OUT2,a[0],a[1]);
    }


    public static void drawTiles(Output OUT,int p,int q) {
	int k=p+q;
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();

	for(int i=0;i<k;++i) {
	    for(int j=0;j<k;++j) {
		T=new Tile(p,q,i,j);
  	        T.type();
   	        gp=T.getSquare();
		OUT.lineWrite0(gp,new Color(180,180,180));
	    }
	}

    }

    public static void drawModel(Output OUT,int p,int q) {
	int k=p+q;
	Tile T=new Tile();

	for(int i=0;i<k;++i) {
	    for(int j=0;j<k;++j) {
		T=new Tile(p,q,i,j);
		T.type();
		if(T.type!=0) {
		    int c1=T.TYPE[0];
		    int c2=T.TYPE[1];
	            Complex Z0=new Complex(i+.5,j+ 0);
	            Complex Z1=new Complex(i +0,j+.5);
	            Complex Z2=new Complex(i+.5,j+ 1);
	            Complex Z3=new Complex(i+ 1,j+.5);
	            Complex[] Z={Z0,Z1,Z2,Z3};
		    OUT.segmentWrite(Z[c1].x,Z[c1].y,Z[c2].x,Z[c2].y,new Color(100,100,100));
		}
	    }
	}
    }

    public static void drawFirstPlaid(Output OUT,int p,int q) {
	int t=MathRational.tune(p,q,1);
	Tile T=new Tile(p,q,0,t);
	Path2D.Double gp=TileTracer.plaidPolygon(T);
	OUT.lineWrite0(gp,Color.black);
    }




    public static void drawCopy(Output OUT,boolean s0,boolean s1,int p,int q,int pp,int qq,Color C) {
        Path2D.Double gp=PictureCanvas.copyBox(s0,s1,p,q,pp,qq);
	OUT.polyWrite(gp,C,Color.black);
    }


    public static void drawCopy(Output OUT,boolean s0,boolean s1,int p,int q,int pp,int qq) {
         Path2D.Double gp=PictureCanvas.copyBox(s0,s1,p,q,pp,qq);
	 OUT.lineWrite0(gp,new Color(80,80,80));
    }


    public static void drawCap2(Output OUT,int p,int q) {
	for(int i=0;i<2;++i) {
          Path2D.Double gp=cap2Lines(i,p,q);
	  OUT.lineWrite0(gp,new Color(50,50,50));
	}
    }

    public static Path2D.Double cap2Lines(int choice,int p,int q) {
      int t=MathRational.tune(p,q);
      Path2D.Double gp=new Path2D.Double();
      if(choice==0) {
        gp.moveTo(0,t);
        gp.lineTo(p+q,t);
      }
      if(choice==1) {
        gp.moveTo(0,p+q-t);
        gp.lineTo(p+q,p+q-t);
      }
      return gp;
    }



}








