import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GraphicsHelp {

    /**This routine causes the scaling to change so as to fit the selected
       object to the screen*/

    public static AffineTransform[] preFit(Path2D.Double gp,double x,double y,double w,double h) {
	AffineTransform[] AFF=new AffineTransform[2];
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Double R1=(Rectangle2D.Double)(R0);
	double[] t={R1.x,R1.y,R1.x+R1.getWidth(),R1.y+R1.getHeight()};
	 double x1=1.0*(w)/(t[2]-t[0]);
	 double x2=1.0*(h)/(t[3]-t[1]);
	 double sc=x1;
	 if(sc>x2) sc=x2;	 
         AFF[1]=AffineTransform.getScaleInstance(sc,-sc);
	 double cenx=(t[0]+t[2])/2.0;
	 double ceny=(t[1]+t[3])/2.0;
	 double targetx=x+1.0*w/2;
	 double targety=y+1.0*h/2;
	 double xx=targetx-cenx*sc;
	 double yy=targety+ceny*sc;
	 AFF[0]=AffineTransform.getTranslateInstance(xx,yy);
	 return(AFF);
    }

    public static int[] getLimits(Path2D.Double gp) {
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Double R1=(Rectangle2D.Double)(R0);
	double[] t={R1.x,R1.y,R1.x+R1.getWidth(),R1.y+R1.getHeight()};
	int[] m=new int[4];
	for(int i=0;i<4;++i) m[i]=(int)(t[i]);
	return(m);
    }

    public static Path2D.Double makeSquare(int p,int q,double x0,double x1) {
	Path2D.Double gp=new Path2D.Double();
	double y=1.0/(p+q);
	gp.moveTo(x0-y,x1-y);
	gp.lineTo(x0+y,x1-y);
	gp.lineTo(x0+y,x1+y);
	gp.lineTo(x0-y,x1+y);
	gp.closePath();
	return(gp);
    }


    /**Intersects the segment b0b1 with the
        box whose corners are Z[0] and Z[1]*/

    public static Complex[] trim(Complex b0,Complex b1,Complex[] Z) {

	Complex b2=new Complex(b0.x,b1.y);
	Complex b3=new Complex(b1.x,b0.y);
	Complex z1=Complex.findCross(Z[0],Z[1],b0,b2);
	Complex z2=Complex.findCross(Z[0],Z[1],b1,b3);
	Complex z3=Complex.findCross(Z[0],Z[1],b0,b3);
	Complex z4=Complex.findCross(Z[0],Z[1],b1,b2);
	Complex[] W=new Complex[4];
	int count=0;

	if(Complex.onSegment(z1,b0,b2)==true) {
	    W[count]=new Complex(z1);
	    ++count;
	}
	if(Complex.onSegment(z2,b1,b3)==true) {
	    W[count]=new Complex(z2);
	    ++count;
	}

	if(Complex.onSegment(z3,b0,b3)==true) {
	    W[count]=new Complex(z3);
	    ++count;
	}
	if(Complex.onSegment(z4,b1,b2)==true) {
	    W[count]=new Complex(z4);
	    ++count;
	}
	if(count<2) return(null);
	if(count==2) {
	    Complex[] W2={W[0],W[1]};
	    return(W2);
	}
	if(Complex.dist(W[0],W[1])>.0001) {
	    Complex[] W2={W[0],W[1]};
	    return(W2);
	}
	Complex[] W2={W[0],W[2]};
	return(W2);
    }



    /**Creates a standard arrow pointing along the x axis*/

    public static Complex[] standardArrow(int sign) {
	double t=.5+.03*sign;
	Complex[] Z={new Complex(.5,.015),new Complex(t,0),new Complex(.5,-.015)};
	return Z;
    }

    /**Creates an arrow from the point z01 to the point z02.
       The sign tells whether the arrow points upwards or downwards*/

    public static Complex[] arrow(int sign,Complex z01,Complex z02) {
	Complex[] Z=orderByHeight(z01,z02);
	Complex[] W=standardArrow(sign);
	for(int i=0;i<3;++i) W[i]=Complex.times(W[i],Complex.minus(Z[0],Z[1]));
	for(int i=0;i<3;++i) W[i]=Complex.plus(W[i],Z[0]);
	return W;
    }


    public static Complex[] orderByHeight(Complex z1,Complex z2) {
	Complex[] Z={z1,z2};
	if(z1.y>z2.y) return Z;
	Complex[] W={z2,z1};
	return W;
    }


    public static Complex[][] weedOut(Complex[][] L0) {
	int count=0;
	Complex[][] L1=new Complex[L0.length][2];
	for(int i=0;i<L0.length;++i) {
	    if(onList(L0[i],L1,count)==false) {
		L1[count][0]=new Complex(L0[i][0]);
		L1[count][1]=new Complex(L0[i][1]);
		++count;
	    }
	}
	Complex[][] L2=new Complex[count][2];
	for(int i=0;i<count;++i) {
	    L2[i][0]=new Complex(L1[i][0]);
            L2[i][1]=new Complex(L1[i][1]);
	}
	return(L2);
    }



    public static boolean onList(Complex[] Z,Complex[][] LIST,int count) {
	if(LIST==null) return true;
	if(Z[0]==null) return true;
	if(Z[1]==null) return true;
	for(int i=0;i<count;++i) {
	    boolean test=true;
	    if(Complex.dist(Z[0],LIST[i][0])>.000000001) test=false;
	    if(Complex.dist(Z[1],LIST[i][1])>.000000001) test=false;
	    if(test==true) return true;
	}
	return false;
    }

}