#! /usr/local/bin/wish  -f


set HEIGHT 400
canvas .plot -width 400 -height $HEIGHT 
pack .plot
canvas .post -width 400 -height 20 -bg white
pack .post
set SIZE 380

.post create rectangle 0 0 80 20 -fill blue -tag export
.post create text 220 10 -anchor e -fill white -text $SIZE -tag pixsize
.post create text 10 10 -text "export" -anchor w -fill white -tag export
.post create text 170 10 -text "pix size" -anchor e -fill white -tag export


.post bind export <Any-Button> post
global HEIGHT
source plaid1
.plot create oval 0 0 0 0 -fill black -outline black -tag X -width 5
set W [expr $P+$Q];
.plot scale X 0 0 [expr 1.0/$W] [expr 1.0/$W]
.plot scale X 0 0 390 -390
.plot move X 5 395
.plot itemconfigure X -width 2

.plot create rectangle 0 0 600 $HEIGHT -fill white  -tag bg
.plot create rectangle 0 0 600 [expr $HEIGHT-0] -outline white -tag fg
.plot lower bg
.plot raise fg


proc post {} {
global SIZE HEIGHT
.plot postscript -pageheight $SIZE \
-height $HEIGHT -width 400 \
-file "temp1.ps"
}

######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 51.0/50.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 50.0/51.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}
######################################
