import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Color[] COLOR=new Color[7];
    Output OUT;
    Point JX;
    int CHOICE;

     public PictureCanvas(int choice) {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(0,400,400.0/11);
	 CHOICE=choice;	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
   
      int p=M.p();
      int q=M.q();
      if((p*q)%2==1) return;
      if(p>=q) return;
      if(p<1) return;

      if(M.C.SCALE.mode==1) rescale();

      if(M.C.MODEL.L[1].on==1) {
	  drawTiles(g,0);
      }

      if(M.C.MODEL.L[2].on==1) {
	  drawTiles(g,1);
      }


      if(M.C.MODEL.L[4].on==1) {
	  cap2Lines(g);
      }

      if(M.C.MODEL.L[3].on==1) {
	  copyBox(g);
      }



      if(M.C.MODEL.L[0].on==1) {
	  drawFirst(g);
      }
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,0));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawFirst(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	if(CHOICE==1) {
	    int[] a=MathRational.predecessor(p,q);
	    p=a[0];
	    q=a[1];
	}

	drawFirst(g,p,q);
    }

    public void drawFirst(Graphics2D g,int p,int q) {
	int t=MathRational.tune(p,q);
	drawTracer(g,p,q,0,t,M.C.MODEL.M[0].C);
    }

    public void drawTiles(Graphics2D g,int mode) {
	int p=M.p();
	int q=M.q();

	if(CHOICE==1) {
	    int[] a=MathRational.predecessor(p,q);
	    p=a[0];
	    q=a[1];
	}

	if(p+q>200) return;
	int k=p+q;
	Tile T=new Tile();
	Path2D.Double gp=new Path2D.Double();
	Path2D.Double gp2=new Path2D.Double();

	for(int i=0;i<p+q;++i) {
	    for(int j=0;j<p+q;++j) {
		T=new Tile(p,q,i,j);

		//just the squares
		if(mode==0) {
		  gp=T.getSquare();
		  gp=transform(gp);
		  g.setColor(M.C.MODEL.M[1].C);
		  g.draw(gp);
		}

		//main mode
		if(mode==1) { 
                    T.type();
		    if(T.type!=0) {
		      gp=T.getTileUndirected(0);
		      gp=transform(gp);
		      g.setColor(M.C.MODEL.M[2].C);
		      g.draw(gp);
		    }
		}
	    }
	}
    }

    public void drawTracer(Graphics2D g,int p,int q,int i,int j,Color C) {
	Tile T=new Tile(p,q,i,j);
	Path2D.Double gp=TileTracer.plaidPolygon(T);
	gp=transform(gp);
	g.setColor(C);
	g.setStroke(new BasicStroke(2));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }


    public void cap2Lines(Graphics2D g) {
      int p=M.p();
      int q=M.q();
      if(CHOICE==1) {
        int[] a=MathRational.predecessor(p,q);
        p=a[0];
        q=a[1];
      }
      Path2D.Double gp=cap2Lines(p,q);
      gp=transform(gp);
      g.setColor(M.C.MODEL.M[4].C);
      g.draw(gp);
    }

    public static Path2D.Double cap2Lines(int p,int q) {
      int t=MathRational.tune(p,q);
      Path2D.Double gp=new Path2D.Double();
      gp.moveTo(0,t);
      gp.lineTo(p+q,t);
      gp.moveTo(0,p+q-t);
      gp.lineTo(p+q,p+q-t);
      return gp;
    }

    public void copyBox(Graphics2D g) {
	int p0=M.p();
	int q0=M.q();
	int[] a=MathRational.predecessor(p0,q0);
	int c=MathRational.classify(p0,q0);
	int p1=a[0];
	int q1=a[1];
	boolean shrink=false;
	boolean shift=false;
	if(c==2) shift=true;
	if(c==0) shrink=true;
	if(CHOICE==0) copyBox(g,true,false,p0,q0,p0,q0);
	if(CHOICE==0) copyBox(g,shrink,shift,p1,q1,p0,q0);
	if(CHOICE==1) copyBox(g,shrink,false,p1,q1,p0,q0);
    }

    public void copyBox(Graphics2D g,boolean shrink,boolean shift,int p,int q,int pp,int qq) {
	Path2D.Double gp=copyBox(shrink,shift,p,q,pp,qq);
	gp=transform(gp);
	g.setColor(M.C.MODEL.M[3].C);
	g.draw(gp);
    }

    public static Path2D.Double copyBox(boolean shrink,boolean shift,int p,int q,int pp,int qq) {
	int t1=MathRational.tune(p,q);
	int t2=p+q-2*t1;
	int w=t1;
	if(w>t2) w=t2;
	int h=p+q;
	if(shrink==true) h=h-w;
	int y=0;
	if(shift==true) y=shift(pp,qq);

	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(0,0+y);
	gp.lineTo(0,h+y);
	gp.lineTo(w,h+y);
	gp.lineTo(w,0+y);
	gp.closePath();
	return gp;
    }


    public void rescale() {
       int p=M.p();
       int q=M.q();
	if(CHOICE==1) {
	    int[] a=MathRational.predecessor(p,q);
	    p=a[0];
	    q=a[1];
	}
       int h=getHeight();
       int w=getWidth();
       Path2D.Double gp=new Path2D.Double();
       gp.moveTo(0,0);
       gp.lineTo(0,p+q);
       gp.lineTo(p+q,p+q);
       gp.lineTo(p+q,0);
       A=GraphicsHelp.preFit(gp,2,5,w-4,h-15);
    }

    public static int shift(int p,int q) {
	int[] a=MathRational.predecessor(p,q);
	int y=(p+q-a[0]-a[1])/2;
	return y;
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
     }
  
     public void mouseDragged(MouseEvent e) {
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(test);
	M.repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}





}

