import java.awt.*;
import java.math.*;
import java.awt.geom.*;


public class PlaidClassify {

    /**This gives the true way to compute the oriented plaid tiles.
       However, the routine is fairly slow.  The actual routine we
       use is in the file PlaidClassifyFast.  The two routines 
       agree.*/


    public PlaidClassify() {}


    public static int[] classify(Tile T) {
	Complex Z=new Complex(T.i+.5,T.j+.5);
	double A=1.0*T.p/T.q;
	Vector4 Y=PlaidClassifyingMap.PHI(A,T.i+.5,T.j+.5);
	int[] a=plaidType(Y);
	if(a==null) return null;
	return a;
    }



    public static int[] plaidType(Vector4 W0) {
	int[] a=plaidIndex(W0);
	if(a==null) return null;
	int[] b=DataPlaidPolytopes.type(a[1]);
	int[] c={b[1],b[0]}; 
	if(a[0]==0) return b;
	return c;
    }

    /**This finds the plaid PET partition piece that
       contains the vector*/

    public static int[] plaidIndex(Vector4 W0) {
	double P=W0.x[3];
	for(int lim=1;lim<3;++lim) {
	for(int i=0;i<26;++i) {
        Polytope POLY=AllPolytopes.plaid(i);
	  for(int a1=-lim-1;a1<lim;++a1) {
	    for(int a2=-lim-1;a2<lim;++a2) {
		for(int a3=-1;a3<lim;++a3) {
		    Vector4 W=new Vector4(W0);
		    W.x[0]=W.x[0]+2*a1;
		    W.x[1]=W.x[1]+P*a1+2*a2;
		    W.x[2]=W.x[2]+P*a1+2*a3;
                    if(POLY.contains(W)==true) {
			int[] a={(10+a1)%2,i};
			return a;
		    }
		}
	    }
	  }
	}
	}
	return null;
    }


}

