import java.awt.*;
import java.math.*;


public class PlaidFunctions {

    /**These are the routines for the plaid model and
       for the plaid PET*/

    /**These take the decimal parts*/

    /**range is [0,1]*/

    public static double dec1(double x) {
	return(x-Math.floor(x));
    }

    /**range is [-1,1]*/

    public static double dec2(double x) {
	double y1=x/2.0+1/2.0;
	double y2=dec1(y1);
	double y3=2*y2-1;
	return(y3);
    }

    /**range is [-3,1]*/

    public static double dec4(double x) {
	double y1=x/4.0+1/2.0;
	double y2=dec1(y1);
	double y3=4*y2-2;
	return(y3);
    }


    /**Here P/Q=p/q and P+Q=2*/

    public static double P(int p,int q) {
	return(2.0*p/(p+q));
    }

    public static double Q(int p,int q) {
	return(2.0*q/(p+q));
    }

    /**Coordinates for the plaid model*/
    public static double FV(int p,int q,double x,double y) {
	double P=P(p,q);
	return dec2(2*P*x);
    }

    public static double FH(int p,int q,double x,double y) {
	double P=P(p,q);
	return dec2(2*P*y);
    }

    public static double FP(int p,int q,double x,double y) {
	double P=P(p,q);
	double t2=P*y+P*P*x+1;
	double t3=dec2(t2);
	return t3;
    }

    public static double FQ(int p,int q,double x,double y) {
	double P=P(p,q);
	double Q=Q(p,q);
	double t2=P*y+P*Q*x+1;
	double t3=dec2(t2);
	return t3;
    }


    public static double FPP(int p,int q,double x,double y) {
	double P=P(p,q);
	double t2=P*y-P*P*x+1;
	double t3=dec2(t2);
	return t3;
    }

    public static double FQP(int p,int q,double x,double y) {
	double P=P(p,q);
	double Q=Q(p,q);
	double t2=P*y-P*Q*x+1;
	double t3=dec2(t2);
	return t3;
    }

    /**Computes the capacity of a grid line*/

    public static int capacity(int p,int q,int m) {
	int w=p+q;
	int d=(4*p*m+2*w*w*w)%(2*w);
	if(d>w) d=2*w-d;
	return d;
    }

    /**Computes the capacity of the line containing the point*/

    public static int capacityLine(int p,int q,Complex z) {
	int a=(int)(z.x);
	if(z.wall%2==0) a=(int)(z.y);
	return capacity(p,q,a);
    }


    /**Computes the absolute mass of the particle.  The
       variable sign determines whether we are computing
       relative to negatively slanting lines or positively
       slanting lines*/


    public static double mass(int p,int q,int sign,Complex z) {
	double k=0;
	int t=z.type;
	if((sign==1)&&(z.wall%2==1)) t=3-t;
	if(sign==-1) {
	   if(t==1) k=(p+q)*FP(p,q,z.x,z.y);
	   if(t==2) k=(p+q)*FQ(p,q,z.x,z.y);
	}
	if(sign==+1) {
	   if(t==1) k=(p+q)*FPP(p,q,z.x,z.y);
	   if(t==2) k=(p+q)*FQP(p,q,z.x,z.y);
	}

	k=Math.abs(k);
	return k;
    }



    /**Finds the y-intercept of a point given its type*/

    public static int yInterceptNegative(int p,int q,Complex z1) {
	Complex z2=new Complex();
	double P=P(p,q);
	double Q=Q(p,q);
	if(z1.type==1) z2=Complex.plus(z1,new Complex(1,-P));
	if(z1.type==2) z2=Complex.plus(z1,new Complex(1,-Q));
	double m=(z1.x*z2.y-z1.y*z2.x)/(z1.x-z2.x);
	int m0=(int)(Math.floor(m+.5));
	return m0;
    }

    public static int yInterceptPositive(int p,int q,Complex z1) {
	Complex z2=new Complex();
	double P=P(p,q);
	double Q=Q(p,q);
	int t=z1.type;
	if(z1.wall==1) t=3-t;
	if(z1.wall==3) t=3-t;
	if(t==1) z2=Complex.plus(z1,new Complex(1,P));
	if(t==2) z2=Complex.plus(z1,new Complex(1,Q));
	double m=(z1.x*z2.y-z1.y*z2.x)/(z1.x-z2.x);
	int m0=(int)(Math.floor(m+.5));
	return m0;
    }



}

