import java.awt.*;
import java.math.*;
import java.awt.geom.*;
import java.util.Arrays;

public class PlaidModel {


    /**This is not related to the correct orientation. It
       just directs the edges according to the lexicographic order.*/

    public static int[] typeOrientedCheap(Tile T) {
	int[] TYPE={0,0};
	Complex[] W=getPoints(T);
	int[] t=getCount(T,W);
	int count=0;
	for(int z=0;z<4;++z) {
	    if(t[z]==1) {
                 TYPE[count]=z;
		 if(count<2) ++count;
	    }
	}
	return(TYPE);
    }

    public static int typeUnoriented(Tile T) {
	int type=0;
	Complex[] W=getPoints(T);
	int[] t=getCount(T,W);
	if(t[0]*t[1]==1) type=1;
	if(t[1]*t[2]==1) type=2;
	if(t[2]*t[3]==1) type=3;
	if(t[3]*t[0]==1) type=4;
	if(t[0]*t[2]==1) type=5;
	if(t[1]*t[3]==1) type=6;
	return(type);
    }

    public static int[][] typeRaw(Tile T) {
	int type=0;
	Complex[] W=getPoints(T);
	int[][] t=getCountRaw(T,W);
	return(t);
    }

    public static int[][][] typeRawSigned(Tile T) {
	int type=0;
	Complex[] W=getPoints(T);
	int[][][] t=getCountRawSigned(T,W);
	return(t);
    }


    /**This gets the 8 points on the tile,
       and classifies each one according to
       the following scheme:
       type: 1 for P lines, 2 for Q lines
       wall: 

                        2

                   1         3
   
                        0

    */



    public static Complex[] getPoints(Tile T) {
	Complex[] Z1=getQuad0(T);
	Complex[] Z2=getQuad1(T);
	Complex[] W=new Complex[8];
	for(int k=0;k<4;++k) {
	    W[k+0]=new Complex(Z1[k]);
	    W[k+4]=new Complex(Z2[k]);
	}
	return(W);
    }


    /**THis is only used for the export routines*/

    public static Complex[] getLightPoints(Tile T) {
	Complex[] Z=getPoints(T);
	Complex[] W=new Complex[8];
	int count=0;
	for(int a=0;a<8;++a) {
            int k=Z[a].wall;
	    if(isLight(T.p,T.q,Z[a])==1) {
		W[count]=new Complex(Z[a]);
		++count;
	    }
	}
	Complex[] W2=new Complex[count];
	for(int a=0;a<count;++a) W2[a]=new Complex(W[a]);
	return(W2);
    }







    public static double[] xList(Tile T) {
	double[] d1=xList(T.p,T.q);
	int i0=T.i%(T.p+T.q);
	int i1=T.i-i0;
	double[] d2={i1+d1[2*i0],i1+d1[2*i0+1]};
	return(d2);
    }

    public static int[] xLabels(Tile T) {
	int[] d1=xLabels(T.p,T.q);
	int i0=T.i%(T.p+T.q);
	int[] d2={d1[2*i0],d1[2*i0+1]};
	return(d2);
    }

    public static Complex[] getQuad0(Tile T) {
	int[] n=xLabels(T);
	Complex[] Z=new Complex[0];
	if(n[0]==1) Z=getQuad01(0,T);
	if(n[1]==1) Z=getQuad01(1,T);
	if((n[0]!=1)&&(n[1]!=1)) Z=getQuad02(T);
	for(int i=0;i<Z.length;++i) Z[i].dir=direction(T.p,T.q,-1,Z[i]);
	return Z;
    }


    public static Complex[] getQuad1(Tile T) {
	Complex[] d=getQuad0(T);
	for(int a=0;a<4;++a) {
	    d[a].y=2*T.j+1-d[a].y;
	}
	int[] T1={1,2,2,1};
	int[] T2={2,1,1,2};
	int test=d[0].type;

	if(test==1) {
	    for(int i=0;i<4;++i) d[i].type=T1[i];
	}
	if(test==2) {
	    for(int i=0;i<4;++i) d[i].type=T2[i];
	}
	for(int a=0;a<4;++a) {
	    if(d[a].wall%2==0) d[a].wall=2-d[a].wall;
	}
	for(int i=0;i<d.length;++i) d[i].dir=direction(T.p,T.q,-1,d[i]);
	return(d);
    }


    /**These are the raw generators of the points*/
    public static Complex[] getQuad01(int choice,Tile T) {
	double[] d=xList(T);
	double P=PlaidFunctions.P(T.p,T.q);
	double Q=PlaidFunctions.Q(T.p,T.q);
	Complex[] L=new Complex[4];
	for(int a=0;a<4;++a) L[a]=new Complex();
	L[0].x=d[choice];
	L[0].y=T.j;
	L[1].x=T.i;
	L[1].y=T.j+P*(d[choice]-T.i);
        L[2].x=T.i+(T.j+1-L[1].y)/Q;
	L[2].y=T.j+1;
	L[3].x=T.i+1;
	L[3].y=T.j+P*(T.i+1-d[choice]);
	int[] TYPE={1,1,2,2};
	int[] WALL={0,1,2,3};
	for(int a=0;a<4;++a) {
	    L[a].type=TYPE[a];
	    L[a].wall=WALL[a]; 
	}
	return(L);
    }


    public static Complex[] getQuad02(Tile T) {
	double[] d=xList(T);
	double P=PlaidFunctions.P(T.p,T.q);
	double Q=PlaidFunctions.Q(T.p,T.q);
	Complex[] L=new Complex[4];
	for(int a=0;a<4;++a) L[a]=new Complex();
	L[0].x=d[0];
	L[0].y=T.j;
	L[1].x=T.i;
	L[1].y=T.j+Q*(d[0]-T.i);
        L[2].x=T.i+1;
	L[2].y=T.j+1-Q*(T.i+1-d[1]);
	L[3].x=d[1];
	L[3].y=T.j+1;
	int[] TYPE={2,2,2,2};
	int[] WALL={0,1,3,2};
	for(int a=0;a<4;++a) {
	    L[a].type=TYPE[a];
	    L[a].wall=WALL[a];
	}
	return(L);
    }





    /**This gets the x-coordinates of the points*/
    public static double[] xList(int p,int q) {
	double P=PlaidFunctions.P(p,q);
	double Q=PlaidFunctions.Q(p,q);
	int count=0;
	double[] d=new double[2*p+2*q];
	for(int a=1;a<=2*p;++a) {
	    d[count]=a/P;
	    ++count;
	}
	for(int a=0;a<2*q;++a) {
	    d[count]=a/Q;
	    ++count;
	}
	Arrays.sort(d);
	return(d);
    }



    public static int[] xLabels(int p,int q) {
	int count=0;
	int[] d=new int[2*p+2*q];
	for(int a=1;a<=2*p;++a) {
	    d[count]=10*q*a+1;;
	    ++count;
	}
	for(int a=0;a<2*q;++a) {
	    d[count]=10*p*a+2;
	    ++count;
	}
	Arrays.sort(d);
	for(int a=0;a<count;++a) d[a]=d[a]%10;
	return(d);
    }



    /**Computes the spin of the point. This is the orientation
       coming from the dynamics.  The spin is used in the arrowed
       lines feature. It tells the directions that the slanting
       lines point*/

    public static int direction(int p,int q,int sign,Complex z) {
	int n0=0;
	if(sign==-1) n0=PlaidFunctions.yInterceptNegative(p,q,z);
	if(sign==+1) n0=PlaidFunctions.yInterceptPositive(p,q,z);
	int w=p+q;
	int n1=((q-p)*n0+20*w*w*w)%(2*w);
	if(n1==0) return 0;
	if(n1>w) return 1;
	return -1;
    }


    public static boolean recognizeDebug(int j,Complex z) {
	return false;
    }


    /**This implements the plaid model*/


    public static int[] getCount(Tile T,Complex[] W) {
	int[] count=new int[4];
	for(int a=0;a<8;++a) {
	    int k=W[a].wall;
	    if(isLight(T.p,T.q,W[a])==1) count[k]=1-count[k];
	}
	return(count);
    }

    /**type 1 is P and type 2 is Q. This counts how many
       light points are on each wall and separates the count
       into whether it is a P point or a Q point.  For instance,
       count[0][0] is the number of P light points on wall 0
       count[0][1] is the number of Q light points on wall 0.*/

    public static int[][] getCountRaw(Tile T,Complex[] W) {
	int[][] count=new int[4][2];
	for(int a=0;a<8;++a) {
	    int k=W[a].wall;
	    if(isLight(T.p,T.q,W[a])==1) ++count[k][W[a].type-1];
	}
	return(count);
    }

    public static int[][][] getCountRawSigned(Tile T,Complex[] W) {
	int[][][] count=new int[4][2][2];
	for(int a=0;a<8;++a) {
	    int k=W[a].wall;
	    if(isLight(T.p,T.q,W[a])==1) {
		if(W[a].dir==-1) ++count[k][W[a].type-1][0];
		if(W[a].dir==+1) ++count[k][W[a].type-1][1];
	    }

	}
	return(count);
    }




    public static int isLight(int p,int q,Complex z) {
	double t1=0;
	double t2=0;
	if(z.type==1) t1=PlaidFunctions.FP(p,q,z.x,z.y);
	if(z.type==2) t1=PlaidFunctions.FQ(p,q,z.x,z.y);
	if(z.wall%2==0) t2=PlaidFunctions.FH(p,q,z.x,z.y);
	if(z.wall%2==1) t2=PlaidFunctions.FV(p,q,z.x,z.y);
	return isLight(z.type,z.wall%2,p,q,z);
    }


    /**This uses the definition of the model to decide
       if a particle is light or dark*/

    public static int isLight(int type,int wall,int p,int q,Complex z) {
	double t0=PlaidFunctions.FP(p,q,z.x,z.y);
	double t1=PlaidFunctions.FPP(p,q,z.x,z.y);
	double t2=PlaidFunctions.FQ(p,q,z.x,z.y);
	double t3=PlaidFunctions.FQP(p,q,z.x,z.y);
	double t4=PlaidFunctions.FH(p,q,z.x,z.y);
	double t5=PlaidFunctions.FV(p,q,z.x,z.y);
	double[] t={t0,t1,t2,t3,t4,t5};
	int[] s=new int[6];
	for(int i=0;i<6;++i) s[i]=sign(t[i]);

	if((type==1)&&(wall==0)) {
	    if((s[0]==s[4])&&(s[1]==s[4])) return(1);
	       return(0);
	}

	if((type==2)&&(wall==0)) {
	    if((s[2]==s[4])&&(s[3]==s[4])) return(1);
	       return(0);
	}

	if((type==1)&&(wall==1)) {
	    if((s[0]==s[5])&&(s[3]!=s[5])) return(1);
	       return(0);
	}


	if((type==2)&&(wall==1)) {
	    if((s[2]==s[5])&&(s[1]!=s[5])) return(1);
	       return(0);
	}

	return(-1);
    }



    public static int sign(double d) {
	if(d>0) return(1);
	if(d<0) return(-1);
	return(0);
    }

    public static int on(double x,double y) {
	if(x*y<0) return(0);
	if(x*x>y*y) return(0);
	return(1);
    }



    public static int onCritical(int p,int q,Complex z) {
	double t1=0;
	double t2=0;
	if(z.type==1) t1=PlaidFunctions.FP(p,q,z.x,z.y);
	if(z.type==2) t1=PlaidFunctions.FQ(p,q,z.x,z.y);
	if(z.wall%2==0) t2=PlaidFunctions.FH(p,q,z.x,z.y);
	if(z.wall%2==1) t2=PlaidFunctions.FV(p,q,z.x,z.y);
	double t=(p+q)*(t1-t2);
	if((t<0)&&(t>-4.5)) return(1);
	return(0);
    }


}

