import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


/**This is wrapper class for a list of points in the
   plane.  The main routine in this class is
   taking the convex hull of a finite set of points.
**/


public class PolygonWrapper {
    Complex[] z=new Complex[500];
    int count;
    int edge;
    int t1,t2;
    int index;

    /**Constructors**/
    public PolygonWrapper() {}

    public PolygonWrapper(PolygonWrapper P) {
	for(int i=0;i<P.count;++i) z[i]=new Complex(P.z[i]);
	edge=P.edge;
	count=P.count;
	t1=P.t1;
	t2=P.t2;
	index=P.index;
    }


    public PolygonWrapper(int cc,Complex[] zz) {
	this.count=cc;
	for(int i=0;i<cc;++i) {
             z[i]=new Complex(zz[i]);
	}
    }


    /**converting to a path*/

    public Path2D.Double toPath2D() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(z[0].x,z[0].y);
	for(int i=0;i<count;++i) {
	    gp.lineTo(z[i].x,z[i].y);
	}
	gp.closePath();
	return(gp);
    }

    public PolygonWrapper translate(Complex w) {
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=count;
	for(int i=0;i<count;++i) Q.z[i]=Complex.plus(z[i],w);
	return Q;
    }

    /**printout**/

    public void print() {
	System.out.println("count "+count);
	for(int i=0;i<count;++i) z[i].print();
    }

    /**this routine finds the lowest point of
   a polygon.  if there are more than one
   of these points, the routine picks the
   last one.*/


    public static int extreme(Complex u,PolygonWrapper P) {
         double test,min;
         int X;
         min=10000.0;
         X=0;
	 Complex v;
         for(int i=0;i<P.count;++i) {
	     v=Complex.times(u,P.z[i]);
	     test=v.y;
            if(test<min) {
             X=i;
	     min=test;
	    }
	 }
	 return(X);
    }

    public static PolygonWrapper cheapHull(PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper();
	int[] n=new int[100];
	Complex u=new Complex();
	for(int i=0;i<32;++i) {
	    double theta=1.0*Math.PI*i/16.0+Math.PI/32.0;
	    u=new Complex(Math.cos(theta),Math.sin(theta));
	    n[i]=extreme(u,P);
	}
	Q.z[0]=P.z[n[0]];
	int ct=1;
	for(int i=1;i<32;++i) {
	   if(Complex.dist(Q.z[ct-1],P.z[n[i]])>.000001) {
	     Q.z[ct]=P.z[n[i]];
	     ++ct;
	   }
	}
	Q.count=ct;
	return(Q);
    }

    public Complex center() {
	Complex w=new Complex(0,0);
	for(int i=0;i<count;++i) w=Complex.plus(w,z[i]);
	w=w.scale(1.0/count);
	return(w);
    }



}