import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Polytope {
    int count;
    Vector4[] V=new Vector4[500];
    int[] type=new int[4];
    int[] code=new int[6];
    int zone;

    public Polytope() {}

    public Polytope(Polytope P) {
	count=P.count;
	for(int i=0;i<P.count;++i) {
	    V[i]=new Vector4(P.V[i]);
	}
	for(int i=0;i<3;++i) type[i]=P.type[i];
	for(int i=0;i<6;++i) code[i]=P.code[i];

    }


    public static Polytope shift(Vector4 V,Polytope P) {
	Polytope Q=new Polytope();
	for(int i=0;i<P.count;++i) {
	    Q.V[i]=Vector4.plus(P.V[i],V);
	}
	Q.count=P.count;
	Q.type[0]=P.type[0];
	Q.type[1]=P.type[1];
	Q.type[2]=P.type[2];
	return(Q);
    }


    /**Taking a planar slice.  The plane of the slice is determined by the
       data (V[0],V[1],x,y).  The plane is the intersection of the 2
       hyperplanes   
 
           V{0].W = x   and V[1].W=y.    

       Here W is a vector in R^4.  We need to represent points in this plane
       as points in R^2, in order to draw them, so we consider the auxiliary
       map

           W  ->  (W.V[2],W.V[3]).
 
       The main routine is planarSlice().  The way is works is that
       we consider the vertices of the polytope P three at a
       time, as indicated by the indices i,j,k.  Then we compute where the triangle
       with vertices P.V[i],P.v[i],P.v[k] intersects the plane of the slice.
       If the intersection is empty, we return (null).  Then we take the
       convex hull, when all triples have been computed.*/

    public static PolygonWrapper planarSlice(Vector4[] V,double x,double y,Polytope P){
	Path2D.Double gp=new Path2D.Double();
	PolygonWrapper X=planarSlice1(V,x,y,P);
	if(X.count==0) return(null);
	X=PolygonWrapper.cheapHull(X);
	return(X);
    }

    public static Complex planarSlice0(Vector4[] V,double x,double y,Polytope P,int i,int j,int k) {
	double x0=V[0].dot(V[0],P.V[i]);
	double y0=V[1].dot(V[1],P.V[i]);
	double x1=V[0].dot(V[0],P.V[j]);
	double y1=V[1].dot(V[1],P.V[j]);
	double x2=V[0].dot(V[0],P.V[k]);
	double y2=V[1].dot(V[1],P.V[k]);
        double det=x1*y0 + x2*y1 + x0*y2 - x0*y1 - x1*y2 - x2*y0;
	if(Math.abs(det)<.00000001) return(null);
	double r=y*x1 - y*x2 + x2*y1 - x1*y2 - y1*x + y2*x;
	double s=y*x0 - y*x2 + x2*y0 - x0*y2 - y0*x + y2*x;
	r=+r/det;
	s=-s/det;

	if(r<0.0000001) return(null);
	if(r>0.9999999) return(null);
	if(s<0.0000001) return(null);
	if(s>0.9999999) return(null);
	if(r+s>.9999999) return(null);
	Complex p=new Complex();
	x0=V[2].dot(V[2],P.V[i]);
	y0=V[3].dot(V[3],P.V[i]);
	x1=V[2].dot(V[2],P.V[j]);
	y1=V[3].dot(V[3],P.V[j]);
	x2=V[2].dot(V[2],P.V[k]);
	y2=V[3].dot(V[3],P.V[k]);
	p.x=r*x0+s*x1+(1-r-s)*x2;
	p.y=r*y0+s*y1+(1-r-s)*y2;
	return(p);
    }


    public static PolygonWrapper planarSlice1(Vector4[] V,double x,double y,Polytope P) {
	Path2D.Double gp=new Path2D.Double();
	int fred=0;
	Complex p;
	Complex[] zz=new Complex[300];
	int number=0;

	for(int i=0;i<P.count;++i) {
	    for(int j=i+1;j<P.count;++j) {
		for(int k=j+1;k<P.count;++k) {

		    p=planarSlice0(V,x,y,P,i,j,k);
		    if(p!=null) {
			zz[number]=new Complex(p);
			++number;
		    }
		}
	    }
	}
	return new PolygonWrapper(number,zz);
    }

    public PolygonWrapper slice(int s,double x,double y) {
	if(s==0) return(slice0(x,y));
	if(s==1) return(slice1(x,y));
	if(s==2) return(slice2(x,y));
	return(null);
    }


    /**X slice*/
    public  PolygonWrapper slice0(double x,double y) {
	Vector4[] V=new Vector4[4];
	V[0]=new Vector4(1,0,0,0);
	V[1]=new Vector4(0,0,0,1);
	V[2]=new Vector4(0,1,0,0);
	V[3]=new Vector4(0,0,1,0);
	return(planarSlice(V,x,y,this));
    }

    /**Y slice*/
    public PolygonWrapper slice1(double x,double y) {
	Vector4[] V=new Vector4[4];
	V[0]=new Vector4(0,1,0,0);
	V[1]=new Vector4(0,0,0,1);
	V[2]=new Vector4(1,0,0,0);
	V[3]=new Vector4(0,0,1,0);
	return(planarSlice(V,x,y,this));
    }

    /**Z slice*/
    public PolygonWrapper slice2(double x,double y) {
	Vector4[] V=new Vector4[4];
	V[0]=new Vector4(0,0,1,0);
	V[1]=new Vector4(0,0,0,1);
	V[2]=new Vector4(1,0,0,0);
	V[3]=new Vector4(0,1,0,0);
	return(planarSlice(V,x,y,this));
    }

    public void print() {
	System.out.println("-------------");
	for(int i=0;i<count;++i) V[i].print();
    }

    public void print(int k) {
	System.out.println("-------------");
	for(int i=0;i<count;++i) {
	    Vector4 W=V[i].scale(k);
            W.print();
	}
    }

    /**These routines tell whether the polytope
       contains the given point.  To make the routine
       robust (so that the answer is yes for vertices)
       we fatten the polytope slightly.*/

    public Vector4 center() {
	Vector4 W=new Vector4();
	double d=1.0/count;
	for(int i=0;i<count;++i) {
	    W=Vector4.plus(W,V[i].scale(d));
	}
	return(W);
    }

    /**t>0 expends around the centroid.
       t<0 shrinks around the centroid*/

    public Polytope fatten(double t) {
	Vector4 W=center();
	Polytope X=new Polytope(this);
	for(int i=0;i<X.count;++i) {
	    X.V[i]=Vector4.plus(W.scale(-t),X.V[i].scale(1+t));
	}
	return(X);
    }


    public boolean contains(Polytope P) {
	System.out.println("length "+P.count);
	for(int i=0;i<P.count;++i) {
	    if(contains(P.V[i])==false) return false;
	} 
        return true;
    }

    public boolean contains(Vector4 V) {
	double[] U={V.x[0],V.x[1],V.x[2],V.x[3]};
	return contains(U);
    }

    public boolean contains(double[] U) {
	Polytope FAT=this.fatten(.00001);
	PolygonWrapper X=FAT.slice2(U[2],U[3]);
	if(X==null) return false;
	Path2D.Double gp=X.toPath2D();
	return(gp.contains(U[0],U[1]));
    }




    /**This prints the polytope in java-usable form*/

    public void javaPrint(Output OUT,int k) {
	Integer K=new Integer(k);
	OUT.writeln("public static Polytope P"+K.toString()+"() {");
	OUT.writeln("Polytope P=new Polytope();");
	K=new Integer(count);
	OUT.writeln("P.count="+K.toString()+";");
	for(int i=0;i<count;++i) {
	    Integer I=new Integer(i);
	    OUT.write("P.V["+I.toString()+"]=new Vector4(");
            for(int j=0;j<4;++j) {
		Double D=new Double(V[i].x[j]);
		if(j<3) OUT.write(D.toString()+",");
		if(j==3) OUT.writeln(D.toString()+");");
	    }

	}
	for(int i=0;i<6;++i) {
	    Integer I=new Integer(i);
	    Integer C=new Integer(code[i]);
	    OUT.writeln("P.code["+I.toString()+"]="+C.toString()+";");
	}
	OUT.writeln("return(P);");
	OUT.writeln("}");
	OUT.writeln("");
    }

    public void javaPrint(int k) {
	Integer K=new Integer(k);
	System.out.println("public static Polytope P"+K.toString()+"() {");
	System.out.println("Polytope P=new Polytope();");
	K=new Integer(count);
	System.out.println("P.count="+K.toString()+";");
	for(int i=0;i<count;++i) {
	    Integer I=new Integer(i);
	    System.out.print("P.V["+I.toString()+"]=new Vector4(");
            for(int j=0;j<4;++j) {
		Double D=new Double(V[i].x[j]);
		if(j<3) System.out.print(D.toString()+",");
		if(j==3) System.out.println(D.toString()+");");
	    }

	}
	for(int i=0;i<6;++i) {
	    Integer I=new Integer(i);
	    Integer C=new Integer(code[i]);
	    System.out.println("P.code["+I.toString()+"]="+C.toString()+";");
	}
	System.out.println("return(P);");
	System.out.println("}");
	System.out.println("");
    }







}












