import java.awt.*;
import java.math.*;
import java.awt.geom.*;
import java.util.Arrays;

public class Tile {
    int p,q;
    int i,j;
    int type;
    int[][] raw=new int[4][2];
    int[][][] rawSigned=new int[4][2][2];  //wall, P-or-Q, spin
    int[] TYPE=new int[2];


    public Tile() {}


    public Tile(int p0,int q0,int i0,int j0) {
	p=p0;
	q=q0;
	i=i0;
	j=j0;
    }

    public Tile(Tile T) {
	p=T.p;
	q=T.q;
	i=T.i;
	j=T.j;
    }


    /**This gets the basic square*/
    public Path2D.Double getSquare() {
	Path2D.Double gp=new Path2D.Double(); 
	gp.moveTo(i+0,j+0);
	gp.lineTo(i+0,j+1);
	gp.lineTo(i+1,j+1);
	gp.lineTo(i+1,j+0);
	gp.closePath();
	return(gp);
    }

    /**This gets all parts of the square having capacity less than k*/
    public Path2D.Double getSquareLimited(int k) {
	Path2D.Double gp=new Path2D.Double(); 

	if(PlaidFunctions.capacity(p,q,i) <= k) {
	    gp.moveTo(i+0,j+0);
	    gp.lineTo(i+0,j+1);
	}

	if(PlaidFunctions.capacity(p,q,i+1) <= k) {
	    gp.moveTo(i+1,j+0);
	    gp.lineTo(i+1,j+1);
	}

	if(PlaidFunctions.capacity(p,q,j) <= k) {
	    gp.moveTo(i+0,j+0);
	    gp.lineTo(i+1,j+0);
	}

	if(PlaidFunctions.capacity(p,q,j+1) <= k) {
	    gp.moveTo(i+0,j+1);
	    gp.lineTo(i+1,j+1);
	}

	return(gp);
    }





    public Path2D.Double getTileUndirected(int style) {
	int[][] a={{0,0},{0,1},{1,2},{2,3},{3,0},{0,2},{1,3}};
	int[] b=a[type];
	int c1=b[0];
	int c2=b[1];
	Path2D.Double gp=new Path2D.Double();
	Complex z=new Complex(i+.5,j+.5);
	Complex Z0=new Complex(i+.5,j+ 0);
	Complex Z1=new Complex(i +0,j+.5);
	Complex Z2=new Complex(i+.5,j+ 1);
	Complex Z3=new Complex(i+ 1,j+.5);
	Complex[] Z={Z0,Z1,Z2,Z3};
	gp.moveTo(Z[c1].x,Z[c1].y);
	if(style==1) gp.lineTo(z.x,z.y);
	gp.lineTo(Z[c2].x,Z[c2].y);
	return(gp);
    }


    public Path2D.Double getEdgeDirected() {
	int[] a=PlaidClassify.classify(this);
	return getEdgeDirected(a[0],a[1]);
    }


    public Path2D.Double getEdgeDirected(int c1,int c2) {
	return getEdgeDirected(c1,c2,i,j);
    }

    public static Path2D.Double getEdgeDirected(int c1,int c2,int i,int j) {
	Path2D.Double gp=new Path2D.Double();
	Complex z=new Complex(i+.5,j+.5);
	double a1=.35;
	double a2=1-a1;

	Complex A0=new Complex(i+.5,j+ 0);
	Complex A1=new Complex(i +0,j+.5);
	Complex A2=new Complex(i+.5,j+ 1);
	Complex A3=new Complex(i+ 1,j+.5);

	Complex B0=new Complex(i+a1,j+ 0);
	Complex B1=new Complex(i +0,j+a1);
	Complex B2=new Complex(i+a1,j+ 1);
	Complex B3=new Complex(i+ 1,j+a1);

	Complex C0=new Complex(i+a2,j+ 0);
	Complex C1=new Complex(i +0,j+a2);
	Complex C2=new Complex(i+a2,j+ 1);
	Complex C3=new Complex(i+ 1,j+a2);

	Complex[] A={A0,A1,A2,A3};
	Complex[] B={B0,B1,B2,B3};
	Complex[] C={C0,C1,C2,C3};
	gp.moveTo(B[c1].x,B[c1].y);
	gp.lineTo(C[c1].x,C[c1].y);

	gp.curveTo(C[c1].x,C[c1].y,z.x,z.y,A[c2].x,A[c2].y);
	gp.curveTo(A[c2].x,A[c2].y,z.x,z.y,B[c1].x,B[c1].y);
	gp.closePath();
	return(gp);
    }







    public void appendEdgeDirected(Path2D gp) {
	int[] I=PlaidClassify.classify(this);
	int c1=I[0];
	int c2=I[1];
	Complex z=new Complex(i+.5,j+.5);
	Complex A0=new Complex(i+.5,j+ 0);
	Complex A1=new Complex(i +0,j+.5);
	Complex A2=new Complex(i+.5,j+ 1);
	Complex A3=new Complex(i+ 1,j+.5);
	Complex[] A={A0,A1,A2,A3};
	gp.moveTo(A[c1].x,A[c1].y);
	gp.lineTo(A[c2].x,A[c2].y);
    }


    public void type() {
	raw=PlaidModel.typeRaw(this);
	rawSigned=PlaidModel.typeRawSigned(this);
	type=PlaidModel.typeUnoriented(this);
	TYPE=PlaidModel.typeOrientedCheap(this);
    }


    /**This gets the dots which represent the light points*/

    public Path2D.Double getPointPath() {
	Complex[] Z=PlaidModel.getPoints(this);
	Path2D.Double gp=new Path2D.Double();
	for(int a=0;a<Z.length;++a) {  
	    if(PlaidModel.isLight(p,q,Z[a])==1) {   
	       gp.moveTo(Z[a].x,Z[a].y);
	       gp.lineTo(Z[a].x,Z[a].y);
	    }
	}
	return(gp);
    }

    /**This returns those dots lying on lines of capacity at most k*/

    public Path2D.Double getPointPathLimited(int k) {
	Complex[] Z=PlaidModel.getPoints(this);
	Path2D.Double gp=new Path2D.Double();
	for(int a=0;a<Z.length;++a) {  
	    if(PlaidModel.isLight(p,q,Z[a])==1) {   
		if(PlaidFunctions.capacityLine(p,q,Z[a])<=k) {
	          gp.moveTo(Z[a].x,Z[a].y);
	          gp.lineTo(Z[a].x,Z[a].y);
		}
	    }
	}
	return(gp);
    }

    /**This gets the slanting lines in the tile
       This does not require the points to be light points*/

    public Path2D.Double getLines(int choice,int sign) {
	Path2D.Double gp=new Path2D.Double();
	Complex[] Z1=PlaidModel.getQuad0(this);
	Complex[] Z2=PlaidModel.getQuad1(this);
	gp=segment(choice,sign,Z1,Z2);
	return(gp);
    }

    public Path2D.Double getLinesLimited(int choice,int sign,int cap) {
	Path2D.Double gp=new Path2D.Double();
	Complex[] Z1=PlaidModel.getQuad0(this);
	Complex[] Z2=PlaidModel.getQuad1(this);
	gp=segmentLimited(choice,sign,Z1,Z2,cap);
	return(gp);
    }


    public Path2D.Double segment(int choice,int sign,Complex[] Z1,Complex[] Z2) {
	Path2D.Double gp=new Path2D.Double();

	for(int a=0;a<4;++a) {
	    int b=(a+1)%4;
	    Complex z1=Z1[a];
	    Complex z2=Z1[b];
	    double s=(z2.y-z1.y)/(z2.x-z1.x); //slope
	    if(sign*s>0) {
		if(choice==0) addSegment(gp,z1,z2);
		if(choice==1) addArrow(gp,sign,p,q,z1,z2);
	    }
	}

	for(int a=0;a<4;++a) {
	    int b=(a+1)%4;
	    Complex z1=Z2[a];
	    Complex z2=Z2[b];
	    double s=(z2.y-z1.y)/(z2.x-z1.x);
	    if(sign*s>0) {
		if(choice==0) addSegment(gp,z1,z2);
		if(choice==1) addArrow(gp,sign,p,q,z1,z2);
	    }
	}
	return(gp);
    }


    /**This only gets the lines if they are less than a certain capacity*/

    public Path2D.Double segmentLimited(int choice,int sign,Complex[] Z1,Complex[] Z2,int cap) {
	Path2D.Double gp=new Path2D.Double();

	for(int a=0;a<4;++a) {
	    int b=(a+1)%4;
	    Complex z1=Z1[a];
	    Complex z2=Z1[b];
	    double s=(z2.y-z1.y)/(z2.x-z1.x);
	    if(sign*s>0) {
		double k=PlaidFunctions.mass(p,q,sign,z1);
		if(k<cap) {
		  if(choice==0) addSegment(gp,z1,z2);
		  if(choice==1) addArrow(gp,sign,p,q,z1,z2);
		}
	    }
	}

	for(int a=0;a<4;++a) {
	    int b=(a+1)%4;
	    Complex z1=Z2[a];
	    Complex z2=Z2[b];
	    double s=(z2.y-z1.y)/(z2.x-z1.x);
	    if(sign*s>0) {
		double k=PlaidFunctions.mass(p,q,sign,z1);
	       if(k<cap) {
		  if(choice==0) addSegment(gp,z1,z2);
		  if(choice==1) addArrow(gp,sign,p,q,z1,z2);
	       }
	    }
	}
	return(gp);
    }

    public static void addSegment(Path2D.Double gp,Complex z1,Complex z2) {
       gp.moveTo(z1.x,z1.y);
       gp.lineTo(z2.x,z2.y);
       return;
    }

    public static void addArrow(Path2D.Double gp,int sign,int p,int q,Complex z1,Complex z2) {
	int arr=direction(p,q,z1,z2);
	if(arr==0) return;
	    Complex[] Z=GraphicsHelp.arrow(arr,z1,z2);
	    if(Z==null) return;
	    gp.moveTo(Z[0].x,Z[0].y);
	    gp.lineTo(Z[1].x,Z[1].y);
	    gp.lineTo(Z[2].x,Z[2].y);
	    gp.closePath();
	    return;
	}


    public static int direction(int p,int q,Complex z1,Complex z2) {
	double slope=(z2.y-z1.y)/(z2.x-z1.x);
	double y0=z1.y-slope*z1.x;
	int y=(int)(Math.floor(y0+.5));
	int w=p+q;
	int n=((q-p)*y+2*w*w*w)%(2*w);
	if(n==0) return 0;
	if(n>w) return -1;
	return 1;
    }



}
