import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;


public class TileTracer {

    public static Tile nextTile(Tile T) {
	double A=1.0*T.p/T.q;
	Vector4 V=PlaidClassifyingMap.PHI(A,T.i+.5,T.j+.5);
	int[] a=PlaidClassifyFast.classify(V.x[0],V.x[1],V.x[2],V.x[3]);
	if(a[0]==a[1]) return(T);
	Tile U=new Tile(T);
	if(a[1]==0) --U.j;
	if(a[1]==1) --U.i;
	if(a[1]==2) ++U.j;
	if(a[1]==3) ++U.i;
	return(U);
    }

    /**Finds the plaid polygon through the given tile*/
    public static Path2D.Double plaidPolygon(Tile T) {
	boolean test=false;
	Tile U=new Tile(T);
	Path2D.Double gp=new Path2D.Double();
	int count=0;
	while((count<1000000)&&(test==false)) {  
            U.appendEdgeDirected(gp);
	    U=nextTile(U);  
	    if((U.i==T.i)&&(U.j==T.j)) test=true;
	    ++count;
	}
	return(gp);
    }

    /**Finds the plaid polygon through the given tile*/
    public static Complex[] plaidPolygonRaw(Tile T) {
	boolean test=false;
	Tile U=new Tile(T);
	Complex[] Z0=new Complex[1000000];
	int count=0;
	while((count<1000000)&&(test==false)) {  
	    Z0[count]=new Complex(U.i+.5,U.j+.5);
	    U=nextTile(U);  
	    if((U.i==T.i)&&(U.j==T.j)) test=true;
	    ++count;
	}
	Complex[] Z1=new Complex[count];
	for(int i=0;i<count;++i) Z1[i]=new Complex(Z0[i]);
	return(Z1);
    }



}

