import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class retrieves the the polytopes from the 4 partitions:
-graph PET partition
-plaid PET partition
-graph triple partition 
-plaid triple partition
All polytopes are in the triple partitions  scaled up by 60 to clear denominators. */

public class AllPolytopes {


    public static Polytope plaid(int k) {
	int[][] P1=DataPlaidPolytopes.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	int[] type=DataPlaidPolytopes.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }

    public static Polytope inZ1(int k) {
	int[][] P1=DataPlaidPolytopes1.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	}
	int[] type=DataPlaidPolytopes1.type(k);
	X.type[1]=type[0];
	X.type[2]=type[1];
	return(X);
    }

    public static Polytope inZ2(int k) {
	int[][] P1=DataPlaidPolytopes2.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	    X.V[i]=X.V[i].scale(1.0/6);
	}
	int[] code=DataPlaidPolytopes2.type(k);
	X.type[1]=code[0];
	X.type[2]=code[1];
	X.code[0]=code[0];
	X.code[1]=code[1];
	X.code[2]=code[2];
	X.code[3]=code[3];
	return(X);
    }


    public static Polytope inZ3(int k) {
	int[][] P1=DataCleanPartition.data(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],P1[i][2],P1[i][3]);
	    X.V[i]=X.V[i].scale(1.0/60);
	}
	int[] code=DataCleanPartition.type(k);
	X.type[1]=code[0];
	X.type[2]=code[1];
	X.code[0]=code[0];
	X.code[1]=code[1];
	X.code[2]=code[2];
	X.code[3]=code[3];
	return(X);
    }

    /**This is the set Z from the monograph.  It is
       the domain for the orbit equivalence theorem*/

    public static Polytope ZPiece(int k) {
	int[][] P1=DataHitset.ZPiece(k);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],10*P1[i][2],P1[i][3]);
	}
	return(X);
    }

    /**Here is a special case, just Z+*/
    public static Polytope ZPlus() {
	int[][] P1=DataHitset.ZPiece(0);
	Polytope X=new Polytope();
	X.count=P1.length;
	for(int i=0;i<P1.length;++i) {
	    X.V[i]=new Vector4(P1[i][0],P1[i][1],10*P1[i][2],P1[i][3]);
	}
	return(X);
    }


    /**This is the index of the point in Z*/
    public static int indexZ1(Vector4 V) {
	for(int i=0;i<21;++i) {
	    Polytope P=inZ1(i);
	    if(P.contains(V)) return i;
	}
	return -1;
    }

    /**This is the index of the point in Z*/
    public static int indexZ3(Vector4 V) {
	for(int i=0;i<95;++i) {
	    Polytope P=inZ3(i);
	    if(P.contains(V)) return i;
	}
	return -1;
    }
}


