import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class does the basic arithmetic
   of complex numbers. The data types
to do with the plaid model:

   type: Is the point type P or type Q  (1 or 2)
   wall: Which square side is the point on S-0, W-1, N-2, E-3
   dir1: direction of negative slanting lines
   dir2: direction of positive slanting lines*/

public class Complex {
    double x,y;
    int type,wall,dir;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
	this.type=z.type;
	this.wall=z.wall;
	this.dir=z.dir;
    }

    public Complex set(Complex z) {
        x=z.x;
        y=z.y;
        return this;
    }

    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    
    public static Complex negative(Complex z) {
	Complex w=new Complex(-z.x,-z.y);
	return(w);
    }




    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }
    

    public static double dot(Complex a, Complex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(norm(z));
    }
    
    
    
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }

    public Complex plus(Complex z) {
        return new Complex(x+z.x, y+z.y);
    }
    

    public Complex minus(Complex z) {
        return new Complex(x-z.x, y-z.y);
    }

    public Complex times(Complex z) {
        return new Complex(x*z.x-y*z.y,
        x*z.y+y*z.x);
    }
    
    

    public Complex inverse() {
        double d=x*x+y*y;
        return new Complex(x/d,-y/d);
    }
    
    public Complex divide(Complex z2) {
        return times(inverse(z2));
    }
    
    
    public Complex conjugate() {
        return new Complex(x,-y);
    }

    public double dot(Complex a) {
        return a.x*x+a.y*y;
    }
    
    public boolean equals(Complex a) {
        return ((a.x==x)&&(a.y==y));
    }
    
    
    public double arg(){
        return Math.atan2(y,x);
    }


    public static boolean isPositivelyOriented(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	if(z[4].y>-.0000001) return(true);
	return(false);
    }



    public Complex reflect(Complex z) {
	Complex w=new Complex(2*x-z.x,2*y-z.y);
	return(w);
    }

    public static boolean onSegment(Complex w,Complex z1,Complex z2) {
	double d1=dist(w,z1);
	double d2=dist(w,z2);
	double d3=dist(z1,z2);
	if(d1+d2<d3+.0000001) return(true);
	return(false);
    }

    
    public Complex scale(double r) {
	Complex w=new Complex(r*x,r*y);
        return(w);
    }

    public static Complex cross(Complex z1,Complex z2) {
	double a=z1.y-z2.y;
	double b=-z1.x+z2.x;
	double c=z1.x*z2.y-z1.y*z2.x;
	return(new Complex(a/c,b/c));
    }

    public static Complex findCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	double x1=z1.x;
	double y1=z1.y;
	double x2=z2.x;
	double y2=z2.y;
	double x3=z3.x;
	double y3=z3.y;
	double x4=z4.x;
	double y4=z4.y;
	double a=y1*(x2*x4-x2*x3)+y2*(x1*x3-x1*x4)+y3*(x1*x4-x2*x4)+y4*(x2*x3-x1*x3);
	double b=x1*(y2*y4-y2*y3)+x2*(y1*y3-y1*y4)+x3*(y1*y4-y2*y4)+x4*(y2*y3-y1*y3);
	double c=x2*y4+x1*y3+x3*y2+x4*y1-x3*y1-x2*y3-x1*y4-x4*y2;
	a=a/c;
	b=-b/c;
	return new Complex(a,b);
    }


    public static boolean checkCross(Complex z1,Complex z2,Complex w1,Complex w2) {
	Complex c=Complex.findCross(z1,z2,w1,w2);
	double d1=dist(z1,z2)-dist(z1,c)-dist(z2,c);
	if(d1<-.0000001) return false;
	double d2=dist(w1,w2)-dist(w1,c)-dist(w2,c);
	if(d2<-.0000001) return false;
	return true;
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

