public class DataHitset {

    /**This is the data for the sets Z+ and W+ in the monograph.
       The ordering is Z+,Z-,W+,W-.
       The 3rd coordinate is not important as long as it is
       large enough.  The point is that these sets are prisms
       and we need to represent them as polytopes*/

    public static int[][] ZPiece(int k) {
    int[][][] P=
	{{{3,1,1,0},{1,1,1,0},{-1,-1,1,0},{1,-1,1,0},
	 {3,1,-1,0},{1,1,-1,0},{-1,-1,-1,0},{1,-1,-1,0},
	 {0,-1,1,1},{3,2,1,1},{2,2,1,1},{-1,-1,1,1},
	 {0,-1,-1,1},{3,2,-1,1},{2,2,-1,1},{-1,-1,-1,1}},
	{{-3,-1,1,0},{-1,-1,1,0},{1,1,1,0},{-1,1,1,0},
	 {-3,-1,-1,0},{-1,-1,-1,0},{1,1,-1,0},{-1,1,-1,0},
	 {0,1,1,1},{-3,-2,1,1},{-2,-2,1,1},{1,1,1,1},
	 {0,1,-1,1},{-3,-2,-1,1},{-2,-2,-1,1},{1,1,-1,1}},
         {{1,-1,-1,0},{1,-1,1,0},{2,0,1,1},{2,0,-1,1},
         {1,0,1,1},{1,0,-1,1},{0,-1,1,1},{0,-1,-1,1},
	  {1,-1,1,1},{1,-1,-1,1}},
         {{-1,1,-1,0},{-1,1,1,0},{-2,0,1,1},{-2,0,-1,1},
         {-1,0,1,1},{-1,0,-1,1},{0,1,1,1},{0,1,-1,1},
	  {-1,1,1,1},{-1,1,-1,1}}};
	return P[k];
    }

    /**Here are some sets defined in connection with the hitset.
       The hitset is the orbit of the union of the following 2
       pieces.*/

    public static PolygonWrapper hitsetLo(double P,int i,int j) {
	double[][] d={{3-3*P,1-2*P},{3-P,1},{1+P,1+P},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }


    public static PolygonWrapper hitsetHi(double P,int i,int j) {
	double[][] d={{P-1,P-1},{1-P,-1},{3-3*P,1-2*P},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }




    /**The orbit of these pieces is the complement of the hitset*/

    public static PolygonWrapper hitsetComplement1(double P,int i,int j) {
	double[][] d={{3-P,1+P},{3-P,1},{1+P,1+P},{1+P,1+2*P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }

    public static PolygonWrapper hitsetComplement2(double P,int i,int j) {
	double[][] d={{1+P,1+P},{1+P,1+2*P},{1-P,1},{1-P,1-P}};
	PolygonWrapper X=new PolygonWrapper();
	X.count=4;
	for(int k=0;k<4;++k) {
             X.z[k]=new Complex(d[k][0],d[k][1]);
	     X.z[k]=Complex.plus(X.z[k],new Complex(2*i,i*P+2*j));
	}
	return X;
    }







}


