import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This file takes random points in the partition X* # F_X^{-1}(X)
   and sees where they go under the application of F_X^2.  The
   notation is as in the monograph (the Plaid Model).  This
   data is useful for generating the clean partition.*/

public class GenerateDynamics3 implements Runnable {
    boolean HALT=true;
    int[][] LIST=new int[400][5];
    int COUNT=0;

    public void run() {
	HALT=false;
	while(HALT==false) {
	    int random=(int)(66*Math.random());
	    Polytope P=AllPolytopes.inZ2(random);
	    P=forward2(P);
	    Vector4 V=random(P);
	    int[] a=PlaidClassify.ZIndexDebug(V);
	    int[] temp={random,a[0],a[1],a[2],a[3]};

	    if(ListHelp.onList(temp,LIST,COUNT)==false) {
		LIST[COUNT]=temp;
		++COUNT;
		printout();
		System.out.println("------"+COUNT+"------");
	    }

	}

    }



    public static Polytope forward2(Polytope P) {
	Polytope Q=new Polytope(P);
	Q.type[1]=P.code[0];
	Q.type[2]=P.code[1];
	Q=PlaidPolytopeMoves.map(2,Q);
	Q.type[1]=P.code[2];
	Q.type[2]=P.code[3];
	Q=PlaidPolytopeMoves.map(2,Q);
	return Q;
    }



    public static Polytope backward2(int[] code0,Polytope P) {
	int[] code=new int[4];
	for(int i=0;i<4;++i) code[i]=(2+code0[i])%4;
	Polytope Q=new Polytope(P);
	Q.type[1]=code[3];
	Q.type[2]=code[2];
	Q=PlaidPolytopeMoves.map(1,Q);
	Q.type[1]=code[1];
	Q.type[2]=code[0];
	Q=PlaidPolytopeMoves.map(1,Q);
	return Q;
    }






    public void printout() {
	System.out.println("----------");
	System.out.print("{");

	for(int choice=0;choice<66;++choice) {

	for(int i=0;i<COUNT;++i) {
	    if(LIST[i][0]==choice) {
	      printout(LIST[i]);
	      if(i<COUNT-1) System.out.print(",");
	    }
	}
	}
	System.out.println("");
    }


    public void printout(int[] k) {
	System.out.print("{");
	for(int i=0;i<5;++i) {
             System.out.print(k[i]);
	     if(i<4) System.out.print(",");
	     else System.out.print("}");
	}
    }


    public Vector4 random(Polytope P) {
	int n=P.count;
	double[] d=new double[n];
	double sum=0;
	for(int i=0;i<n;++i) {
            d[i]=Math.random();
	    sum=sum+d[i];
	}
	for(int i=0;i<n;++i) d[i]=d[i]/sum;
	Vector4 SUM=new Vector4();
	for(int i=0;i<n;++i) {
	    SUM=Vector4.plus(SUM,P.V[i].scale(d[i]));
	}
	return SUM;
    }

}





