import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**This file generates the clean partition.  The results of the
   calculations are written in the file temp.  The file temp
   agrees with the file DataCleanPartition.java.  The polytope vertices
   are scaled up by a factor of 60**/

public class GeneratePolytopes3 implements Runnable {
    boolean HALT=true; 
    Output OUT;
    Polytope[] LIST=new Polytope[100];

    public void run() {
	makePartition();
    }

    public void makePartition() {

	OUT=new Output("temp");
	OUT.writeln("public class DataPlaidPolytopes3 {");
	OUT.writeln("");
	OUT.writeln("public static int[][] data(int k) {");
	OUT.writeln("int[][][] A={");
	Polytope[] LIST1=getList();

	for(int i=0;i<LIST1.length;++i) {
	    boolean comma=true;
	    if(i==LIST1.length-1) comma=false;
	    int[][] a=scaleBy(LIST1[i],60);
            printout(OUT,a,comma);
	}
	OUT.writeln("");
	OUT.writeln("return A[k];");
	OUT.writeln("}");

	OUT.writeln("");
	OUT.writeln("public static int[] type(int k) {");
	OUT.writeln("int[][] A={");
	for(int i=0;i<LIST1.length;++i) {
	    OUT.write("{");
	    OUT.write(LIST1[i].code[0]+",");
	    OUT.write(LIST1[i].code[1]+",");
	    OUT.write(LIST1[i].code[2]+",");
	    OUT.write(LIST1[i].code[3]+"}");
	    if(i<LIST1.length-1) OUT.write(",");
	    else OUT.write("}");
	}
	OUT.writeln(";");
	OUT.writeln("return A[k];");
	OUT.writeln("}");
	OUT.writeln("}");
	System.out.println("done");
    }


    public static int[][] scaleBy(Polytope P,int k) {
	int[][] a=new int[P.count][4];
	for(int i=0;i<P.count;++i) {
	    a[i]=scaleBy(P.V[i],k);
	}
	return a;
    }

    public static int[] scaleBy(Vector4 V,int k) {
	int[] a=new int[4];
	for(int i=0;i<4;++i) {
	    double t=k*V.x[i];
	    a[i]=(int)(Math.floor(t+.5));
	}
	return a;
    }

    /**prints out the list of numbers*/

    public static void printout(Output OUT,int[][] a,boolean comma) {
	OUT.write("{");
	for(int i=0;i<a.length;++i) {
	    OUT.write("{");
	    OUT.write(a[i][0]+",");
	    OUT.write(a[i][1]+",");
	    OUT.write(a[i][2]+",");
	    OUT.write(a[i][3]+"}");
	    if(i+1<a.length) OUT.write(",");
	}
	if(comma==true) OUT.write("},");
	if(comma==false) OUT.write("}};");
    }


    /**This does the intersecting*/

    public static Polytope[] getList() {
	Polytope[] LIST=new Polytope[1000];
	int count=0;

	for(int k=0;k<95;++k) {
	    System.out.println(k);
	    int[] d=data(k);
	    System.out.println(k+" "+d[0]);
	       Polytope BASE=AllPolytopes.inZ2(d[0]);
               Polytope POLY=AllPolytopes.ZPiece(d[4]);
	       POLY=PlaidPolytopeMoves.shift(d[1],d[2],d[3],POLY);
	       int[] code=BASE.code;
	       POLY=backward2(code,POLY);

	       Polytope INTER=new Polytope();
               INTER=PolytopeIntersector.main(BASE,POLY);

	       if(INTER!=null) {
	           LIST[count]=INTER;
	           LIST[count].code[0]=BASE.code[0];
	           LIST[count].code[1]=BASE.code[1];
	           LIST[count].code[2]=BASE.code[2];
		   LIST[count].code[3]=BASE.code[3];
	           INTER.print();
	           ++count;
		   System.out.println("count "+count);
	       }
	}





	Polytope[] LIST2=new Polytope[count];
	for(int i=0;i<count;++i) LIST2[i]=LIST[i];
	return LIST2;
    }


    public static Polytope backward2(int[] code0,Polytope P) {
	int[] code=new int[4];
	for(int i=0;i<4;++i) code[i]=(2+code0[i])%4;
	Polytope Q=new Polytope(P);
	Q.type[1]=code[3];
	Q.type[2]=code[2];
	Q=PlaidPolytopeMoves.map(1,Q);
	Q.type[1]=code[1];
	Q.type[2]=code[0];
	Q=PlaidPolytopeMoves.map(1,Q);
	return Q;
    }



    public static int[] data(int k) {
	int[][] a={{0,1,0,0,0},{0,2,0,0,0},{1,0,-1,0,0},{2,-1,0,0,2},{2,0,0,0,0},{3,0,-1,0,0},{4,1,0,0,0},{5,2,-1,0,0},{6,1,0,0,2},{6,2,0,0,0},{7,2,1,0,2},{7,2,1,0,0},{8,1,0,0,2},{8,2,0,0,0},{9,2,-1,0,0},{10,1,-1,0,0},{10,2,-1,0,0},{11,1,0,0,0},{12,0,-1,0,0},{13,0,-1,0,0},{14,-1,0,0,0},{15,-2,-1,0,0},{16,-2,0,0,0},{17,0,0,0,0},{17,-1,-1,0,0},{17,-1,0,0,2},{18,2,-1,0,0},{18,1,-1,0,0},{19,0,-1,0,0},{20,1,0,0,0},{20,2,0,0,0},{21,2,-1,0,0},{21,1,-1,0,0},{22,1,0,0,0},{22,2,0,0,0},{23,0,-1,0,0},{24,2,0,0,0},{25,-1,-1,0,0},{25,0,0,0,0},{25,-1,0,0,2},{26,-2,-1,0,0},{27,-1,0,0,0},{28,0,-1,0,0},{29,-2,0,0,0},{30,2,1,0,0},{30,2,1,0,2},{31,0,1,0,0},{32,2,0,0,0},{33,1,1,0,0},{34,1,1,0,0},{34,2,2,0,2},{35,-1,1,0,0},{36,0,1,0,0},{36,-1,0,0,0},{37,-2,0,0,0},{38,-1,0,0,2},{38,-1,-1,0,0},{39,-1,0,0,0},{40,0,-1,0,0},{41,0,0,0,0},{42,-1,-1,0,0},{42,0,0,0,0},{42,-1,0,0,2},{43,-1,0,0,0},{44,1,0,0,2},{44,1,0,0,0},{44,2,0,0,0},{45,0,0,0,0},{46,0,-1,0,0},{47,0,-1,0,0},{48,0,-1,0,0},{49,0,0,0,0},{49,-1,0,0,2},{49,-1,-1,0,0},{50,-1,0,0,0},{51,-2,-1,0,0},{52,0,-1,0,0},{53,1,0,0,0},{53,2,0,0,0},{53,1,0,0,2},{54,0,0,0,0},{55,-1,0,0,0},{56,0,0,0,0},{56,-1,-1,0,0},{57,2,0,0,0},{58,-2,-1,0,0},{59,-1,0,0,0},{60,0,-1,0,0},{61,-1,0,0,2},{61,0,0,0,0},{61,-1,-1,0,0},{62,0,-1,0,0},{63,0,0,0,0},{64,0,0,0,0},{65,0,0,0,0}};
	if(k+1>a.length) return null;
	return a[k];
    }
}





