import java.awt.*;
import java.math.*;
import java.awt.geom.*;


public class PlaidClassifyFast {

    /**This gives an ad-hoc description of the plaid PET partition,
       which makes the drawing faster. However, it is hard to see
       what is going on theoretically*/

    public PlaidClassifyFast() {}



    /**Here is the forward PLAID Pet dynamics.
       Direction 1 is forwards and direction 0 is backwards.*/
    public static Vector4 plaidDynamics(Vector4 V0,int direction) {
	Vector4 V=plaidDynamicsRaw(V0,direction);
	V=PlaidClassifyingMap.reduce(V);
	return V;
    }

    /**This is without the reduction*/
    public static Vector4 plaidDynamicsRaw(Vector4 V0,int direction) {
	Vector4 RV0=PlaidClassifyingMap.reduce(V0);
	int[] a=plaidType(RV0);
	if(a[0]==a[1]) return V0;
	Vector4 V1=PlaidPolytopeMoves.map(a[direction],V0);
	return V1;
    }


    public static double layer(int choice,double P,double t,int i) {
	double[][] A={{-1,2-P+t,1-2*P,1-P,1},
                      {-1,+2-P+t,1-P,2+t,1},
                      {-1,t,1-P,2-P+t,1},
                      {-1,-1+P,t,1-P,1},
                      {-1,-2+P+t,-1+P,t,1},
                      {-1,-2+t,-1+P,-2+P+t,1},
                      {-1,-1+P,-1+2*P,-2+P+t,1}};
	return(A[choice][i]);
    }

    public static Complex[] box(double P,double t,int i,int j) {
	Complex z0=new Complex(layer(P,t,i+0),layer(P,t,j+0));
	Complex z1=new Complex(layer(P,t,i+0),layer(P,t,j+1));
	Complex z2=new Complex(layer(P,t,i+1),layer(P,t,j+1));
	Complex z3=new Complex(layer(P,t,i+1),layer(P,t,j+0));
	Complex[] Z={z0,z1,z2,z3};
	return(Z);
    }

    public static Path2D.Double boxPath(double P,double t,int i,int j) {
	Complex[] Z=box(P,t,i,j);
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(Z[0].x,Z[0].y);
	gp.lineTo(Z[1].x,Z[1].y);
	gp.lineTo(Z[2].x,Z[2].y);
	gp.lineTo(Z[3].x,Z[3].y);
	gp.closePath();
	return(gp);
    }

    public static Path2D.Double[][] boxPath(double P,double t) {
	Path2D.Double[][] gp=new Path2D.Double[4][4];
	int count=0;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		gp[i][j]=boxPath(P,t,i,j);
	    }
	}
	return(gp);
    }

    /**controls the layering of the lines*/
    public static double layer(double P,double t,int i) {
	double[] A={-2,-1-P,-1,-1+P,1-P,1,1+P,2};
	for(int u=0;u<7;++u) {
	    if((t>A[u])&&(t<=A[u+1])) return layer(u,P,t,i);
	}
	return(0);
    }

    /**This is does the classifying map and then finds the type of
       partition piece.*/

    public static int[] plaidType(Vector4 V) {
	return classify(V.x[0],V.x[1],V.x[2],V.x[3]);
    }

    public static int[] classify(double t,double x,double y,double P) {
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		Path2D.Double gp=boxPath(P,t,i,j);
		if(gp.contains(x,y)==true) return fix(P,t,i,j);
	    }
	}
	return(null);
    }


    public static int[] fix(double P,double t,int i,int j) {
	double[] A={-2,-1-P,-1,-1+P,1-P,1,1+P,2};
	for(int u=0;u<7;++u) {
	    if((t>A[u])&&(t<=A[u+1])) {
                return fix(u,i,j);
	    }
	}
	int[] x={0,0,0,0};
	return(x);
    }

    public static int[] fix(int u,int i,int j) {
	int[][] a={{1,3,0,2},{1,0,3,2},{2,3,0,1},{2,1,3,0},{3,2,1,0},{0,1,2,3},{0,2,1,3}};
	int[][] b={{1,3,2,0},{1,2,3,0},{0,3,2,1},{0,1,3,2},{3,0,1,2},{2,1,0,3},{2,0,1,3}};
	int[] I1={a[u][i],b[u][j]};
	int[] I2={b[u][j],a[u][i]};
	if((u>1)&&(u<5)) return(I2);
	return(I1);
    }



}



